<?php

include_once "DBManager.php";

class ContentManager{

    public $dbmanager;
  
    public function __construct(){
      $this->dbmanager = new DBManager();
    }

/* ----------------------------------------------------------------- */
/*                            GET Functions                          */

public function getEvents() {
  $query = "SELECT * FROM Events";
  return $this->dbmanager->ExecutePrepared($query, "", []);
}

public function getEventsByTime($contentManager, $PUBLIC_KEY_regiondo, $location_id_papershift, $start_at, $end_at, $now) {
  $matching_standort_id = $this->matchingStandortFinden($PUBLIC_KEY_regiondo, $location_id_papershift, $contentManager);
  if (!$matching_standort_id) {
      throw new Exception("Kein passender Standort gefunden für: " . $PUBLIC_KEY_regiondo);
  }
  $now = $now->format('Y-m-d H:i:s');

  $query = "SELECT * FROM Events 
            WHERE date_start BETWEEN ? AND ?
            AND date_start > ? AND matching_standort_id = ?";
            
  $types = "ssss";
  $params = [$start_at, $end_at, $now, $matching_standort_id];

  return $this->dbmanager->ExecutePrepared($query, $types, $params);
}

public function getEventByShiftIdPapershift($schichtPapershift_id) {
  $query = "SELECT * FROM Events WHERE shift_id_papershift = ?";
  $types = "i"; 
  $params = [$schichtPapershift_id];

  return $this->dbmanager->ExecutePrepared($query, $types, $params);
}

public function getEventByShiftIdRegiondo($PUBLIC_KEY_regiondo, $location_id_papershift, $contentManager, $shift_id_regiondo) {
  $matching_standort_id = $this->matchingStandortFinden($PUBLIC_KEY_regiondo, $location_id_papershift, $contentManager);
  if (!$matching_standort_id) {
      throw new Exception("Kein passender Standort gefunden für: " . $PUBLIC_KEY_regiondo);
  }
  $query = "SELECT * FROM Events WHERE shift_id_regiondo = ? AND matching_standort_id = ?";
  $types = "ss"; 
  $params = [$shift_id_regiondo, $matching_standort_id];

  return $this->dbmanager->ExecutePrepared($query, $types, $params);
}

public function getTime_block() {
  $query = "SELECT * FROM Time_block";
  return $this->dbmanager->ExecutePrepared($query, "", []);
}
// public function getTime_block_with_date($date) {
//   $query = "SELECT * FROM Time_block WHERE datum = ?";
//   $types = "s";
//   $params = [$date];
//   return $this->dbmanager->ExecutePrepared($query, $types, $params);
// }

public function getTime_block_with_date($date) {
  $query = "SELECT * FROM Time_block WHERE DATE(start_at) = ?";
  $types = "s";
  $params = [$date]; // z. B. '2025-06-11'
  return $this->dbmanager->ExecutePrepared($query, $types, $params);
}


public function getTime_block_with_date_with_assignment_mainShift($date, $user_id, $main_shift_id) {
  $query = "SELECT * FROM Time_block WHERE datum = ? AND user_id = ? AND main_shift_id = ?";
  $types = "sss";
  $params = [$date, $user_id, $main_shift_id];
  return $this->dbmanager->ExecutePrepared($query, $types, $params);
}

public function getAsseigment() {
  $query = "SELECT * FROM Asseigment";
  return $this->dbmanager->ExecutePrepared($query, "", []);
}
public function getAsseigmentByUserIdAndMain_shift_id($user_id, $main_shift_id) {
  $query = "SELECT * FROM Asseigment WHERE user_id = ? AND main_shift_id = ?";
  $types = "is";
  $params = [$user_id, $main_shift_id];
  return $this->dbmanager->ExecutePrepared($query, $types, $params);
}
public function getAsseigmentByMain_shift_id($main_shift_id) {
  $query = "SELECT username FROM Asseigment WHERE main_shift_id = ?";
  $types = "i";
  $params = [$main_shift_id];
  return $this->dbmanager->ExecutePrepared($query, $types, $params);
}
public function getAsseigmentByDate($date) {
  $date = date("Y-m-d H:i:s", strtotime($date)); 
  $main_shift_start_at = date("Y-m-d H:i:s", strtotime($date));
  $query = "SELECT * FROM Asseigment WHERE date = ?";
  $types = "s";
  $params = [$main_shift_start_at];
  return $this->dbmanager->ExecutePrepared($query, $types, $params);
}

public function MatchingStandorts() {
  $query = "SELECT * FROM MatchingStandorte";
  return $this->dbmanager->ExecutePrepared($query, "", []);
}

public function MatchingStandorteById($PUBLIC_KEY_regiondo, $location_id_papershift) {
  $query = "SELECT * FROM MatchingStandorte WHERE PUBLIC_KEY_regiondo = ? AND id_standort_papershift = ?";
  $types = "si";
  $params = [$PUBLIC_KEY_regiondo, $location_id_papershift];
  return $this->dbmanager->ExecutePrepared($query, $types, $params);
}

public function getMain_shifts_datum($date, $PUBLIC_KEY_regiondo, $location_id_papershift, $contentManager) {
  $matching_standort_id = $this->matchingStandortFinden($PUBLIC_KEY_regiondo, $location_id_papershift, $contentManager);
  if (!$matching_standort_id) {
      throw new Exception("Kein passender Standort gefunden für: " . $PUBLIC_KEY_regiondo);
  }
  $date = date("Y-m-d H:i:s", strtotime($date)); 
  $query = "SELECT * FROM Main_shifts WHERE date = ? AND matching_standort_id = ?";
  $types = "ss";
  $params = [$date, $matching_standort_id];
  return $this->dbmanager->ExecutePrepared($query, $types, $params);
}
public function getMain_shift($main_shift_id, $PUBLIC_KEY_regiondo, $location_id_papershift, $contentManager) {
  $matching_standort_id = $this->matchingStandortFinden($PUBLIC_KEY_regiondo, $location_id_papershift, $contentManager);
  if (!$matching_standort_id) {
      throw new Exception("Kein passender Standort gefunden für: " . $PUBLIC_KEY_regiondo);
  }
  $query = "SELECT * FROM Main_shifts WHERE main_shift_id = ? AND matching_standort_id = ?";
  $types = "ss";
  $params = [$main_shift_id, $matching_standort_id];
  return $this->dbmanager->ExecutePrepared($query, $types, $params);
}

public function MatchingStandorteByPublickey_regiondo($PUBLIC_KEY_regiondo) {
  $query = "SELECT * FROM MatchingStandorte WHERE PUBLIC_KEY_regiondo = ?";
  $types = "s";
  $params = [$PUBLIC_KEY_regiondo];
  return $this->dbmanager->ExecutePrepared($query, $types, $params);
}

/* ----------------------------------------------------------------- */
/* ----------------------------------------------------------------- */
/*                            POST Functions                         */
//200
public function createEvent($contentManager, $schichtPapershift_id, $workingarea_id_papershift, $note_hash_regiondo, $shift_id_regiondo, $variation_id, $product_id, $date_start, $date_end, $PUBLIC_KEY_regiondo, $location_id_papershift) {
  $matching_standort_id = $this->matchingStandortFinden($PUBLIC_KEY_regiondo, $location_id_papershift, $contentManager);
  if (!$matching_standort_id) {
      throw new Exception("Kein passender Standort gefunden für: " . $PUBLIC_KEY_regiondo);
  }

  $query = "INSERT INTO Events (`variation_id`, `product_id`, `shift_id_papershift`, `workingarea_id`, `shift_id_regiondo`, `note_hash_regiondo`, `date_start`, `date_end`, `matching_standort_id`)
  VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";

  $types = "sssssssss";
  $params = [$variation_id, $product_id, $schichtPapershift_id, $workingarea_id_papershift, $shift_id_regiondo, $note_hash_regiondo, $date_start, $date_end, $matching_standort_id];
  return $this->dbmanager->ExecutePrepared($query, $types, $params);
}

public function createLog($contentManager, $PUBLIC_KEY_regiondo, $location_id_papershift, $tabelle, $opration, $message) {
  $matching_standort_id = $this->matchingStandortFinden($PUBLIC_KEY_regiondo, $location_id_papershift, $contentManager);
  if (!$matching_standort_id) {
      throw new Exception("Kein passender Standort gefunden für: " . $PUBLIC_KEY_regiondo);
  }

  $query = "INSERT INTO Log (`operation`, `tabelle`, `beschreibung`, `matching_standort_id`)
            VALUES (?, ?, ?, ?)";

  $types = "ssss";
  $params = [$opration, $tabelle, $message, $matching_standort_id];

  return $this->dbmanager->ExecutePrepared($query, $types, $params);
}

public function createAsseigment($username, $user_id, $main_shift_name, $main_shift_id, $gap_workingarea_id, $gap_workingarea_name, $date, $main_shift_start_at, $main_shift_end_at) {
  $date = date("Y-m-d H:i:s", strtotime($date)); 
  $main_shift_start_at = date("Y-m-d H:i:s", strtotime($main_shift_start_at));
  $main_shift_end_at = date("Y-m-d H:i:s", strtotime($main_shift_end_at));

  $query = "INSERT INTO Asseigment (`username`, `user_id`, `main_shift_name`, `main_shift_id`, `gap_workingarea_id`, `gap_workingarea_name`, `date`, `main_shift_start_at`, `main_shift_end_at`)
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
  
  $types = "sisisssss"; 
  $params = [$username, $user_id, $main_shift_name, $main_shift_id, $gap_workingarea_id, $gap_workingarea_name, $date, $main_shift_start_at, $main_shift_end_at];

  return $this->dbmanager->ExecutePrepared($query, $types, $params);
}


// public function createAsseigment($username, $user_id, $main_shift_name, $main_shift_id, $gap_workingarea_id, $gap_workingarea_name, $date, $main_shift_start_at, $main_shift_end_at) {
//   $dateOnly = date("Y-m-d", strtotime($date));
//   $date = $dateOnly . " 00:00:00";

//   $main_shift_start_at = $this->safeDateTime($dateOnly, $main_shift_start_at);
//   $main_shift_end_at = $this->safeDateTime($dateOnly, $main_shift_end_at);

//   $query = "INSERT INTO Asseigment (`username`, `user_id`, `main_shift_name`, `main_shift_id`, `gap_workingarea_id`, `gap_workingarea_name`, `date`, `main_shift_start_at`, `main_shift_end_at`)
//             VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
//   $types = "sisisssss"; 
//   $params = [$username, $user_id, $main_shift_name, $main_shift_id, $gap_workingarea_id, $gap_workingarea_name, $date, $main_shift_start_at, $main_shift_end_at];

//   return $this->dbmanager->ExecutePrepared($query, $types, $params);
// }


public function createTimeBlock(
  $user_id, $username, $date,
  $start_at_shift, $end_at_shift,
  $shift_id, $main_shift_id, $main_shift_name,
  $main_shift_start_at, $main_shift_end_at,
  $virtual_workingarea_id, $virtual_workingarea_name,
  $pause, $status,
  $debug = false
) {
  // Nur das Datum extrahieren
  $dateOnly = date("Y-m-d", strtotime($date));
  $date = $dateOnly . " 00:00:00";

  // Zeitwerte sicher kombinieren
  $start_at_shift       = $this->safeDateTime($dateOnly, $start_at_shift);
  $end_at_shift         = $this->safeDateTime($dateOnly, $end_at_shift);
  $main_shift_start_at  = $this->safeDateTime($dateOnly, $main_shift_start_at);
  $main_shift_end_at    = $this->safeDateTime($dateOnly, $main_shift_end_at);

  // SQL + Parameter
  $query = "INSERT INTO Time_block (
      `user_id`, `username`, `datum`, `start_at`, `end_at`,
      `shift_id`, `main_shift_id`, `main_shift_name`,
      `main_shift_start_at`, `main_shift_end_at`,
      `virtual_workingarea_id`, `virtual_workingarea_name`,
      `pause`, `status`
  ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

  $types = "ssssssssssssss";
  $params = [
    $user_id, $username, $date,
    $start_at_shift, $end_at_shift,
    $shift_id, $main_shift_id, $main_shift_name,
    $main_shift_start_at, $main_shift_end_at,
    $virtual_workingarea_id, $virtual_workingarea_name,
    $pause, $status
  ];

  if ($debug) {
    echo "<pre><strong>DEBUG createTimeBlock</strong>\n";
    echo "📅 Datum: $date\n";
    echo "▶ Start: $start_at_shift\n";
    echo "⏹ Ende: $end_at_shift\n";
    echo "↘ Main Start: $main_shift_start_at\n";
    echo "↗ Main Ende: $main_shift_end_at\n";
    echo "📦 Params:\n";
    var_dump($params);
    echo "\n🧾 SQL:\n$query\n";
    echo "</pre>";
    return true;
  }

  return $this->dbmanager->ExecutePrepared($query, $types, $params);
}

// public function createTimeBlock($user_id, $username, $date, $start_at_shift, $end_at_shift, $shift_id, $main_shift_id, $main_shift_name, $main_shift_start_at, $main_shift_end_at, $virtual_workingarea_id, $virtual_workingarea_name, $pause, $status) {
//   $date = date("Y-m-d H:i:s", strtotime($date)); 
//   $start_at_shift = date("Y-m-d H:i:s", strtotime($start_at_shift));
//   $end_at_shift = date("Y-m-d H:i:s", strtotime($end_at_shift));
//   $main_shift_start_at = date("Y-m-d H:i:s", strtotime($main_shift_start_at));
//   $main_shift_end_at = date("Y-m-d H:i:s", strtotime($main_shift_end_at));

//   $query = "INSERT INTO Time_block (`user_id`, `username`, `datum`, `start_at`, `end_at`, `shift_id`,`main_shift_id`,`main_shift_name`, `main_shift_start_at`, `main_shift_end_at`, `virtual_workingarea_id`, `virtual_workingarea_name`, `pause`, `status`)
//             VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
  
//   $types = "ssssssssssssss"; 
//   $params = [$user_id, $username, $date, $start_at_shift, $end_at_shift, $shift_id, $main_shift_id, $main_shift_name, $main_shift_start_at, $main_shift_end_at, $virtual_workingarea_id, $virtual_workingarea_name, $pause, $status];

//   return $this->dbmanager->ExecutePrepared($query, $types, $params);
// }


public function createTimeBlockWithpauseID($user_id, $username, $date, $start_at_shift, $end_at_shift, $shift_id, $main_shift_id, $main_shift_name, $main_shift_start_at, $main_shift_end_at, $virtual_workingarea_id, $virtual_workingarea_name, $pause, $status, $nachPause_id, $vorPause_id) {
  //noch nicht überpruft.
  $dateOnly = date("Y-m-d", strtotime($date));
  $date = $dateOnly . " 00:00:00";

  // Zeitfelder mit dem gewünschten Datum kombinieren
  $start_at_shift = $this->combineDateWithTime($dateOnly, $start_at_shift);
  $end_at_shift = $this->combineDateWithTime($dateOnly, $end_at_shift);
  $main_shift_start_at = $this->combineDateWithTime($dateOnly, $main_shift_start_at);
  $main_shift_end_at = $this->combineDateWithTime($dateOnly, $main_shift_end_at);

  $query = "INSERT INTO Time_block (`user_id`, `username`, `datum`, `start_at`, `end_at`, `shift_id`,`main_shift_id`,`main_shift_name`, `main_shift_start_at`, `main_shift_end_at`, `virtual_workingarea_id`, `virtual_workingarea_name`, `pause`, `status`, `nachPause_id`, `vorPause_id`)
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
  
  $types = "ssssssssssssssss"; 
  $params = [$user_id, $username, $date, $start_at_shift, $end_at_shift, $shift_id, $main_shift_id, $main_shift_name, $main_shift_start_at, $main_shift_end_at, $virtual_workingarea_id, $virtual_workingarea_name, $pause, $status, $nachPause_id, $vorPause_id];

  return $this->dbmanager->ExecutePrepared($query, $types, $params);
}

public function createMatchingStandort($contentManager, $PUBLIC_KEY_regiondo, $standortPapershift_id) {
  $listMatchingStandorts = $contentManager->MatchingStandorts();
  $exist = false;
  foreach ($listMatchingStandorts as $standorts) {
      $PUBLIC_KEY_reg = $standorts->PUBLIC_KEY_regiondo;
      $id_standort_papershift = $standorts->id_standort_papershift;
      if  ($standortPapershift_id == $id_standort_papershift && $PUBLIC_KEY_regiondo == $PUBLIC_KEY_reg) {
          $exist = true;
      }
  }
  if (!$exist) {
      $query = "INSERT INTO MatchingStandorte (`PUBLIC_KEY_regiondo`, `id_standort_papershift`)
      VALUES (?, ?)";

      $types = "ss";

      $params = [$PUBLIC_KEY_regiondo, $standortPapershift_id];
      return $this->dbmanager->ExecutePrepared($query, $types, $params);
  }
  return false;
}

public function createMainShift($contentManager, $PUBLIC_KEY_regiondo, $location_id_papershift, $main_shift_id, $main_shift_name, $working_area_id, $date, $starts_at, $ends_at, $note_hash) {
  $matching_standort_id = $this->matchingStandortFinden($PUBLIC_KEY_regiondo, $location_id_papershift, $contentManager);
  if (!$matching_standort_id) {
      throw new Exception("Kein passender Standort gefunden für: " . $PUBLIC_KEY_regiondo);
  }
  $date = date("Y-m-d H:i:s", strtotime($date)); 
  $starts_at = date("Y-m-d H:i:s", strtotime($starts_at));
  $ends_at = date("Y-m-d H:i:s", strtotime($ends_at));
  $query = "INSERT INTO Main_shifts (`main_shift_id`, `main_shift_name`, `working_area_id`, `date`, `starts_at`, `ends_at`, `note_hash`, `matching_standort_id`)
            VALUES (?, ?, ?, ?, ?, ?, ?, ?)";

  $types = "ssssssss";
  $params = [$main_shift_id, $main_shift_name, $working_area_id, $date, $starts_at, $ends_at, $note_hash, $matching_standort_id];

  return $this->dbmanager->ExecutePrepared($query, $types, $params);
}
/* ----------------------------------------------------------------- */
/* ----------------------------------------------------------------- */
/*                           UPDATE Functions                        */
public function updateEvent($contentManager, $schichtPapershift_id, $note_hash_regiondo, $shift_id_regiondo, $date_start, $date_end, $PUBLIC_KEY_regiondo, $location_id_papershift) {
  $matching_standort_id = $this->matchingStandortFinden($PUBLIC_KEY_regiondo, $location_id_papershift, $contentManager);
  if (!$matching_standort_id) {
      throw new Exception("Kein passender Standort gefunden für: " . $PUBLIC_KEY_regiondo);
  }

  $query = "UPDATE Events 
            SET note_hash_regiondo = ?, 
                date_start = ?, 
                date_end = ?
            WHERE shift_id_papershift = ? 
              AND matching_standort_id = ? 
              AND shift_id_regiondo = ?";

  $types = "ssssss";
  $params = [$note_hash_regiondo, $date_start, $date_end, $schichtPapershift_id, $matching_standort_id, $shift_id_regiondo];
  return $this->dbmanager->ExecutePrepared($query, $types, $params);
}
public function fuegeNachPause_idInTimeBlock($schichtPapershift_id, $nachPause_id) {
  $query = "UPDATE Time_block 
            SET nachPause_id = ?
            WHERE shift_id = ?";
  
  $types = "is";
  $params = [$nachPause_id, $schichtPapershift_id];

  return $this->dbmanager->ExecutePrepared($query, $types, $params);
}
public function fuegeVorPause_idInTimeBlock($schichtPapershift_id, $vorPause_id) {
  $query = "UPDATE Time_block 
            SET vorPause_id = ?
            WHERE shift_id = ?";
  
  $types = "is";
  $params = [$vorPause_id, $schichtPapershift_id];

  return $this->dbmanager->ExecutePrepared($query, $types, $params);
}


/* ----------------------------------------------------------------- */
/* ----------------------------------------------------------------- */
/*                           DELETE Functions                        */
public function deleteTimeBlock($date, $shift_id, $user_id) {
  $date = date("Y-m-d", strtotime($date)); 
  $query = "DELETE FROM Time_block WHERE `datum` = ? and `shift_id` = ? and `user_id` = ?";

  $types = "sii"; 
  $params = [$date, $shift_id, $user_id];

  return $this->dbmanager->ExecutePrepared($query, $types, $params);
}

public function deleteEvent($shift_id) {
  $query = "DELETE FROM Events WHERE `shift_id_papershift` = ?";

  $types = "s"; 
  $params = [$shift_id];

  return $this->dbmanager->ExecutePrepared($query, $types, $params);
}

public function deleteOldEvents($datenbank_vorgestern, $matching_standort_id_Global) {

  $query = "DELETE FROM Events WHERE `date_end` <= ? and `matching_standort_id` = ?";
  
  $types = "ss"; 
  $params = [$datenbank_vorgestern, $matching_standort_id_Global];
  
  return $this->dbmanager->ExecutePrepared($query, $types, $params);
}
public function deleteOldTimeBlock($datenbank_vorgestern) {

  $datum = (new DateTime($datenbank_vorgestern))->format('Y-m-d');

  $query = "DELETE FROM Time_block WHERE `datum` <= ?";
  $types = "s"; 

  $params = [$datum];

  return $this->dbmanager->ExecutePrepared($query, $types, $params);

}

public function deleteAssignment($user_id, $main_shift_id, $date) {
  // Sicherstellen, dass $date ein DateTime-Objekt ist
   $date = new DateTime($date);
  // In korrektes MySQL-Format umwandeln
  $dateFormatted = $date->format('Y-m-d H:i:s');
  // SQL-Query
  $query = "DELETE FROM Asseigment WHERE `user_id` = ? AND `main_shift_id` = ? AND `date` = ?";
  $types = "iis"; // i = integer, i = integer, s = string

  // Parameterübergabe
  $params = [$user_id, $main_shift_id, $dateFormatted];

  return $this->dbmanager->ExecutePrepared($query, $types, $params);
}


public function deleteAssignment_test($start_date, $end_date) {
  $start_date = new DateTime($start_date);
  $end_date = new DateTime($end_date);

  $start_dateFormatted = $start_date->format('Y-m-d H:i:s');
  $end_dateFormatted = $end_date->format('Y-m-d H:i:s');

  $query = "DELETE FROM Asseigment WHERE `date` >= ? AND `date` <= ?";
  $types = "ss"; 
  $params = [$start_dateFormatted, $end_dateFormatted];

  return $this->dbmanager->ExecutePrepared($query, $types, $params);
}

public function deleteOldAsseigment($datenbank_vorgestern) {

  $query = "DELETE FROM Asseigment WHERE `date` <= ?";
  $types = "s"; 

  $params = [$datenbank_vorgestern];

  return $this->dbmanager->ExecutePrepared($query, $types, $params);
}

/* ----------------------------------------------------------------- */
/* ----------------------------------------------------------------- */
/*                       Local helper functions                      */

function matchingStandortFinden($PUBLIC_KEY, $location_id_papershift, $contentManager) {
  $matchingStandorts = $contentManager->MatchingStandorteByPublickey_regiondo($PUBLIC_KEY);
  foreach ($matchingStandorts as $standort) {
      $PUBLIC_KEY_regiondo = $standort->PUBLIC_KEY_regiondo;
      $id_standort_papershift = $standort->id_standort_papershift;
      if (strtolower(trim($PUBLIC_KEY_regiondo)) == strtolower(trim($PUBLIC_KEY)) && $id_standort_papershift == $location_id_papershift) return $standort->id;
  }
}

private function combineDateWithTime($date, $time) {
  // Wenn Zeit schon Datum enthält → verwende direkt
  if (preg_match('/\d{4}-\d{2}-\d{2}/', $time)) {
    return date("Y-m-d H:i:s", strtotime($time));
  }
  // sonst Datum + Zeit kombinieren
  return date("Y-m-d H:i:s", strtotime("$date $time"));
}

private function safeDateTime($date, $time) {
  $time = trim($time);
  
  // Falls Zeit bereits Datum enthält, einfach verwenden
  if (preg_match('/^\d{4}-\d{2}-\d{2}[\sT]\d{2}:\d{2}(:\d{2})?$/', $time)) {
    return date("Y-m-d H:i:s", strtotime($time));
  }

  // Nur Uhrzeit → Datum anhängen
  return date("Y-m-d H:i:s", strtotime("$date $time"));
}



/* ----------------------------------------------------------------- */
    
}