<?php

class DBManager {

    private $db_ip;
    private $db_user;
    private $db_passwort;
    private $db_database;
    private $connection;

/* ----------------------------------------------------------------- */
/*                       Local helper functions                      */
    public function __construct() {
        $this->db_ip = "localhost:3306";
        $this->db_user = "root";
        $this->db_passwort = "rasam";
        $this->db_database = "regiondo_papershift";
        $this->connect();
    }
  
     // Private Methode zur Herstellung der Verbindung zur Datenbank.
     private function connect() {
        // Erstellt eine neue MySQLi-Verbindung.
        $this->connection = new mysqli($this->db_ip, $this->db_user, $this->db_passwort, $this->db_database);

        // Falls ein Fehler bei der Verbindung auftritt, wird die Anwendung gestoppt.
        if ($this->connection->connect_error) {
            die("Verbindung fehlgeschlagen: " . $this->connection->connect_error);
        }
    }

    // Gibt die aktuelle Datenbankverbindung zurück.
    public function GetConnection() {
        return $this->connection;
    }

    // Führt eine SQL-Abfrage aus, die keine Ergebnisse zurückgibt (z.B. INSERT, UPDATE, DELETE).
    public function ExecuteWithoutQuery($query) {
        $result = $this->connection->query($query);

        if ($result === false) {
            error_log("Datenbankabfrage fehlgeschlagen: " . $this->connection->error);
            return false;
        }

        return $this->connection->insert_id;
    }

    // Führt eine SQL-Abfrage aus und gibt das Ergebnis zurück.
    public function Execute($query) {
        $result = $this->connection->query($query);

        if ($result === false) {
            error_log("Datenbankabfrage fehlgeschlagen: " . $this->connection->error);
            return false;
        }

        if ($result === true) {
            return true;
        }

        $result_array = [];
        while ($row = $result->fetch_object()) {
            $result_array[] = $row;
        }

        return $result_array;
    }

    public function ExecutePrepared($query, $types = null, $params = null) {
        $stmt = $this->connection->prepare($query);
    
        // Prüfen, ob das Statement erfolgreich vorbereitet wurde
        if ($stmt === false) {
            error_log("Fehler beim Vorbereiten der Abfrage: " . $this->connection->error);
            return false;
        }
    
        // Parameter nur binden, wenn sie vorhanden sind
        if (!empty($types) && !empty($params)) {
            if (!$stmt->bind_param($types, ...$params)) {
                error_log("Fehler beim Binden der Parameter: " . $stmt->error);
                return false;
            }
        }
    
        // Abfrage ausführen
        if (!$stmt->execute()) {
            error_log("Fehler bei der Ausführung der Abfrage: " . $stmt->error);
            return false;
        }
    
        // Ergebnisse abrufen
        $result = $stmt->get_result();
    
        // Wenn kein Ergebnis zurückgegeben wird
        if ($result === false) {
            // Prüfen, ob es sich um einen INSERT handelt
            if (stripos(trim($query), 'insert') === 0) {
                return $this->connection->insert_id; // ID des eingefügten Datensatzes zurückgeben
            }
    
            // Prüfen, ob Zeilen betroffen sind (UPDATE, DELETE)
            if ($this->connection->affected_rows > 0) {
                return true;
            } else {
                return false; // Keine Zeilen betroffen
            }
        }
    
        // Ergebnisse als Array von Objekten speichern
        $result_array = [];
        while ($row = $result->fetch_object()) {
            $result_array[] = $row;
        }
    
        $stmt->close();
    
        return $result_array;
    }
    
    public function ping() {
        return $this->connection->ping();
    }

    public function reconnect() {
        $this->connection->close();
        $this->connect();
    }

    public function errorInfo() {
        return $this->connection->error;
    }
/* ----------------------------------------------------------------- */

}

?>