# James Zeitblock-System

Dieses PHP-Projekt dient der Verwaltung, Verarbeitung und Visualisierung von Zeitblöcken, insbesondere im Kontext von Mitarbeitereinsatzplanung, Schichtverarbeitung oder Zeiterfassung. Die Komponenten ermöglichen das Einlesen, Bearbeiten und Zuweisen von Zeitabschnitten und verbinden sich dabei über ein zentrales Content-Management-Modul.

**Autor**: Rasam Bakhtiari  
**Lizenz**: Ananas.codes

---

## Struktur

### 0. `globals.php`
Diese Datei enthält zentrale Konfigurationswerte und Zugangsdaten für externe APIs (z. B. Regiondo, Papershift). Alle sicherheitsrelevanten Informationen wie API-Schlüssel, Tokens oder Domains sollten hier zentral verwaltet werden, um sie in der gesamten Anwendung nutzen zu können.

**Beispielhafte Inhalte:**
- API-Key für Regiondo
- API-Key für Papershift

**Wichtig:** Trage alle Zugangsdaten und API-Schlüssel vollständig in dieser Datei ein, bevor du das System verwendest.

---

### 1. `DBManager.php`
Diese Datei dient dem Aufbau und der Verwaltung der Datenbankverbindung. Sie enthält die Zugangsdaten zur Datenbank (Host, Benutzername, Passwort, Datenbankname) und stellt sicher, dass alle SQL-Operationen zentral über eine sichere Verbindung erfolgen.

**Hauptfunktionen:**
- Aufbau einer sicheren Verbindung zu einer MySQL- oder MariaDB-Datenbank
- Behandlung möglicher Verbindungsfehler
- Bereitstellung einer zentralen Anlaufstelle für alle Datenbankanfragen

**Wichtig:** Achte darauf, dass alle Zugangsdaten korrekt und sicher eingetragen sind.

---

### 2. `james.php`
Dies ist das Einstiegsskript des Systems. Es verarbeitet Anfragen, steuert den Ablauf und dient als Controller. Je nach GET- oder POST-Parametern führt es Aktionen wie das Einlesen von Daten, das Erstellen oder Aktualisieren von Zeitblöcken oder das Ausgeben der Daten im Frontend durch.

### 3. `time_block.php`
Diese Datei enthält die zentrale Logik zur Berechnung und Verwaltung von Zeitblöcken. Hier werden Zeitabschnitte analysiert, unterteilt, kombiniert und ggf. mit Ereignissen oder Mitarbeitenden verknüpft. Sie bildet das Herzstück der Zeitlogik.

**Beispiele für Funktionen:**
- Umwandlung von Zeiträumen in Zeitblöcke
- Zusammenführung benachbarter Lücken („Gaps“)
- Filterung nach Typen wie „belegt“, „frei“, „gap“

### 4. `ContentManager.php`
Das zentrale Datenzugriffsobjekt (DAO) für den Zugriff auf die Datenbank. Enthält Methoden zum:
- Einlesen und Speichern von Zuweisungen
- Abfragen von Zeiträumen und Zuordnungen
- Pflegen von Verbindungen zwischen Nutzern, Zeitblöcken und weiteren Metadaten

### 5. `time.php`
Enthält Hilfsfunktionen zur Arbeit mit Zeitangaben. Bietet Methoden zum Rechnen mit `DateTime`-Objekten, Formatierungen und Vergleichen von Zeiträumen.

**Beispielmethoden:**
- Umwandlung von Zeitformaten
- Addition und Subtraktion von Zeitspannen
- Berechnung von Differenzen

---

## Voraussetzungen

- PHP 8.0 oder höher
- MySQL oder MariaDB
- Webserver (z. B. Apache oder Nginx)

---

## Nutzung

1. Konfiguration der Datenbankverbindung in `ContentManager.php`
2. Zugangsdaten und API-Keys in der Datei `global.php` eintragen
3. Aufruf von `james.php` mit den entsprechenden Parametern
4. Die Ausgabe erfolgt als JSON oder HTML, je nach aufrufender Umgebung

---

## Dokumentation und Anleitung

Für die Verwendung und Details zur Bedienung der einzelnen Tools lies bitte das PDF:  
📄 **Anleitung_regiondo_papershift.pdf**

---

## Mögliche Einsatzszenarien

- **Schichtplanung:** Automatische Aufteilung von Arbeitszeiten in logische Blöcke
- **Zeiterfassung:** Auswertung von Arbeits-, Pausen- oder Gap-Zeiten
- **Zuweisungslogik:** Verknüpfung von Mitarbeitenden mit freien oder belegten Zeitblöcken

---

## Erweiterungsideen
