<?php
/* ---------------------------------------------------------------- */
/* Include required external definitions */   //letzte zustand wurde im james3.php gespeicehr hamon ke virtuelle workingarea dare.
include_once "log.php";
include_once "globals.php";
include_once "time.php";
require_once 'papershiftFunctions.php';
include_once "regiondoFunctions.php";
include_once "time_block.php";
include_once __DIR__ . "/ContentManager.php";
/* ---------------------------------------------------------------- */
$contentManager = NEW ContentManager();
$verwaltung = new personen_verwaltung();





// Start der Messung
$museum_product_id = [312018, 307312, 295813, 295812, 295558, 295307, 295556, 295559, 295434, 295262, 295306, 295260, 295259, 295118, 295115, 295113, 295109, 284033];
$werk_product_id = [305894, 304234, 299120, 299118, 295562, 295561, 295560, 295539, 295538, 295522, 295526, 295535, 295534, 295310, 295309, 295308, 295270, 295273, 295264, 295143, 295138, 295136, 295132, 295120, 295101, 284030, 277044, 307321, 295281, 307322, 295154, 295142, 307333, 307329, 295549, 295545];
$kids_product_id = [304234, 295270, 295273, 312018, 295262, 295260, 295259];

$pause_groupe = 14;
$pause_kind_groupe = 29;

try {

    $getMatchingStandorteById_DB = $contentManager->MatchingStandorteById($PUBLIC_KEY, $location_id);
    if ($getMatchingStandorteById_DB) {
        $matching_standort_id_Global = $getMatchingStandorteById_DB[0]->id;
    } else {
        $matching_standort_id_Global = $contentManager->createMatchingStandort($contentManager, $PUBLIC_KEY, $location_id);
    }

    $contentManager->deleteOldEvents($datenbank_vorgestern, $matching_standort_id_Global);
    $contentManager->deleteOldTimeBlock($datenbank_vorgestern);
    $contentManager->deleteOldAsseigment($datenbank_vorgestern);

    $start = startTimer();
    $workingsAreaesMainshifts = workingsAreaesMainshifts($apikeyPapershift, $location_id);
    stopTimerForFunctions($start, "workingsAreaesMainshifts");

    $start = startTimer();
    $workingAreasPapershift = getWorkingAreasPapershift(api_token: $apikeyPapershift, location_id: $location_id)->working_areas;
    stopTimerForFunctions($start, "getWorkingAreasPapershift");

    $start = startTimer();
    $grouped_workingareas = groupWorkingAreasByProductGroup($workingAreasPapershift, $werk_product_id, $museum_product_id);
    stopTimerForFunctions($start, "groupWorkingAreasByProductGroup");

    $start = startTimer();
    $grouped_kids_workingareas = group_kidsWorkingAreasByProductGroup($workingAreasPapershift, $kids_product_id);
    stopTimerForFunctions($start, "group_kidsWorkingAreasByProductGroup");

    $start = startTimer();
    $shiftArrayPapershift = getShiftPapershift(api_token: $apikeyPapershift, location_id: $location_id, range_start: $rangeStartYesterday, range_end: $rangeEnd);
    stopTimerForFunctions($start, "getShiftPapershift");

    $start = startTimer();
    $usersPapershift = getUsersPapershift(api_token: $apikeyPapershift, location_ids: $location_id);
    stopTimerForFunctions($start, "getUsersPapershift");

    $start = startTimer();
    $shiftArrayPapershift = filterSchichtenVorZeit($shiftArrayPapershift, $timeZone, $rangeEndMitZeit, $rangeStartMitZeit);
    stopTimerForFunctions($start, "filterSchichtenVorZeit");

    $start = startTimer();
    $shiftArrayMitAsseigmentPapershift = shiftArrayMitAsseigmentPapershift($apikeyPapershift, $shiftArrayPapershift);
    stopTimerForFunctions($start, "shiftArrayMitAsseigmentPapershift");

    $start = startTimer();
    $tags = getTagsPapershift(api_token: $apikeyPapershift, location_id: $location_id)->filters;
    stopTimerForFunctions($start, "getTagsPapershift");

    $start = startTimer();
    $tags = papershiftTagErstellen($apikeyPapershift, $location_id, $tags);
    stopTimerForFunctions($start, "papershiftTagErstellen");

    foreach ($tags as $tag) {
        $id = $tag->id;
        $title = $tag->title;
        $external_id = $tag->external_id;
        switch ($external_id) {
            case "empty_shift":
                $empty_shift_tag_id = $id ?? null;
                break;
            case "inactive_user":
                $inactive_user_tag_id = $id ?? null;
                break;
            case "main_shift":
                $main_shift_tag_id = $id ?? null;
                break;
            case "gap_shift":
                $gap_shift_tag_id = $id ?? null;
                break;
            case "pause":
                $pause_tag_id = $id ?? null;
                break;
        }
    }

    $start = startTimer();
    $tags = getTagsPapershift(api_token: $apikeyPapershift, location_id: $location_id)->filters;
    stopTimerForFunctions($start, "getTagsPapershift");

    $start = startTimer();
    $sortierteSchichten = gruppiereSchichtenNachDatum($shiftArrayMitAsseigmentPapershift, $rangeStart, $rangeEnd, $timeZone);
    stopTimerForFunctions($start, "gruppiereSchichtenNachDatum");

    $date_range = generateDateRange($rangeStart, $rangeEnd);

    $start = startTimer();
    $main_shifts = collectMainShiftsWithAssignments($apikeyPapershift, $location_id, $sortierteSchichten, $workingAreasPapershift, $main_shift_tag_id, $rangeStart, $rangeEnd);
    stopTimerForFunctions($start, "collectMainShiftsWithAssignments");

    $start = startTimer();
    $sortierteSchichten = filterShiftsByGroupedWorkingareas($sortierteSchichten, $grouped_workingareas, $timeZone, $now, true);
    stopTimerForFunctions($start, "filterShiftsByGroupedWorkingareas");

    $start = startTimer();
    $products_regiondo_en = GETProductRegiondo('true', 'true', 'false', "en-US");
    stopTimerForFunctions($start, "GETProductRegiondo_en");

    $start = startTimer();
    $products_regiondo_de = GETProductRegiondo('true', 'true', 'false', "de-DE");
    stopTimerForFunctions($start, "GETProductRegiondo_de");

    $start = startTimer();
    $products_regiondo = array_merge($products_regiondo_en, $products_regiondo_de);
    stopTimerForFunctions($start, "array_merge-products_regiondo");

    $start = startTimer();
    $extracted_data = extractProductDetails($products_regiondo, $museum_product_id, $werk_product_id);
    stopTimerForFunctions($start, "extractProductDetails");

    $start = startTimer();
    $details_efficiently = extractProductDetailsEfficiently($extracted_data);
    stopTimerForFunctions($start, "extractProductDetailsEfficiently");

    $start = startTimer();
    $listOfBookingsRegiondo = listOfBookingsRegiondo($details_efficiently, $rangeStart, $rangeEnd);
    stopTimerForFunctions($start, "listOfBookingsRegiondo");

    $start = startTimer();
    $availabilities = availabilities_regiondo($details_efficiently, $rangeStart, $rangeEnd, $now, $listOfBookingsRegiondo);
    stopTimerForFunctions($start, "availabilities_regiondo");

    $start = startTimer();
    shift_control($contentManager, $PUBLIC_KEY, $apikeyPapershift, $location_id, $workingAreasPapershift, $sortierteSchichten, $listOfBookingsRegiondo, $details_efficiently, $availabilities, $rangeStart, $rangeEnd, $rangeStartMitZeit, $rangeEndMitZeit, $now, $timeZone);
    stopTimerForFunctions($start, "shift_control");

    $start = startTimer();
    $shiftArrayPapershift = getShiftPapershift(api_token: $apikeyPapershift, location_id: $location_id, range_start: $rangeStartYesterday, range_end: $rangeEnd);
    stopTimerForFunctions($start, "getShiftPapershift");

    $start = startTimer();
    $shiftArrayPapershift_new = filterSchichtenVorZeit($shiftArrayPapershift, $timeZone, $rangeEndMitZeit, $rangeStartMitZeit);
    stopTimerForFunctions($start, "filterSchichtenVorZeit");

    $start = startTimer();
    $shiftArrayMitAsseigmentPapershift_new = shiftArrayMitAsseigmentPapershift($apikeyPapershift, $shiftArrayPapershift_new);
    stopTimerForFunctions($start, "shiftArrayMitAsseigmentPapershift");

    $start = startTimer();
    $sortierteSchichten = gruppiereSchichtenNachDatum($shiftArrayMitAsseigmentPapershift_new, $rangeStart, $rangeEnd, $timeZone);
    stopTimerForFunctions($start, "gruppiereSchichtenNachDatum");
    $sortierteSchichten_groupe = $sortierteSchichten; // copy für assignment_zuweisen
    $sortierteSchichten_fullDay = $sortierteSchichten; // copy für TimeBlock überprüfen.

    $start = startTimer();
    $sortierteSchichten_fullDay = filterShiftsByGroupedWorkingareas($sortierteSchichten_fullDay, $grouped_workingareas, $timeZone, $now, false);
    stopTimerForFunctions($start, "filterShiftsByGroupedWorkingareas_ohne_zeit_filtern");

    $start = startTimer();
    $sortierteSchichten = filterShiftsByGroupedWorkingareas($sortierteSchichten, $grouped_workingareas, $timeZone, $now, true);
    stopTimerForFunctions($start, "filterShiftsByGroupedWorkingareas");

    if (!empty($main_shifts)) {
        $start = startTimer();
        createAsseigment_to_DB ($contentManager, $apikeyPapershift, $PUBLIC_KEY, $location_id, $main_shifts, $workingsAreaesMainshifts, $main_shift_tag_id, true);
        stopTimerForFunctions($start, "createAsseigment_to_DB");

        $start = startTimer();
        assignment_zuweisen ($verwaltung, $contentManager, $apikeyPapershift, $PUBLIC_KEY, $location_id, $grouped_workingareas, $usersPapershift, $empty_shift_tag_id ,$inactive_user_tag_id, $sortierteSchichten, $sortierteSchichten_groupe, $sortierteSchichten_fullDay, $main_shifts, $museum_product_id, $werk_product_id, $grouped_kids_workingareas, $workingsAreaesMainshifts, $date_range, $timeZone, $pause_groupe, $pause_tag_id, $gap_shift_tag_id, $pause_kind_groupe);
        stopTimerForFunctions($start, "assigment_zuweisen");

        $start = startTimer();
        createAsseigment_to_DB ($contentManager, $apikeyPapershift, $PUBLIC_KEY, $location_id, $main_shifts, $workingsAreaesMainshifts, $main_shift_tag_id, false);
        stopTimerForFunctions($start, "createAsseigment_to_DB");
    }

} catch (Throwable $e) {
    echo "<pre style='color:red;'>";
    echo "FEHLER: " . $e->getMessage() . "\n";
    echo "Datei: " . $e->getFile() . "\n";
    echo "Zeile: " . $e->getLine() . "\n";
    echo "Stacktrace:\n" . $e->getTraceAsString();
    echo "</pre>";
}



/* ----------------------------------------------------------------- */
/*                          Haupt functions                         */

function shift_control($contentManager, $PUBLIC_KEY, $apikeyPapershift, $location_id, $workingAreasPapershift, $sortierteSchichten, $listOfBookingsRegiondo, $details_efficiently, $list_availabilities, $rangeStart, $rangeEnd, $rangeStartMitZeit, $rangeEndMitZeit, $now, $timeZone) {

    // Sicherstellen, dass Regiondo, Datenbank und Papershift sauber synchronisiert sind.
    // $sortierteSchichten wird hier als Referenz an die Funktionen uebeuprufen_shifts_and_datenbank und deleteUnwichtigeShifte übergeben.
    uebeuprufen_shifts_and_datenbank($contentManager, $PUBLIC_KEY, $apikeyPapershift, $location_id, $sortierteSchichten, $rangeStartMitZeit, $rangeEndMitZeit, $now);
    $eventsByTime_DB = $contentManager->getEventsByTime($contentManager, $PUBLIC_KEY, $location_id, $rangeStartMitZeit, $rangeEndMitZeit, $now);
    if (!empty($eventsByTime_DB)) {
        deleteUnwichtigeShifte($contentManager, $apikeyPapershift, $eventsByTime_DB, $list_availabilities, $sortierteSchichten);
    }
    $eventsByTime_DB = $contentManager->getEventsByTime($contentManager, $PUBLIC_KEY, $location_id, $rangeStartMitZeit, $rangeEndMitZeit, $now);

    foreach($list_availabilities as $product_id => $availabilities) {
        foreach($availabilities as $variation_id => $availabilitie) {
            foreach($availabilitie as $date => $time_slots) {
                foreach($time_slots as $time_slot) {
                    foreach ($workingAreasPapershift as $workingarea) {
                        $wk_id = null;
                        foreach ($workingAreasPapershift as $workingarea) {
                
                            // $wk_external_id = strtolower(trim($workingarea->external_id));
                            $external_id_raw = $workingarea->external_id ?? '';
                            $wk_external_id = strtolower(trim((string)$external_id_raw));

                            if ($product_id == $wk_external_id) {
                                $wk_id = $workingarea->id;
                                break;
                            }
                        }
                        if ($wk_id == null) {
                            $message = "Workingarea ID nicht gefunden, Programm wird beendet. PRODUCT_ID = $product_id";
                            echo "$message<br>";
                            $contentManager->createLog($contentManager, $PUBLIC_KEY, $location_id, "Haupt_code", "EXIT", $message);
                            exit;
                        }
                    }
                $array_hash = [];

                // Zeitangaben als String zusammensetzen
                $starts_at_time = $time_slot["starts_at"];
                $ends_at_time = $time_slot["ends_at"];

                $start_at_string = "$date $starts_at_time";
                $start_at_string_for_DB = "$date" . "_" . $starts_at_time;
                
                $start_at = new DateTime($start_at_string);

                // Prüfen, ob das Ende am Folgetag liegt
                // Hinweis => Wenn die Endzeit "kleiner" ist (z. B. 00:00 nach 23:00), dann ist das am nächsten Tag
                if ($ends_at_time <= $starts_at_time) {
                    $end_date = (clone $start_at)->modify('+1 day');
                } else {
                    $end_date = clone $start_at;
                }

                $end_at_string = $end_date->format('Y-m-d') . " " . $ends_at_time;
                $end_at = new DateTime($end_at_string);

                // Notizen aus dem Slot
                $note = $time_slot["note"];
                $note_string = $note["note_string"] ?? "";
                $note_hash = $note["note_hash"] ?? "";

                // ID für Regiondo-Shift erzeugen
                $shift_id_regiondo = "{$product_id}_{$variation_id}_{$start_at_string_for_DB}";

                $array_hash ["shift_id_regiondo"] = $shift_id_regiondo;
                $array_hash ["starts_at"] = $start_at_string;
                $array_hash ["ends_at"] = $end_at_string;
                $array_hash ["variation_id"] = $variation_id;
                $array_hash ["product_id"] = $product_id;
                $array_hash ["time_slot"] = $time_slot;
                $array_hash ["note_string"] = $note_string;
                $array_hash ["note_hash"] = $note_hash;

                $found_shift = false;
                $found_shift = update_shifts($contentManager, $PUBLIC_KEY, $apikeyPapershift, $location_id, $array_hash, $eventsByTime_DB, $sortierteSchichten, $timeZone);
                    
                if (!$found_shift) {
                    $data = [
                        "api_token" => "$apikeyPapershift",
                        "shift" => [
                            "location_id" => "$location_id",
                            // "working_area_external_id" => "",
                            "working_area_id" => "$wk_id",
                            "starts_at" => $start_at->format(DATE_ATOM),
                            "ends_at" => $end_at->format(DATE_ATOM),
                            "number_of_employees" => 1,
                            "note" => "$note_string". "# Note :"
                        ]
                    ];
    
                    try {
                        $createShift = createNewShiftPapershift($data);
    
                        if (empty($createShift)) {
                            throw new Exception("Fehler in Papershift.");
                        }
                        $decodedResponse = json_decode($createShift, true);
    
                        if (json_last_error() !== JSON_ERROR_NONE) {
                            throw new Exception("Fehler beim Parsen der JSON-Antwort: " . json_last_error_msg());
                        }
                        if (!isset($decodedResponse['id'])) {
                            throw new Exception("Die Antwort enthält keine gültige Schicht-ID.");
                        }
                        echo "Schicht erfolgreich erstellt! Schicht-ID: " . $decodedResponse['id'] . "<br>";
                        echo "Antwort:<br>";
                        var_dump($createShift);
                        echo '</pre>';
                    } catch (Exception $e) {
                        echo "Es ist ein Fehler aufgetreten: " . $e->getMessage() . "<br>";
                        error_log("Fehler bei createNewShiftPapershift: " . $e->getMessage());
                    }
    
                    $shiftPapershift_id = $decodedResponse['id'] ?? null;
                    // $note_attribute = $decodedResponse['event_note_content'] ?? null;
                    $result = $contentManager->createEvent($contentManager, $shiftPapershift_id, $wk_id, $note_hash, $shift_id_regiondo, $variation_id, $product_id, $start_at_string, $end_at_string, $PUBLIC_KEY, $location_id);
                    $message = "shiftPapershift_id mit ID $shiftPapershift_id wurde in die Events-Tabelle eingetragen.";
                    echo "$message<br>";
                    $contentManager->createLog($contentManager, $PUBLIC_KEY, $location_id, "Events", "INSERT", $message);
                }
                }
            }
        }
    }
}

function checkDuplicateTimeblocks($contentManager, $verwaltung, $apikeyPapershift, $location_id, $PUBLIC_KEY, $sortierteSchichten_fullDay, $date, $timeZone, $assignmentsByDate_DB, $pause_kind_groupe, $pause_groupe, $pause_tag_id, $grouped_kids_workingareas, $debug = false) {

    $timeBlocks = $contentManager->getTime_block_with_date($date);
    $getAsseigment_DB = $contentManager->getAsseigmentByDate($date);

    $user_switch = [];
    $tz = new DateTimeZone($timeZone);

    debugPrint($debug, "Starte Prüfung für Datum: $date");
    debugPrint($debug, "Anzahl Schicht-Tage: " . count($sortierteSchichten_fullDay));

    foreach ($sortierteSchichten_fullDay as $datum => $shifts) {
        debugPrint($debug, "Verarbeite Schichten für: $datum – Anzahl: " . count($shifts));
        foreach ($shifts as $shift) {
            $shift_id = $shift->id;
            $starts_at = $shift->starts_at;
            $ends_at = $shift->ends_at;
            $working_area_id = $shift->working_area_id;
            $assignments = $shift->assigned;

            if (in_array($working_area_id, $grouped_kids_workingareas['kids'])) {
                $pause = $pause_kind_groupe;
            } else {
                $pause = $pause_groupe;
            }      

            $start_dateTime = (new DateTime($starts_at))->setTimezone($tz)->format('Y-m-d H:i');
            $end_dateTime = (new DateTime($ends_at))->setTimezone($tz)->format('Y-m-d H:i');
            if (empty($assignments)) {
                debugPrint($debug, "Schicht $shift_id hat keine zugewiesenen Benutzer – wird übersprungen.");
                continue;
            }

            foreach ($assignments as $assigment) {
                $user_id = $assigment->id;
                $username = $assigment->username;
                $match_found = false;

                debugPrint($debug, "Prüfe Benutzer $username (ID $user_id)");

                foreach ($getAsseigment_DB as $asseigment_db) {
                    if ($asseigment_db->user_id == $user_id) {

                        $timeBlock_found = false;
                        foreach ($timeBlocks as $timeBlock) {

                            $timeBlock_user_id = $timeBlock->user_id;
                            $timeBlock_datum = $timeBlock->datum;
                            $timeBlock_start_at = $timeBlock->start_at;
                            $timeBlock_end_at = $timeBlock->end_at;
                            $timeBlock_shift_id = $timeBlock->shift_id;
                            $timeBlock_status = $timeBlock->status;
                        
                            $timeBlock_start_dateTime = (new DateTime($timeBlock_start_at))->setTimezone($tz)->format('Y-m-d H:i:s');
                            $timeBlock_end_dateTime   = (new DateTime($timeBlock_end_at))->setTimezone($tz)->format('Y-m-d H:i:s');                            

                            // DEBUG: Ausgabe jedes geprüften TimeBlocks
                            debugPrint($debug, "→ Prüfe vorhandenen TimeBlock für User $timeBlock_user_id: Shift $timeBlock_shift_id, Status $timeBlock_status");
                        
                            if (
                                $timeBlock_shift_id == $shift_id &&
                                $timeBlock_datum == $date &&
                                (
                                    strtolower(trim($timeBlock_status)) == "aktive" ||
                                    strtolower(trim($timeBlock_status)) == "aktive_switch"
                                ) &&
                                $timeBlock_start_at == $timeBlock_start_dateTime &&
                                $timeBlock_end_at == $timeBlock_end_dateTime
                            ) {
                                
                                debugPrint($debug, "Bereits vorhandener aktiver TimeBlock gefunden – kein neuer Eintrag notwendig.");
                                $timeBlock_found = true;
                                $match_found = true;
                                continue 3;
                            }
                        }
                        
                        // Falls kein Treffer
                        if (!$timeBlock_found) {
                            debugPrint($debug, "Kein identischer TimeBlock gefunden – wird weiter geprüft mit Main-Shift.");
                        }
                        
                        $main_shift_name = $asseigment_db->main_shift_name;
                        $main_shift_start_at = $asseigment_db->main_shift_start_at;
                        $main_shift_end_at = $asseigment_db->main_shift_end_at;

                        debugPrint($debug, "Vergleich TimeBlock: [$start_dateTime bis $end_dateTime] mit Main-Shift: [$main_shift_start_at bis $main_shift_end_at]");

                        $block_start_dt = new DateTime($start_dateTime);
                        $block_end_dt = new DateTime($end_dateTime);
                        $main_start_dt = new DateTime($main_shift_start_at);
                        $main_end_dt = new DateTime($main_shift_end_at);

                        if ($block_start_dt < $main_start_dt && $block_end_dt > $main_end_dt) {
                            debugPrint($debug, "TimeBlock liegt **außerhalb** des Main-Shifts.");
                            debugPrint($debug, "Startvergleich: " . $block_start_dt->format('H:i') . " < " . $main_start_dt->format('H:i'));
                            debugPrint($debug, "Endvergleich: " . $block_end_dt->format('H:i') . " > " . $main_end_dt->format('H:i'));
                            continue;
                        } else {
                            debugPrint($debug, "TimeBlock liegt vollständig **innerhalb** des Main-Shifts.");
                        }

                        $match_found = true;
                        $message = "User mit ID = {$user_id} ist innerhalb Datenbank. (Switch)";
                        debugPrint($debug, $message);

                        $contentManager->createLog($contentManager, $PUBLIC_KEY, $location_id, "TimeBlock", "SWITCH", $message);

                        $user_switch[] = [
                            "shift_id" => $shift_id,
                            "date" => $datum,
                            "start" => $start_dateTime,
                            "end" => $end_dateTime,
                            "user_id" => $asseigment_db->user_id,
                            "username" => $username,
                            "main_shift_id" => $asseigment_db->main_shift_id,
                            "main_shift_name" => $main_shift_name,
                            "main_shift_start_at" => $main_shift_start_at,
                            "main_shift_end_at" => $main_shift_end_at,
                            "gap_workingarea_id" => $asseigment_db->gap_workingarea_id,
                            "gap_workingarea_name" => $asseigment_db->gap_workingarea_name
                        ];
                        break 2; // beide Loops verlassen
                    }
                }

                if (!$match_found) {
                    debugPrint($debug, "Kein passender Main-Shift für Benutzer ID $user_id gefunden.");
                }
            }
        }
    }

    if ($debug) {
        echo "<hr><strong>Benutzer für SWITCH-Versuch_checkDuplicateTimeblocks:</strong><br>";
        echo '<pre>';
        echo '$user_switch = ';
        var_dump($user_switch);
        echo '</pre>';
    }
    
    if (!empty($user_switch)) {
        debugPrint($debug, "Es wurden " . count($user_switch) . " Benutzer gefunden, für die ein Switch durchgeführt wird.");
        foreach($user_switch as $switch) {
            if ($debug) {
                echo "<hr>";
                echo "<strong>DEBUG: SWITCH #</strong><br>";
                echo "<pre>";
                var_dump($switch);
                echo "</pre>";
            }
            // Zeiten extrahieren im H:i-Format
            $switch["start"] = date("H:i", strtotime($switch["start"]));
            $switch["end"] = date("H:i", strtotime($switch["end"]));
            $switch["main_shift_start_at"] = date("H:i", strtotime($switch["main_shift_start_at"]));
            $switch["main_shift_end_at"] = date("H:i", strtotime($switch["main_shift_end_at"]));

            // Debug-Ausgabe der bearbeiteten Zeiten
            if ($debug) {
                echo "<strong>DEBUG: SWITCH # (nach Zeit-Formatierung)</strong><br>";
                echo "<pre>";
                echo "start: " . $switch["start"] . "\n";
                echo "end: " . $switch["end"] . "\n";
                echo "main_shift_start_at: " . $switch["main_shift_start_at"] . "\n";
                echo "main_shift_end_at: " . $switch["main_shift_end_at"] . "\n";
                echo "</pre>";
            }
            $result = $verwaltung->fuegeTerminHinzu(
                $switch["user_id"], $switch["username"], $switch["date"], $switch["start"], $switch["end"],
                $switch["shift_id"], $switch["main_shift_start_at"], $switch["main_shift_end_at"], $switch["main_shift_id"],
                $switch["gap_workingarea_id"], $switch["gap_workingarea_name"],
                $apikeyPapershift, $location_id, $contentManager, null
            );

            $result_msg = ($result['success'] ? "Erfolg" : "Fehler") . ": " . $result['message'];
            debugPrint($debug, $result_msg);

            if ($debug) {
                echo "<pre>"; var_dump($result); echo "</pre>";
            }

            $contentManager->createLog($contentManager, $PUBLIC_KEY, $location_id, "TimeBlock", "SWITCH", $result['message']);

            if ($result['success']) {
                $contentManager->createTimeBlock(
                    $switch["user_id"],
                    $switch["username"],
                    $switch["date"],
                    $switch["start"],
                    $switch["end"],
                    $switch["shift_id"],
                    $switch["main_shift_id"],
                    $switch["main_shift_name"],
                    $switch["main_shift_start_at"],
                    $switch["main_shift_end_at"],
                    $switch["gap_workingarea_id"],
                    $switch["gap_workingarea_name"],
                    $pause,
                    "Aktive_Switch"
                );
                bearbeitePauseTypen($pause, $switch["date"], $switch["start"], $switch["end"], $switch["main_shift_start_at"], $switch["main_shift_end_at"], $switch["main_shift_id"], $switch["main_shift_name"],
                $switch["shift_id"], $switch["user_id"], $switch["username"], $switch["gap_workingarea_id"], $switch["gap_workingarea_name"], $apikeyPapershift, $location_id, $pause_tag_id,
                $contentManager, $verwaltung, $PUBLIC_KEY, $result);
                aendereBelegteZeit($assignmentsByDate_DB, $switch["user_id"], $switch["main_shift_id"], $date, "+" . $result['belegte_zeit']);
            }
        }
    } else {
        debugPrint($debug, " Kein Switch erforderlich – keine passenden Benutzer gefunden.");
    }
}

function debugPrint($debug, $message) {
    if ($debug) {
        echo $message . "<br>";
    }
}

function assignment_zuweisen ($verwaltung, $contentManager, $apikeyPapershift, $PUBLIC_KEY, $location_id, $grouped_workingareas, $usersPapershift, $empty_shift_tag_id ,$inactive_user_tag_id, $sortierteSchichten, $sortierteSchichten_groupe, $sortierteSchichten_fullDay, $main_shifts, $museum_product_id, $werk_product_id, $grouped_kids_workingareas, $workingsAreas_virtuell, $date_range, $timeZone, $pause_groupe, $pause_tag_id, $gap_shift_tag_id, $pause_kind_groupe) {
    //DateTimeZone-Objekt
    $timezoneObj = new DateTimeZone($timeZone);

    foreach ($date_range as $date) {
        $assignmentsByDate_DB = getInitialisierteAsseigmentsMitBelegterZeit($contentManager, $date);
        timeBlock_von_DB($contentManager, $verwaltung, $apikeyPapershift, $location_id, $PUBLIC_KEY, $sortierteSchichten_groupe, $date, $timeZone, $assignmentsByDate_DB);
        $verwaltung->zeigeAlleTageProPerson();
        echo "########1<br>";
        checkDuplicateTimeblocks($contentManager, $verwaltung, $apikeyPapershift, $location_id, $PUBLIC_KEY, $sortierteSchichten_fullDay, $date, $timeZone, $assignmentsByDate_DB, $pause_kind_groupe, $pause_groupe, $pause_tag_id, $grouped_kids_workingareas);
        $verwaltung->zeigeAlleTageProPerson();
        echo "########2<br>";
        exit;

        // Verarbeitung der tatsächlichen Abwesenheiten aus der DB
        if (!empty($assignmentsByDate_DB)) {
            foreach ($assignmentsByDate_DB as $asseigments_DB) {
                foreach ( $asseigments_DB as $asseigment_DB) {
                    $username = $asseigment_DB->username ?? null;
                    $user_id = $asseigment_DB->user_id ?? null;
                    $main_shift_id = $asseigment_DB->main_shift_id ?? null; 
                    $main_shift_name = $asseigment_DB->main_shift_name ?? null; 
                    $main_shift_start_at_raw = $asseigment_DB->main_shift_start_at ?? null;
                    $main_shift_end_at_raw = $asseigment_DB->main_shift_end_at ?? null;
                    $gap_workingarea_id = $asseigment_DB->gap_workingarea_id ?? null;
                    $gap_workingarea_name = $asseigment_DB->gap_workingarea_name ?? null;
    
                    // Startzeit verarbeiten
                    if ($main_shift_start_at_raw) {
                        $main_shift_start_at = new DateTime($main_shift_start_at_raw);
                        $main_shift_start_at->setTimezone($timezoneObj);
                        $datetime_start_exploded = explode(' ', $main_shift_start_at->format('Y-m-d H:i'));
                        $haupt_uhrzeit_start_exploded = $datetime_start_exploded[1] ?? null; //time
                    } else {
                        continue;
                    }
    
                    // Endzeit verarbeiten
                    if ($main_shift_end_at_raw) {
                        $main_shift_end_at = new DateTime($main_shift_end_at_raw);
                        $main_shift_end_at->setTimezone($timezoneObj);
                        $datetime_end_exploded = explode(' ', $main_shift_end_at->format('Y-m-d H:i'));
                        $haupt_uhrzeit_end_exploded = $datetime_end_exploded[1] ?? null; //time
                    } else {
                        continue;
                    }
    
                    $groupAbsences = groupAbsencesByDate($apikeyPapershift, $date, $user_id);
                    if (empty($groupAbsences)) continue;

                    foreach ($groupAbsences as $groupAbsence) {
                        $start_time_raw = $groupAbsence->starts_at ?? null;
                        $end_time_raw = $groupAbsence->ends_at ?? null;
                        if (!$start_time_raw || !$end_time_raw) continue;
    
                        $dateTimeZone = new DateTimeZone($timeZone);
    
                        $start_time_obj = new DateTime($start_time_raw, new DateTimeZone('UTC'));
                        $start_time_obj->setTimezone($dateTimeZone);
                        $start_time = $start_time_obj->format('H:i');
    
                        $end_time_obj = new DateTime($end_time_raw, new DateTimeZone('UTC'));
                        $end_time_obj->setTimezone($dateTimeZone);
                        $end_time = $end_time_obj->format('H:i');

                        $virtual_workingarea_id = virtual_workingarea($contentManager, $PUBLIC_KEY, $location_id, "id", $main_shift_name, $workingsAreas_virtuell);
                        $virtual_workingarea_name = virtual_workingarea($contentManager, $PUBLIC_KEY, $location_id, "name", $main_shift_name, $workingsAreas_virtuell);
    
                        list($start_time, $end_time) = passeZeitenAn($start_time, $end_time, $haupt_uhrzeit_start_exploded, $haupt_uhrzeit_end_exploded); // alt
                        //absences Termin hinzufügen
                        $result = $verwaltung->fuegeTerminHinzu($user_id, $username, $date, $start_time, $end_time, "Inactive", $haupt_uhrzeit_start_exploded, $haupt_uhrzeit_end_exploded, $main_shift_id, $virtual_workingarea_id, $virtual_workingarea_name, $apikeyPapershift, $location_id, $contentManager, null);
                        if ($result['success']) {
                            echo "Erfolg: " . $result['message'] . "<br>";
                            $verwaltung->zeigeAlleTageProPerson();
                            // aendereBelegteZeit($assignmentsByDate_DB, $user_id, $date, "+".$result['belegte_zeit']);
                        } else {
                            echo "Fehler: " . $result['message'] . "<br>";
                        }
                    }
                }
            }
        }

        if (!isset($main_shifts[$date])) continue; 
        foreach ($main_shifts[$date] as $main_shift_name => $schichten_von_bereich) {
            foreach ($schichten_von_bereich as $main_shift) {

                $virtual_workingarea_id = virtual_workingarea($contentManager, $PUBLIC_KEY, $location_id, "id", $main_shift_name, $workingsAreas_virtuell);
                $virtual_workingarea_name = virtual_workingarea($contentManager, $PUBLIC_KEY, $location_id, "name", $main_shift_name, $workingsAreas_virtuell);

                $starts_at = $main_shift->starts_at;
                $ends_at = $main_shift->ends_at;
                $main_shift_note = $main_shift->note;
                $main_shift_id = $main_shift->id;

                $haupt_start_user_time = new DateTime($starts_at);
                $haupt_start_user_time->setTimezone($timezoneObj);
                $datetime_start_exploded = explode(' ', $haupt_start_user_time->format('Y-m-d H:i'));
                $haupt_datum_start_exploded = $datetime_start_exploded[0] ?? null; //date
                $haupt_uhrzeit_start_exploded = $datetime_start_exploded[1] ?? null; // time

                $haupt_end_user_time = new DateTime($ends_at);
                $haupt_end_user_time->setTimezone($timezoneObj);
                $datetime_end_exploded = explode(' ', $haupt_end_user_time->format('Y-m-d H:i'));
                $haupt_datum_end_exploded = $datetime_end_exploded[0] ?? null; //date
                $haupt_uhrzeit_end_exploded = $datetime_end_exploded[1] ?? null;// time

                $parsed_notes = parseShiftNotes($main_shift_note, $usersPapershift, $inactive_user_tag_id);

                // Verarbeitung der geplanten Notizen (noch nicht implementiert)
                if (!empty($parsed_notes)) {
                    foreach ($parsed_notes as $parsed_note) {
                        $username = $parsed_note["username"];
                        $user_id = $parsed_note["user_id"];
                        $start_time = $parsed_note["start_time"];
                        $end_time = $parsed_note["end_time"];
                        echo '<pre>';
                        echo '$end_time ';
                        echo '<pre>';
                        var_dump($end_time );
                        echo '</pre>';

                        $end_time_obj = DateTime::createFromFormat('H:i', $end_time);
                        // $end_time_with_pause = berechneEndzeitMitPause($end_time_obj, $pause);
                        $end_time = $end_time_obj->format('H:i');
                        echo '<pre>';
                        echo '$end_time new ';
                        echo '<pre>';
                        var_dump($end_time );
                        echo '</pre>';
                        exit;

                        list($start_time, $end_time) = passeZeitenAn($start_time, $end_time, $haupt_uhrzeit_start_exploded, $haupt_uhrzeit_end_exploded); // alt

                        $result = $verwaltung->fuegeTerminHinzu($user_id, $username, $date, $start_time, $end_time, "Inactive", $haupt_uhrzeit_start_exploded, $haupt_uhrzeit_end_exploded, $main_shift_id, $virtual_workingarea_id, $virtual_workingarea_name, $apikeyPapershift, $location_id, $contentManager, null);
                        if ($result['success']) {
                            echo "Erfolg: " . $result['message'] . "<br>";
                            aendereBelegteZeit($assignmentsByDate_DB, $user_id, $main_shift_id, $date, "+".$result['belegte_zeit']);
                        } else {
                            echo "Fehler: " . $result['message'] . "<br>";
                        }
                    }
                }
            }
        }
        if (!isset($sortierteSchichten[$date])) continue;
        $gefilterteSchichten = findeUnzugewieseneSchichtenNachGruppe($sortierteSchichten, $date, $grouped_workingareas);

        foreach ($gefilterteSchichten as $grouppe_name => $schichts) {
            foreach ($schichts as $schicht) {
                $foundEmptyTag = false;
                $shift_id = $schicht->id;
                $working_area_id = $schicht->working_area_id;
                $tags = $schicht->tags;
                $shift_note_papershift = $schicht->note;
                // Extrahiere alles zwischen ### und ###
                preg_match('/###(.*?)###/s', $shift_note_papershift, $matchesBlock);
                $blockContent = isset($matchesBlock[1]) ? trim($matchesBlock[1]) : null;

                // Extrahiere alles nach # Note :
                preg_match('/#\s*Note\s*:\s*(.*)/', $shift_note_papershift, $speicher_note);
                $noteContent = isset($speicher_note[1]) ? trim($speicher_note[1]) : null;

                // Wenn die Arbeitsbereich-ID zu den Kindergruppen gehört,
                // dann ist dies eine spezielle Kinderpause
                if (in_array($working_area_id, $grouped_kids_workingareas['kids'])) {
                    $pause = $pause_kind_groupe;
                } else {
                    $pause = $pause_groupe;
                }                

                if ($noteContent === null) {
                    $noteContent = ''; // leer lassen, nur der Prefix wird erscheinen
                }
                if (!empty($note_string)) {
                    $final_Note = $note_string . PHP_EOL . '# Note : ' . $noteContent;
                } else {    
                    $final_Note = '# Note : ' . $noteContent;
                }
                if (hasEmptyShiftTag($tags)) $foundEmptyTag = true;

                $starts_at = $schicht->starts_at;
                $start_shift_time = new DateTime($starts_at);
                $start_shift_time->setTimezone($timezoneObj);
                $datetime_start_exploded = explode(' ', $start_shift_time->format('Y-m-d H:i'));
                $shift_datum_start_exploded = $datetime_start_exploded[0]?? null;
                $shift_uhrzeit_start_exploded = $datetime_start_exploded[1]?? null;

                $ends_at = $schicht->ends_at;
                $end_shift_time = new DateTime($ends_at);
                $end_shift_time->setTimezone($timezoneObj);
                $datetime_end_exploded = explode(' ', $end_shift_time->format('Y-m-d H:i'));
                $shift_datum_end_exploded = $datetime_end_exploded[0] ?? null;
                $shift_uhrzeit_end_exploded = $datetime_end_exploded[1] ?? null;

                $list_asseigment = findeMitarbeitendeSortiertNachBelegung($assignmentsByDate_DB, $grouppe_name);

                $processAssignments = processAssignments($assignmentsByDate_DB, $PUBLIC_KEY, $location_id, $apikeyPapershift, $verwaltung, $contentManager, $list_asseigment, $date, $shift_id, $shift_datum_start_exploded, $shift_datum_end_exploded,  $shift_uhrzeit_start_exploded, $shift_uhrzeit_end_exploded, $pause, $workingsAreas_virtuell, $pause_tag_id, $foundEmptyTag);

                $shouldAddEmptyTag = (is_array($processAssignments) && (!$processAssignments["success"] ?? false)) && !$foundEmptyTag;
                $shouldRemoveEmptyTag = (is_array($processAssignments) && ($processAssignments["success"] ?? false)) && $foundEmptyTag;            
                
                if ($shouldAddEmptyTag || $shouldRemoveEmptyTag) {
                    $data_tag = [
                        "api_token" => $apikeyPapershift,
                        "shift" => [
                            "id" => $shift_id,
                            "location_id" => $location_id,
                            "working_area_id" => $working_area_id,
                            "starts_at" => $starts_at,
                            "ends_at" => $ends_at,
                            "number_of_employees" => 1,
                            "tags" => $shouldAddEmptyTag ? $empty_shift_tag_id : "",
                            "note" => $final_Note
                        ]
                    ];
                
                    $aktualisieren = updateShiftPapershift($data_tag);
                    $decodedResponse = json_decode($aktualisieren, true);
                    echo '<pre>empty(tags) wurde aktualisiert: ';
                    var_dump($aktualisieren);
                    echo '</pre>';
                }
            }
        }
        if (!empty($assignmentsByDate_DB)) {
            convert_to_gap_Assignments($assignmentsByDate_DB, $contentManager, $verwaltung, $apikeyPapershift, $location_id, $gap_shift_tag_id, $date);
            assignAndDeleteAssignments($assignmentsByDate_DB, $contentManager, $apikeyPapershift, $PUBLIC_KEY, $location_id, $date);
        }
        $verwaltung->zeigeAlleTageProPerson();
    }
}

function extractProductDetailsEfficiently($extracted_data) { // check nachher
    foreach ($extracted_data as $key => &$categoryData) {
        foreach ($categoryData as &$product) {
            $product_id_data = $product["product_id"];
            $variations_id_data = $product["variations"] ?? [];

            $GETProductByIdRegiondo = GETProductByIdRegiondo($product_id_data);
            $variations = [];
            if (empty($GETProductByIdRegiondo['variations'])) continue;
            foreach ($GETProductByIdRegiondo['variations'] as $variation) {

                $variation_id = $variation->variation_id ?? null;
                $variation_data = [
                    'variation_id' => $variation_id,
                    'name' => $variation->name ?? null,
                    'from' => $variation->from ?? null,
                    'to' => $variation->to ?? null,
                    'appointment_type' => $variation->appointment_type ?? null,
                    //available_dates hier ist außerhalb unsere start und end time , deshalb wir verwenden diese available_dates nur für debuging und nicht mehr.
                    'available_dates' => [],
                    'options' => []
                ];

                $availableOptionsCache = [];
                if (!isset($availableOptionsCache[$variation_id])) {
                    $availableOptionsCache[$variation_id] = GETAvailableOptionsByVariationIdRegiondo($variation_id);
                }
                $availableOption = $availableOptionsCache[$variation_id];

                foreach ($variations_id_data as $vr_data) {
                    if (empty($vr_data['options'])) continue;
                    foreach ($vr_data['options'] as $option) {
                        foreach ($availableOption as $av_option) {
                            if ($av_option->option_id == $option["option_id"]) {
                                $variation_data['options'][] = [
                                    'option_id' => $option["option_id"] ?? null,
                                    'name' => $av_option->name ?? null,
                                    'description' => $av_option->description ?? null,
                                    'booking_notice_period' => $av_option->booking_notice_period ?? null,
                                    'capacity' => isset($av_option->capacity) ? (int)$av_option->capacity : null,
                                    'qty_left' => isset($av_option->qty_left) ? (int)$av_option->qty_left : null
                                ];
                                break;
                            }
                        }
                    }
                }
                if (!empty($variation->available_dates)) {
                    foreach ($variation->available_dates as $date => $time_slots) {
                        foreach ($time_slots as $time_slot) {
                            foreach ($time_slot as $startTime) {
                                $duration_type = $product['duration_type'] ?? 'minute';
                                $duration_values_raw = $product['duration_values'] ?? null;
                                // Wenn duration_values nicht gesetzt ist → Skript abbrechen
                                if (is_null($duration_values_raw)) {
                                    echo "FEHLER: duration_values ist null. Produkt-ID: {$product_id_data}<br>";
                                    exit;
                                }
                                $duration_values = (int)$duration_values_raw;

                                if ($duration_values == 0) { // Falls duration_value gleich 0 ist
                                    $duration_type = "minute";
                                    $duration_values = 1;
                                }
                                $start = new DateTime($startTime);
                                $end = clone $start;

                                if ($duration_type == 'minute') {
                                    $end->modify("+{$duration_values} minutes");
                                } elseif ($duration_type == 'hour') {
                                    $end->modify("+{$duration_values} hours");
                                }

                                $variation_data['available_dates'][$date][] = [
                                    'starts_at' => $start->format('H:i:s'),
                                    'ends_at' => $end->format('H:i:s')
                                ];
                            }
                        }
                    }
                }
                $variations[] = $variation_data;
            }
            $product["variations"] = $variations;
        }
    }
    return $extracted_data;
}
/* ----------------------------------------------------------------- */

/* ----------------------------------------------------------------- */
/*                       Local helper functions                      */

function workingarea_external_id($category, $working_area_id) {
    $variable = "{$working_area_id}_{$category}_aktive";
    return $variable;
}

function debug($message, $variable = null) {
    echo "<pre>$message\n";
    var_dump($variable);
    echo "</pre>";
}

function shiftArrayMitAsseigmentPapershift($apikeyPapershift, $shiftArrayFilterPapershift) {
    foreach ($shiftArrayFilterPapershift as $shift) {
        $shift_id = $shift->id;
        $shiftAssignment_papershift = getShiftAssignmentsapershift($apikeyPapershift, $shift_id);
        if (isset($shiftAssignment_papershift->users->assigned)) {
            $shift->assigned = $shiftAssignment_papershift->users->assigned;
        } else {
            $shift->assigned = [];
        }
    }
    return $shiftArrayFilterPapershift;
}

function extractProductDetails($productsRegiondo, $museum_product_id, $werk_product_id) {

    $result = [
        'museum' => [],
        'werk' => []
    ];

    foreach ($productsRegiondo as $product) {
        $productData = [
            'product_id' => $product->product_id ?? null,
            'name' => $product->name ?? null,
            'appointment_types' => $product->appointment_types ?? null,
            'is_appointment_needed' => $product->is_appointment_needed ?? null,
            'in_stock' => $product->in_stock ?? null,
            'is_expired' => $product->is_expired ?? null,
            'duration_type' => $product->duration_type ?? null,
            'duration_values' => $product->duration_values ?? null,
            'variations' => []
        ];

        if (!empty($product->variations)) {
            foreach ($product->variations as $variation) {
                $options = [];
                foreach ($variation->options as $option) {
                    $options[] = [
                        'option_id' => $option->option_id ?? null
                    ];
                }
                $productData['variations'][] = [
                    'variation_id' => $variation->variation_id ?? null,
                    'options' => $options
                ];
            }
        }
        foreach ($museum_product_id as $product_id) {
            if (stripos($product->product_id, $product_id) !== false) {
                $result['museum'][] = $productData;
                continue 2;
            }
        }

        foreach ($werk_product_id as $product_id) {
            if (stripos($product->product_id, $product_id) !== false) {
                $result['werk'][] = $productData;
                continue 2; 
            }
        }
    }
    return $result;
}

// Funktion zum Erstellen einer Working Area in eine neue location_id
function addNewWorkingAreaToPapershift($apikeyPapershift, $location_id, $data) {
    foreach($data as $wk) {
        $workingarea_name = $wk->name;
        $data = [
            "api_token" => $apikeyPapershift,
            "location_id" => $location_id,
            "name" => "$workingarea_name"
        ];
        $result = createNewWorkingAreaPapershift($data);
        echo '<pre>';
        echo "workingarea:erstellen $workingarea_name :<br>";
        echo '<pre>';
        var_dump($result);
        echo '</pre>';
    }
}

function addNewShiftsToPapershift($apikeyPapershift, $location_id, $data) {
    foreach($data as $sf) {
        $shift_start_at = new DateTime($sf->starts_at);
        $shift_end_at = new DateTime($sf->ends_at);
        $shift_workingareaId = $sf->working_area_id;
        $shift_number_of_employees = $sf->number_of_employees;
        $shift_note = $sf->note;
        $data = [
            "api_token" => "$apikeyPapershift",
            "shift" => [
                "location_id" => "$location_id",
                "working_area_external_id" => "$shift_workingareaId",
                "starts_at" => $shift_start_at->format(DATE_ATOM),
                "ends_at" => $shift_end_at->format(DATE_ATOM),
                "number_of_employees" => $shift_number_of_employees,
                "note" => "$shift_note"
            ]
        ];

        $createShift = createNewShiftPapershift($data);
        echo '<pre>';
        echo "shift:erstellen :<br>";
        echo '<pre>';
        var_dump($createShift);
        echo '</pre>';
    }
}

function extractNotes($data, $event_date_time, $variation_id) {
    $all_notes = []; // Array für alle Notizen

    foreach ($data as $entry) {
        // Prüfe, ob das Event-Datum und die Variation übereinstimmen
        if (!($entry->event_date_time == $event_date_time) || !($variation_id == $entry->variation_id)) {
            continue;
        }

        $notes = []; // Array für die Notizen des aktuellen Eintrags
        $options = $entry->options;

        if (!empty($options)) {

            foreach ($options as $option) {
                // Sowohl für Objekt als auch Array absichern

                if (is_array($option)) {
                    $option_name = strtolower(trim($option['option_name'] ?? ''));
                    $qty = (int)($option['qty'] ?? 0);
                    $qty_cancelled = $option['qty_cancelled'] ?? null;
                    $status = $option['status'] ?? null;
                    $capacity = $option['capacity'] ?? null;
                } elseif (is_object($option)) {
                    $option_name = strtolower(trim($option->option_name ?? ''));
                    $qty = (int)($option->qty ?? 0);
                    $qty_cancelled = $option->qty_cancelled ?? null;
                    $status = $option->status ?? null;
                    $capacity = $option->capacity ?? null;
                } else {
                    continue; // Option ist weder Objekt noch Array → überspringen
                }
                
                // $option_name = isset($option_name) && !empty($option_name) ? strtolower(trim($option_name)) : '';
                // $qty = isset($option->qty) ? (int)$option->qty : (isset($option['qty']) ? (int)$option['qty'] : 0);
                // $qty_cancelled = isset($option->qty_cancelled) ? (int)$option->qty_cancelled : null;
                // $status = isset($option->status) ? $option->status : null;
                // $capacity = isset($option->capacity) ? $option->capacity : (isset($option['capacity']) ? $option['capacity'] : null);
        
                // Entscheidungslogik
                $a = (stripos($option_name, 'kinder') !== false);
                $b = (stripos($option_name, 'schulklasse') !== false);
                $c = (stripos($option_name, 'gruppe') !== false);
                $d = $option_name == 'erwachsene';
        
                if ($a || $b || $c || $d || $qty > 1) {
                    $buyer_datas = $entry->buyer_data ?? [];
                    foreach ($buyer_datas as $buyer_data) {
                        $title = $buyer_data->title ?? '';
                        $title_value = $buyer_data->value ?? '';
        
                        if (stripos($title, "Company / Organization") !== false) {
                            $notes["Company / Organization"] = $title_value;
                        } elseif (stripos($title, "Weitere Informationen (Abteilung, Klassenstufe, Interessenschwerpunkt, etc.)") !== false) {
                            $notes["Weitere Informationen"] = $title_value;
                        }
                    }
                }
            }
        }

        // Kontaktdaten (z. B. Kommentar)
        $contact_data = $entry->contact_data;
        if (!empty($contact_data->comment)) $notes["client_comment"] = $contact_data->comment;
        // Variation und Event-Datum hinzufügen
        $notes["product_id"] = $entry->product_id;
        $notes["variation_id"] = $variation_id;
        $notes["event_date_time"] = $event_date_time;

        // Füge die Notizen des aktuellen Eintrags zum Gesamtarray hinzu
        if (!empty($notes)) $all_notes[] = $notes;
    }

    return !empty($all_notes) ? $all_notes : ""; // Gibt ein Array von Notizen zurück
}

function listOfBookingsRegiondo($details_efficiently, $rangeStart, $rangeEnd) {
    
    $result["_hinweis"] = [
        "Ebene 1" => "Datum im Format YYYY-MM-DD",
        "Ebene 2" => "Produkt-ID",
        "Ebene 3" => "Variations-ID",
        "Wert"    => "Array von Buchungsobjekten"
    ];
    $result["wert"] = [];
    $availableOptionsCache_default = [];

    foreach ($details_efficiently as $working_area => $details) {
        foreach ($details as $detail) {
            $product_id = $detail["product_id"];
            $response = GETListOfBookingsRegiondo(suppress_response_code:'false', debug:'false', sandboxauth:'true', limit: 10, date_range_by: 'date_of_event', date_range: "$rangeStart,$rangeEnd", product_ids: "$product_id", type: 'booking', payment_method: "all", channel: "all");
            if (empty($response)) continue;

            foreach ($response as $key => $booking) {
                $event_date_time = $booking->event_date_time ?? null;
                $variation_id = $booking->variation_id ?? null;

                if (!$event_date_time || ($booking->qty ?? 0) == ($booking->qty_cancelled ?? 0)) {
                    echo "booking is canceled with product_id = $product_id and variation_id = $variation_id and event_date_time = $event_date_time <br>";
                    continue;
                }

                $dt = new DateTime($event_date_time);
                $date = $dt->format('Y-m-d');
                $time = $dt->format('H:i');

                // Optionendetails ergänzen
                $options = $booking->options ?? [];

                if (!isset($availableOptionsCache_default[$variation_id])) {
                    $availableOptionsCache_default[$variation_id] = GETAvailableOptionsByVariationIdRegiondo(variationId: $variation_id);
                }
                $availableOptions = $availableOptionsCache_default[$variation_id];

                if (!empty($options)) {
                    foreach ($options as $option) {
                        $option_id = $option->option_id;
                        $option_qty = $option->qty;
                        $option_qty_cancelled = $option->qty_cancelled;
                        $option->status = ($option_qty > $option_qty_cancelled);
                        if (!empty($availableOptions)) {
                            $found = false;
                            foreach ($availableOptions as $availableOption) {
                                if ($option_id == $availableOption->option_id) {
                                    $option->capacity = $availableOption->capacity;
                                    $found = true;
                                    break;
                                }
                            }
                            if (!$found) {
                                $option->capacity = null;
                                $option->duration_type = null;
                                $option->duration_value = null;
                            }
                        }
                    }
                }

                // Struktur aufbauen: [Datum][ProductID][VariationID][]
                $result["wert"][$date][$product_id][$variation_id][] = $booking;
            }
        }
    }
    return $result["wert"];
}

function availabilities_update($variation_id, $rangeStart, $rangeEnd, $duration_type, $duration_values) {
    $updatedAvailabilities = [];
    $availabilities = GETAvailabilitiesByVariationIdRegiondo(variationId :  $variation_id , dt_from : $rangeStart, dt_to : $rangeEnd, suppress_response_code : 'false',debug : 'false',sandboxauth : 'true',show_soldout : 'false');
    if ($duration_type === 'minute' || $duration_type === 'hour') {
        if (strpos($duration_values, ',') !== false) {
            $parts = explode(',', $duration_values);
            $duration_values = (int) trim($parts[0]);
        } else {
            $duration_values = (int) trim($duration_values);
        }
    }
    foreach ($availabilities as $date => $time_slots) {
        foreach ($time_slots as $slot) {
            foreach ($slot as $start_time) {
                $start = new DateTime($start_time);
                $end = clone $start;

                if ($duration_values == 0) { // Falls duration_value gleich 0 ist
                    $duration_type = "minute";
                    $duration_values = 1;
                }
    
                if ($duration_type === 'minute') {
                    $end->modify("+{$duration_values} minutes");
                } elseif ($duration_type === 'hour') {
                    $end->modify("+{$duration_values} hours");
                }
    
                $updatedAvailabilities[$date][] = [
                    'starts_at' => $start->format('H:i:s'),
                    'ends_at' => $end->format('H:i:s'),
                    'status' => "aktive",
                    'note' => ""
                ];
            }
        }
    }
    return $updatedAvailabilities;
}

function workingsAreaersteller_test_account($apikeyPapershift, $location_id, $details_efficiently) {
    $workingAreasPapershift = getWorkingAreasPapershift(api_token: $apikeyPapershift, location_id: $location_id)->working_areas;
    if (!isset($workingAreasPapershift)) {
        throw new Exception("Keine buchbaren Elemente gefunden.");
    }
    $workspaces = [];

    foreach ($details_efficiently as $details) {
        foreach ($details as $detail) {
            $product_name = $detail["name"];
            $product_id = $detail["product_id"];
            $workspaces[] = (object)['product_name' => $product_name, 'product_id' => $product_id];
        }
        foreach ($workspaces as $workspace) {
            $exists = false;
            foreach ($workingAreasPapershift as $workingArea) {

                $external_id = $workingArea->external_id;
                if ($external_id == $workspace->product_id) {
                    $exists = true;
                    break;
                }
            }
            if (!$exists) {
                $data = [
                    "api_token" => $apikeyPapershift,
                    "location_id" => $location_id,
                    "name" => "$workspace->product_name",
                    "external_id" => $workspace->product_id
                ];
                $result = createNewWorkingAreaPapershift($data);
                echo '<pre>';
                var_dump($result);
                echo '</pre>';
            }
        }
    }
}

function toString($notes) {
    $output = "";
    $count = 0;

    foreach ($notes as $index => $note) {
        $noteEntries = array_filter($note, function($key) {
            return !in_array($key, ["product_id", "variation_id", "event_date_time"]);
        }, ARRAY_FILTER_USE_KEY);

        if (empty($noteEntries)) continue;

        if ($count === 0) {
            $output .= "###\n";
        }

        $count++;
        $output .= $count . ". \n";

        foreach ($noteEntries as $key => $value) {
            $output .= "$key = $value \n";
        }
    }

    if ($count > 0) {
        $output .= "###\n";
    }

    return $output;
}


function filterSchichtenVorZeit($schichtenArray, $zeitzone, $rangeEndMitZeit, $rangeStartMitZeit) {

    $deletedSchichten = [];
    foreach ($schichtenArray as $key => $schicht) {
               // $starts_at wird in UTC erstellt und in die Zielzeitzone (Europe/Berlin) konvertiert
               $starts_at = new DateTime($schicht->starts_at, new DateTimeZone($zeitzone));
               $starts_at->setTimezone(new DateTimeZone($zeitzone));
        $current_endTime = new DateTime($rangeEndMitZeit, new DateTimeZone($zeitzone));
        $current_startTime = new DateTime($rangeStartMitZeit, new DateTimeZone($zeitzone));
        if ($current_endTime < $starts_at) {
            $deletedSchichten[$key] = $schicht;
            continue;
        }
        if ($current_startTime > $starts_at) {
            $deletedSchichten[$key] = $schicht;
            continue;
        }
    }
    foreach ($deletedSchichten as $key => $schicht) {
        unset($schichtenArray[$key]);
    }
    return $schichtenArray;
}


function generateDateRange($rangeStart, $rangeEnd) {
    $start = new DateTime($rangeStart);
    $end = new DateTime($rangeEnd);
    $end->modify('+1 day');
    $interval = new DateInterval('P1D');
    $dateRange = new DatePeriod($start, $interval, $end);

    $data = [];
    foreach ($dateRange as $date) {
        $data[] = $date->format('Y-m-d');
    }
    
    return $data;
}
//ta inja anjam dadam badesh bayad beram soraghe datenbank va inke dataro az shift begiram berizam verketetelist va edame dastan
//be nazare man behtare ke sql abfrage injori bashe ke shift hayi ke überlappen mikonan ro peyda bokonam bad to sql abfrage  not in shift oder user ke betonam fagha shift / user hayi ke mitonam edame bedam ro besazam va karo edame bedam va done done cheack konam
// inam test kardam khob kar mikone
function collectMainShiftsWithAssignments($apikeyPapershift, $location_id, &$schichten, $workingAreasPapershift, $main_shift_tag_id, $rangeStart, $rangeEnd) {
    $workAreaIds = [];

    // Arbeitsbereiche den Namen zuordnen
    foreach ($workingAreasPapershift as $workingArea) {
        $wk_id = $workingArea->id;
        $wk_name = strtolower(trim($workingArea->name));

        switch ($wk_name) {
            case "etage 1":
                $workAreaIds["etage_1"] = $wk_id;
                break;
            case "etage 2":
                $workAreaIds["etage_2"] = $wk_id;
                break;
            case "etage 3":
                $workAreaIds["etage_3"] = $wk_id;
                break;
            case "werktag":
                $workAreaIds["werktag"] = $wk_id;
                break;
        }
    }
    $neueSchichten = [];

    foreach ($schichten as $datum => $schichtArray) {
        foreach ($schichtArray as $schicht_index => $schicht) {
            $tags = $schicht->tags;
            $main_shift_isExist = false;
            foreach($tags as $tag) {
                // = $tag->id;
                //$tag_title = $tag->title;
                $tag_external_id = $tag->external_id;
                if ($tag_external_id == "main_shift") {
                    $main_shift_isExist = true;
                    break;
                }
            }
            if ($main_shift_isExist) {
                // Prüfen, ob die Schicht zu einem der definierten Arbeitsbereiche gehört
                foreach ($workAreaIds as $key => $wk_id) {
                    if ($schicht->working_area_id == $wk_id) {
                        $neueSchichten[$datum][$key][] = $schicht;
                        unset($schichten[$datum][$schicht_index]);
                        break;
                    }
                }
            }
        }
    }
    unset($schichten);
    return  $neueSchichten;
}


function gruppiereSchichtenNachDatum($schichten, $rangeStart, $rangeEnd, $timeZone = 'Europe/Berlin') {
    $gruppierteSchichten = [];

    $tz = new DateTimeZone($timeZone);

    $rangeStartDate = new DateTime($rangeStart, $tz);
    $rangeEndDate = new DateTime($rangeEnd, $tz);

    foreach ($schichten as $schicht) {
        $startDateTime = new DateTime($schicht->starts_at);
        $startDateTime->setTimezone($tz);
        $endDateTime = new DateTime($schicht->ends_at);
        $endDateTime->setTimezone($tz); 

        // Schicht-Datum berechnen:
        // - Falls 'starts_at' UTC-bedingt noch am Vortag ist, aber lokal schon am Folgetag -> Nach lokalem Tag sortieren
        // - Falls 'starts_at' vor dem Zeitraum liegt, aber 'ends_at' noch im Zeitraum -> Nach 'ends_at' sortieren
        // - Ansonsten nach 'starts_at'
        if ($startDateTime->format('Y-m-d') < $rangeStart && $endDateTime->format('Y-m-d') >= $rangeStart) {
            $datum = $endDateTime->format('Y-m-d');
        } else {
            $datum = $startDateTime->format('Y-m-d'); 
        }
        if ($datum >= $rangeStart && $datum <= $rangeEnd) {
            if (!isset($gruppierteSchichten[$datum])) {
                $gruppierteSchichten[$datum] = [];
            }
            $gruppierteSchichten[$datum][] = $schicht;
        }
    }
    // Ergebnisse nach Datum sortieren
    ksort($gruppierteSchichten);

    return $gruppierteSchichten;
}

function user_to_DB($contentManager, $PUBLIC_KEY, $apikeyPapershift, $location_id) {
    $users = getUsersPapershift(api_token : $apikeyPapershift, location_ids : $location_id);

    if (!is_array($users) || empty($users)) {
        echo "Keine Benutzer aus Papershift gefunden oder Fehler bei der API-Abfrage.<br>";
        return;
    }

    foreach ($users as $user) {
        $user_id = $user->id;
        $username = $user->username;
        $user_DB = $contentManager->getUserById($user_id);
        if (empty($user_DB)) {
            $contentManager->createUser($user_id, $username);
            $message = "$username mit ID $user_id wurde in die User-Tabelle eingetragen.";
            // echo "$message<br>";
            $contentManager->createLog($contentManager, $PUBLIC_KEY, $location_id, "User", "INSERT", $message);
        } 
    }
}

function createAsseigment_to_DB($contentManager, $apikeyPapershift, $PUBLIC_KEY, $location_id, $main_shifts, $workingsAreas_virtuell, $main_shift_tag_id, $delete_function) {
    foreach ($main_shifts as $date => $main_shift) {
        foreach ($main_shift as $main_shift_name => $shifts) {
            foreach ($shifts as $shift) {

                $gap_workingarea_id = virtual_workingarea($contentManager, $PUBLIC_KEY, $location_id, "id", $main_shift_name, $workingsAreas_virtuell);
                $gap_workingarea_name = virtual_workingarea($contentManager, $PUBLIC_KEY, $location_id, "name", $main_shift_name, $workingsAreas_virtuell);
                // $shift = $shift[0]; // Da wir nur eine Main-Schicht unter diesem Department haben.
                $main_shift_id = $shift->id;
                $working_area_id = $shift->working_area_id;
                $asseigments = $shift->assigned ?? null;
                $starts_at = $shift->starts_at ?? null;
                $ends_at = $shift->ends_at ?? null;
                $note = $shift->note ?? "";

                // Extrahiere alles zwischen ### und ###
                preg_match('/###(.*?)###/s', $note, $matchesBlock);
                $blockContent = isset($matchesBlock[1]) ? trim($matchesBlock[1]) : null;
                $note_hash = hash('sha256', json_encode($blockContent));
                
                // Inhalt aus "# Note :" extrahieren
                preg_match('/#\s*Note\s*:\s*(.*)/', $note, $speicher_note);
                $noteContent = isset($speicher_note[1]) ? trim($speicher_note[1]) : $note;
  
                // Wenn keine Zuweisungen, nächste Schicht

                if ($delete_function) {
                    if (empty($asseigments)) continue;
                    foreach ($asseigments as $asseigment) {
                        $user_id = $asseigment->id;
                        $username = $asseigment->username;
    
                        $getAsseigment_DB = $contentManager->getAsseigmentByUserIdAndMain_shift_id($user_id, $main_shift_id);
                        if (!empty($getAsseigment_DB)) continue;
    
                        $contentManager->createAsseigment($username, $user_id, $main_shift_name, $main_shift_id, $gap_workingarea_id, $gap_workingarea_name, $date, $starts_at, $ends_at);
                        $message = "$username mit ID = $user_id wurde in Datenbank gespeichert.";
                        echo "$message<br>";
                        $contentManager->createLog($contentManager, $PUBLIC_KEY, $location_id, "Asseigment", "INSERT", $message);
    
                        $getAsseigment_DB = $contentManager->getAsseigmentByUserIdAndMain_shift_id($user_id, $main_shift_id);
                        if (empty($getAsseigment_DB)) continue;
    
                        $data = [
                            "api_token" => $apikeyPapershift,
                            "assignment" => [
                                "shift_id" => $main_shift_id,
                                "user_id" => $user_id
                            ]
                        ];
    
                        $deleteAssign = deleteAssignUserFromShiftPapershift($data);
                        $message = "$username mit ID = $user_id wurde von Papershift von shift_id = $main_shift_id gelöscht.";
                        echo "$message<br>";
                        $contentManager->createLog($contentManager, $PUBLIC_KEY, $location_id, "Asseigment", "DELETE", $message);
                    }
                }

                // Hole alle gespeicherten Namen
                $usernames_saved = $contentManager->getAsseigmentByMain_shift_id($main_shift_id);

                $usernames_saved = array_map(fn($u) => $u->username, $usernames_saved);

                // if (!empty($usernames_saved)) {
                    // interner Klartext zur Hashbildung
                    $usernames_intern = "Folgende Mitarbeitende wurden eingetragen und sind jetzt in der Datenbank gespeichert:\n";
                    foreach ($usernames_saved as $i => $username) {
                        $usernames_intern .= ($i + 1) . ". $username\n";
                    }

                    // Hash für Vergleich
                    $note_hash_intern = hash('sha256', json_encode(trim($usernames_intern)));

                    if ($note_hash_intern == $note_hash) continue;

                    // formatierter Note-String
                    $usernames_string = "###\n";
                    $usernames_string .= "$usernames_intern";
                    $usernames_string .= "###\n";
                    $usernames_string .= "# Note : " . $noteContent;


                    $data_main = [
                        "api_token" => $apikeyPapershift,
                        "shift" => [
                            "id" => $main_shift_id,
                            "location_id" => $location_id,
                            "working_area_id" => $working_area_id,
                            "starts_at" => $starts_at,
                            "ends_at" => $ends_at,
                            "number_of_employees" => 1,
                            "note" => $usernames_string,
                            "tags" => $main_shift_tag_id,
                        ]
                    ];

                    $aktualisieren = updateShiftPapershift($data_main);
                    echo '<pre>Aktualisierte Main_Schicht: ';
                    var_dump($aktualisieren);
                    echo '</pre>';
                // }
            }
        }
    }

}


function papershiftTagErstellen($apikeyPapershift, $location_id, $tags) {
    $transferArray = [];
    $empty_isExist = false;
    $inactive_user_isExist = false;
    $main_isExist = false;
    $gap_isExist = false;
    $pause_isExist = false;
    $defaultarray = [
        "api_token" => $apikeyPapershift,
        "location_id" => $location_id,
        "title" => "",
        "active" => true,
        "external_id" => "",
    ];

    foreach($tags as $tag) {
        if (!isset($tag->external_id)) continue;
        if (strtolower(trim($tag->external_id)) == strtolower(trim("inactive_user"))) $inactive_user_isExist = true;
        if (strtolower(trim($tag->external_id)) == strtolower(trim("empty_shift"))) $empty_isExist = true;
        if (strtolower(trim($tag->external_id)) == strtolower(trim("main_shift"))) $main_isExist = true;
        if (strtolower(trim($tag->external_id)) == strtolower(trim("gap_shift"))) $gap_isExist = true;
        if (strtolower(trim($tag->external_id)) == strtolower(trim("pause"))) $pause_isExist = true;
    }
    if (!$inactive_user_isExist) {
        $newTag = $defaultarray;
        $newTag['title'] = "inactive";
        $newTag['external_id'] = "inactive_user";
        $transferArray[] = $newTag;
    }
    if (!$empty_isExist) {
        $newTag = $defaultarray;
        $newTag['title'] = "empty";
        $newTag['external_id'] = "empty_shift";
        $transferArray[] = $newTag;
    }
    if (!$main_isExist) {
        $newTag = $defaultarray;
        $newTag['title'] = "main_shift";
        $newTag['external_id'] = "main_shift";
        $transferArray[] = $newTag;
    }
    if (!$gap_isExist) {
        $newTag = $defaultarray;
        $newTag['title'] = "gap";
        $newTag['external_id'] = "gap_shift";
        $transferArray[] = $newTag;
    }
    if (!$pause_isExist) {
        $newTag = $defaultarray;
        $newTag['title'] = "pause";
        $newTag['external_id'] = "pause";
        $transferArray[] = $newTag;
    }

    if (!empty($transferArray)) {
        foreach ($transferArray as $data) {
            $result = createNewTagPapershift($data);
            echo '<pre>';
            echo "tag erstellen: ";
            var_dump($result);
            echo '</pre>';
        }
    }

    return getTagsPapershift(api_token: $apikeyPapershift, location_id: $location_id)->filters;//200
}

function groupAbsencesByDate($apikeyPapershift, $date, $user_id) {
    $date = date("Y-m-d H:i:s", strtotime($date)); 
    
    $rangeStart = date("Y-m-d 00:00:00", strtotime($date));
    $rangeEnd = date("Y-m-d 23:59:59", strtotime($date));

    $absencesArray = getAbsencesPapershift($apikeyPapershift, range_start: $rangeStart, range_end: $rangeEnd, user_id: $user_id);

    return $absencesArray;
}

function parseShiftNotes($noteString, $usersPapershift, $inactive_user_tag_id) {

    // Diese beispiel
    // @alex test#14:00 - 15:00#Uhr Termin
    // @ali_zia#12:00-15:00 # test sonderfälle
    // @huda_test# 13:00-15:00 #"
    // korrekt => @huda_test# 13:00-15:00 #" aber obere kann man verwenden.
    
    $parsedNotes = [];

    // Zeilen aufsplitten
    $lines = explode("\n", $noteString);

    foreach ($lines as $line) {
        // Nur Zeilen mit @ und #
        if (strpos($line, '@') !== false && strpos($line, '#') !== false) {
            // Zerlege die Zeile in 3 Teile: @username, zeitbereich, rest
            $parts = explode('#', $line, 3);

            if (count($parts) < 2) {
                continue; // Ungültiges Format
            }

            $username = trim(str_replace('@', '', $parts[0]));
            $timeRange = trim($parts[1]);

            $timeParts = explode('-', $timeRange);
            if (count($timeParts) != 2) {
                continue; // Zeitformat falsch
            }

            $startTime = trim($timeParts[0]);
            $endTime = trim($timeParts[1]);

            $startTimeObj = DateTime::createFromFormat('H:i', $startTime);
            $endTimeObj = DateTime::createFromFormat('H:i', $endTime);

            if ($startTimeObj && $endTimeObj && $startTimeObj < $endTimeObj) {
                $found_user = null;

                foreach ($usersPapershift as $user) {
                    // Username vergleichen (case-insensitive)
                    if (strtolower(trim($user->username)) == strtolower($username)) {
                        // Prüfe auf inaktive Tags
                        if (!empty($user->tags) && in_array($inactive_user_tag_id, $user->tags)) {
                            $found_user = null; // Ignorieren
                            break;
                        }
                        $found_user = $user;
                        break;
                    }
                }

                if ($found_user) {
                    $parsedNotes[] = [
                        'username'   => $username,
                        'user_id'    => $found_user->id,
                        'start_time' => $startTime,
                        'end_time'   => $endTime
                    ];
                } else {
                    echo "Kein aktiver Benutzer gefunden für: @$username\n";
                }
            } else {
                echo "Fehlerhafte Zeitangabe für $username: $startTime - $endTime\n";
            }
        }
    }

    return $parsedNotes;
}

function groupWorkingAreasByProductGroup($workingAreasPapershift, $werk_product_id, $museum_product_id) {
    $gruppierte_workingareas = [
        "museum" => [],
        "werk"   => [],
    ];

    foreach ($workingAreasPapershift as $workingAreaPapershift) {
        $external_id = $workingAreaPapershift->external_id;
        $id = $workingAreaPapershift->id;

        if (!empty($external_id)) {
            if (in_array($external_id, $museum_product_id)) {
                $gruppierte_workingareas["museum"][] = $id;
            } elseif (in_array($external_id, $werk_product_id)) {
                $gruppierte_workingareas["werk"][] = $id;
            }
        }
    }

    return $gruppierte_workingareas;
}

function group_kidsWorkingAreasByProductGroup($workingAreasPapershift, $kids_product_id) {
    $gruppierte_workingareas = [
        "kids" => []
    ];

    foreach ($workingAreasPapershift as $workingAreaPapershift) {
        $external_id = $workingAreaPapershift->external_id;
        $id = $workingAreaPapershift->id;

        if (!empty($external_id)) {
            if (in_array($external_id, $kids_product_id)) {
                $gruppierte_workingareas["kids"][] = $id;
            }
        }
    }

    return $gruppierte_workingareas;
}

function berechneEndzeitMitPause(DateTime $end_time_obj, int $pause): string {
    $end_time_with_pause_obj = clone $end_time_obj;
    $end_time_with_pause_obj->add(new DateInterval('PT' . $pause . 'M'));
    
    // Nur übernehmen, wenn das Datum sich nicht ändert
    if ($end_time_with_pause_obj->format('Y-m-d') === $end_time_obj->format('Y-m-d')) {
        return $end_time_with_pause_obj->format('H:i');
    }
    return $end_time_obj->format('H:i');
}

function passeZeitenAn($start_time, $end_time, $haupt_start, $haupt_ende) {
    if ($start_time < $haupt_start) {
        $start_time = $haupt_start;
    }
    if ($end_time > $haupt_ende) {
        $end_time = $haupt_ende;
    }
    return [$start_time, $end_time];
}

function aendereBelegteZeit(&$assignmentsByDate_DB, $user_id, $main_shift_id, $date, $zeitDifferenz) {
    foreach ($assignmentsByDate_DB as $list) {
        foreach ($list as $entry) {
            if ($entry->user_id == $user_id && strpos($entry->date, $date) === 0 && $entry->main_shift_id == $main_shift_id) {

                // 1. alte belegte_zeit sicher aufteilen
                if (strpos($entry->belegte_zeit, ':') === false) {
                    $stunden = 0;
                    $minuten = 0;
                } else {
                    list($stunden, $minuten) = explode(':', $entry->belegte_zeit);
                }
                $gesamtMinuten = intval($stunden) * 60 + intval($minuten);
    
                // 2. neue Zeit aus +HH:MM oder -HH:MM extrahieren
                $zeichen = substr($zeitDifferenz, 0, 1);
                $zeitString = substr($zeitDifferenz, 1);
                if (strpos($zeitString, ':') === false) {
                    // ungültiges Format
                    continue;
                }
                list($diffStunden, $diffMinuten) = explode(':', $zeitString);
                $differenzMinuten = intval($diffStunden) * 60 + intval($diffMinuten);
    
                // 3. rechnen
                if ($zeichen === '+') {
                    $gesamtMinuten += $differenzMinuten;
                } elseif ($zeichen === '-') {
                    $gesamtMinuten -= $differenzMinuten;
                    if ($gesamtMinuten < 0) $gesamtMinuten = 0;
                } else {
                    continue; // ungültiges Vorzeichen
                }
    
                // 4. Ergebnis speichern
                $neueStunden = floor($gesamtMinuten / 60);
                $neueMinuten = $gesamtMinuten % 60;
                $entry->belegte_zeit = str_pad($neueStunden, 2, '0', STR_PAD_LEFT) . ':' . str_pad($neueMinuten, 2, '0', STR_PAD_LEFT);
            }
        }
    }
}

function findeMitarbeitendeMitWenigsterBelegung($asseigments, $grouppe_name) {
    $minutenListe = [];

    // 1. Alle belegten Minuten sammeln
    foreach ($asseigments as $name => $list) {
        if ($name != $grouppe_name) continue;
        foreach ($list as $entry) {
            if (!isset($entry->belegte_zeit)) continue;
    
            list($stunden, $minuten) = explode(':', $entry->belegte_zeit);
            $gesamtMinuten = intval($stunden) * 60 + intval($minuten);
    
            $minutenListe[] = [
                'user_id' => $entry->user_id,
                'username' => $entry->username,
                'main_shift_name' => $entry->main_shift_name,
                'main_shift_id' => $entry->main_shift_id,
                'main_shift_start_at' => $entry->main_shift_start_at,
                'main_shift_end_at' => $entry->main_shift_end_at,
                'belegteZeit' => $entry->belegte_zeit,
                'minuten' => $gesamtMinuten,
            ];
        }
    }

    // 2. Geringste Minuten finden
    if (empty($minutenListe)) return [];

    $min = min(array_column($minutenListe, 'minuten'));

    // 3. Alle mit dieser geringsten Zeit zurückgeben
    $ergebnis = array_filter($minutenListe, function($eintrag) use ($min) {
        return $eintrag['minuten'] === $min;
    });

    return array_values($ergebnis); // Indexe neu sortieren
}

function findeMitarbeitendeSortiertNachBelegung($asseigments, $gruppenName) {
    $minutenListe = [];

    // 1. Minuten berechnen und sammeln
    foreach ($asseigments as $name => $list) {
        if ($name !== $gruppenName) continue;

        foreach ($list as $entry) {
            if (!isset($entry->belegte_zeit)) continue;

            list($stunden, $minuten) = explode(':', $entry->belegte_zeit);
            $gesamtMinuten = intval($stunden) * 60 + intval($minuten);

            $minutenListe[] = [
                'user_id' => $entry->user_id,
                'username' => $entry->username,
                'main_shift_name' => $entry->main_shift_name,
                'main_shift_id' => $entry->main_shift_id,
                'main_shift_start_at' => $entry->main_shift_start_at,
                'main_shift_end_at' => $entry->main_shift_end_at,
                'belegteZeit' => $entry->belegte_zeit,
                'minuten' => $gesamtMinuten,
            ];
        }
    }

    // 2. Nach Minuten aufsteigend sortieren
    usort($minutenListe, function($a, $b) {
        return $a['minuten'] <=> $b['minuten'];
    });

    return $minutenListe;
}


function asseigments_optimieren($assignmentsByDate_DB) {
    $result = [
        "werk" => [],
        "museum" => []
    ];
    
    foreach ($assignmentsByDate_DB as $asseigment) {
        $main_shift_name = $asseigment->main_shift_name;
        if ($main_shift_name == "werktag") {
            $result["werk"][] = $asseigment;
        } else {
            $result["museum"][] = $asseigment;
        }
    }

    return $result;
}

function processAssignments(&$assignmentsByDate_DB, $PUBLIC_KEY, $location_id, $apikeyPapershift, $verwaltung, $contentManager, $list_asseigment, $date, $shift_id, $shift_datum_end_exploded, $shift_uhrzeit_start_exploded, $start_time, $end_time, $pause, $workingsAreas_virtuell, $pause_tag_id, $foundEmptyTag) {
    $result = null;
    $debug = false;
    foreach ($list_asseigment as $asseigment) {
        $shift_ids = [];
        $vorpause_isExist = false;
        $nachpause_isExist = false;
        $user_id = $asseigment["user_id"];
        $username = $asseigment["username"];
        $main_shift_id = $asseigment["main_shift_id"];
        $main_shift_name = $asseigment["main_shift_name"];
        $main_shift_start_at = (new DateTime($asseigment["main_shift_start_at"]))->format('H:i');
        $main_shift_end_at = (new DateTime($asseigment["main_shift_end_at"]))->format('H:i');

        // Get virtual working area details
        $virtual_workingarea_id = virtual_workingarea($contentManager, $PUBLIC_KEY, $location_id, "id", $main_shift_name, $workingsAreas_virtuell);
        $virtual_workingarea_name = virtual_workingarea($contentManager, $PUBLIC_KEY, $location_id, "name", $main_shift_name, $workingsAreas_virtuell);

        if ($pause > 0) {

            $vorpause_isExist_test = pruefePauseMoeglichkeit(
                "vorpause", $verwaltung, $user_id, $username, $date, $start_time, $main_shift_start_at,
                $main_shift_start_at, $main_shift_end_at, $main_shift_id, $virtual_workingarea_id,
                $virtual_workingarea_name, $pause
            );
        
            $nachpause_isExist_test = pruefePauseMoeglichkeit(
                "nachpause", $verwaltung, $user_id, $username, $date, $end_time, $main_shift_end_at,
                $main_shift_start_at, $main_shift_end_at, $main_shift_id, $virtual_workingarea_id,
                $virtual_workingarea_name, $pause
            );
        
            // Wenn eine der Pausen nicht möglich, Nutzer überspringen
            if (!$vorpause_isExist_test || !$nachpause_isExist_test) {
                if ($debug) {
                    echo "Pausen-Test nicht bestanden: ";
                    if (!$vorpause_isExist_test) echo "Vorpause ";
                    if (!$nachpause_isExist_test) echo "Nachpause ";
                    echo "Skipping user $username<br>";
                }
                $result['success'] = false;
                continue;
            }
        }

        // Add local shift
        $result = $verwaltung->fuegeTerminHinzu(
            $user_id,
            $username,
            $date,
            $start_time,
            $end_time,
            $shift_id,
            $main_shift_start_at,
            $main_shift_end_at,
            $main_shift_id,
            $virtual_workingarea_id,
            $virtual_workingarea_name,
            $apikeyPapershift,
            $location_id,
            $contentManager,
            null
        );
        $verwaltung->zeigeAlleTageProPerson();
        echo "schritt eins<br>";

        if ($result['success']) {
            $shift_ids [] = ["belegt_shift" => $shift_id];
            // Assign user to shift
            if (!assignUserToShift($apikeyPapershift, $shift_id, $user_id, $contentManager, $PUBLIC_KEY, $location_id)) {
                $verwaltung->loescheTermin($user_id, $date, $main_shift_id, $shift_id);
                $result['success'] = false;
                echo "Fehler: Zuweisung fehlgeschlagen, Termin gelöscht.<br>";
                continue;
            }

            // Log successful shift creation
            echo "Erfolg: " . $result['message'] . "<br>";

            $contentManager->createTimeBlock(
                $user_id,
                $username,
                $date,
                $start_time,
                $end_time,
                $shift_id,
                $main_shift_id,
                $main_shift_name,
                $main_shift_start_at,
                $main_shift_end_at,
                $virtual_workingarea_id,
                $virtual_workingarea_name,
                $pause,
                "Aktive"
            );

            // // Handle pause if applicable
            if ($pause > 0) {

                foreach (["vorpause", "nachpause"] as $pauseType) {
                    if ($debug) echo "<hr><strong>Bearbeite: $pauseType</strong><br>";
            
                    $referenceTime = $pauseType === "vorpause" ? $start_time : $end_time;
                    $mainTime = $pauseType === "vorpause" ? $main_shift_start_at : $main_shift_end_at;

                    if ($debug) {
                        echo "referenceTime: $referenceTime<br>";
                        echo "mainTime: $mainTime<br>";
                    }
            
                    $pauseTime = calculatePauseTimes($pauseType, $date, $referenceTime, $mainTime, $pause);
                    if ($debug) {
                        echo "<pre>pauseTime:\n";
                        var_dump($pauseTime);
                        echo "</pre>";
                    }
                    if ($pauseTime["success"]) {
                        $referenceDateTime = new DateTime("$date $referenceTime");
                        $mainDateTime = new DateTime("$date $mainTime");

                        if ($referenceDateTime->format('Y-m-d H:i') === $mainDateTime->format('Y-m-d H:i')) {
                            if ($pauseType === "vorpause") {
                                $vorpause_isExist = true;
                            } else {
                                $nachpause_isExist = true;
                            }
                        } elseif (isset($pauseTime["pauseStartTime"], $pauseTime["pauseEndTime"])) {
                            $pause_result = $verwaltung->fuegePauseHinzu(
                                $user_id,
                                $username,
                                $date,
                                $pauseTime["pauseStartTime"],
                                $pauseTime["pauseEndTime"],
                                $main_shift_start_at,
                                $main_shift_end_at,
                                $main_shift_id,
                                $virtual_workingarea_id,
                                $virtual_workingarea_name,
                                $pause_time['id'] ?? null,
                                $apikeyPapershift,
                                $location_id,
                                $pause_tag_id,
                                $pause,
                                $contentManager
                            );
                
                            if ($debug) {
                                echo "<pre>pause_result:\n";
                                var_dump($pause_result);
                                echo "</pre>";
                            }

                            if (($pause_result['success']) && isset($pause_result["id"])) {
                                $shift_ids [] = ["$pauseType" => $pause_result["id"]];
                                $message = $pause_result["message"];
                                echo "$message<br>";
                                $contentManager->createLog($contentManager, $PUBLIC_KEY, $location_id, "TimeBlock", ucfirst($pauseType), $message);

                                $shift_pause_id = $pause_result["id"];

                                if (!assignUserToShift($apikeyPapershift, $pause_result["id"], $user_id, $contentManager, $PUBLIC_KEY, $location_id)) {
                                    $result['success'] = false;
                                    $message = "user mit $user_id nicht in shift(für Pause) mit id = $shift_pause_id hinzugefügt. Shift wurde von Papershift und Datenbank gelöscht.";
                                    echo "$message<br>";
                                    logAndDeleteTimeBlockAndShift_Pause($contentManager, $apikeyPapershift, $date, $pause_result["id"], $user_id);
                                    $verwaltung->loeschePauseMitID($user_id, $date, $main_shift_id, $pause_result["id"]);
                                    $contentManager->createLog($contentManager, $PUBLIC_KEY, $location_id, "TimeBlock", ucfirst($pauseType)."Delete", $message);
                                    continue;
                                }
                                
                                $contentManager->createTimeBlock(
                                    $user_id,
                                    $username,
                                    $date,
                                    $pauseTime["pauseStartTime"],
                                    $pauseTime["pauseEndTime"],
                                    $pause_result["id"],
                                    $main_shift_id,
                                    $main_shift_name,
                                    $main_shift_start_at,
                                    $main_shift_end_at,
                                    $virtual_workingarea_id,
                                    $virtual_workingarea_name,
                                    $pause,
                                    $pauseType
                                );
            
                                if ($pauseType === "nachpause") {
                                    $nachpause_isExist = true;
                                    $contentManager->fuegeNachPause_idInTimeBlock($shift_id, $pause_result["id"]);
                                } else {
                                    $vorpause_isExist = true;
                                    $contentManager->fuegeVorPause_idInTimeBlock($shift_id, $pause_result["id"]);
                                }
                            } else {
                                $message = "Fehler beim Hinzufügen der " . ucfirst($pauseType) . ": " . $pause_result["message"];
                                echo "$message<br>";
                                $contentManager->createLog($contentManager, $PUBLIC_KEY, $location_id, "TimeBlock", ucfirst($pauseType), $message);
                                $result['success'] = false;
                            }
                        }
                    } else {
                        $message = "Keine " . ucfirst($pauseType) . " verfügbar: " . ($pauseTime["message"] ?? 'unbekannt');
                        echo "$message<br>";
                        $contentManager->createLog($contentManager, $PUBLIC_KEY, $location_id, "TimeBlock", ucfirst($pauseType), $message);
                        $result['success'] = false;
                    }
                }
                if (!$vorpause_isExist || !$nachpause_isExist) {

                    if ($debug) {
                        echo "Pausen-Orginal nicht bestanden: ";
                        if (!$vorpause_isExist) echo "Vorpause ";
                        if (!$nachpause_isExist) echo "Nachpause ";
                        echo "Skipping user $username<br>";
                    }
                    $data = [
                        "api_token" => $apikeyPapershift,
                        "assignment" => [
                            "shift_id" => $shift_id,
                            "user_id" => $user_id
                        ]
                    ];

                    $deleteAssign = deleteAssignUserFromShiftPapershift($data);
                    $message = "$username mit ID = $user_id wurde von Papershift von shift_id = $shift_id gelöscht , weil vor oder nach Pausen nicht für person passen.";
                    echo "$message<br>";
                    $contentManager->createLog($contentManager, $PUBLIC_KEY, $location_id, "TimeBlock", "DELETE", $message);
                    $result['success'] = false;
                    continue;
                }
            }            
            // $verwaltung->zeigeAlleTageProPerson();
            aendereBelegteZeit($assignmentsByDate_DB, $user_id, $main_shift_id, $date, "+" . $result['belegte_zeit']);
            break; // Nur erster erfolgreicher Eintrag
        } else {
            echo "Fehler: " . $result['message'] . "<br>";
            continue;
        }
    }
    return $result;
}

function findeUnzugewieseneSchichtenNachGruppe($sortierteSchichten, $datum, $grouped_workingareas) {
    $result = [];

    if (!isset($sortierteSchichten[$datum])) {
        return $result;
    }

    foreach ($sortierteSchichten[$datum] as $schicht) {
        $working_area_id = $schicht->working_area_id;
        $assigned = $schicht->assigned;
        foreach ($grouped_workingareas as $gruppenName => $gruppe) {
            if (in_array($working_area_id, $gruppe)) {
                if (empty($schicht->assigned)) {
                    if (!isset($result[$gruppenName])) {
                        $result[$gruppenName] = [];
                    }
                    $result[$gruppenName][] = $schicht;
                }
                break;
            }
        }
    }

    return $result;
}
function filterShiftsByGroupedWorkingareas(&$sortierteSchichten, $grouped_workingareas, $timeZone, $now, $filter_time) {
    $allowed_working_area_ids = [];

    foreach ($grouped_workingareas as $gruppe) {
        foreach ($gruppe as $id) {
            $allowed_working_area_ids[] = $id;
        }
    }

    foreach ($sortierteSchichten as $datum => &$schichten_am_Tag) {
        foreach ($schichten_am_Tag as $key => $schicht) {
            // Working Area Filter
            if (!in_array($schicht->working_area_id, $allowed_working_area_ids)) {
                unset($schichten_am_Tag[$key]); 
                continue;
            }
            if ($filter_time) {
                // Zeitfilter: Schichtstart ist in der Vergangenheit oder genau jetzt
                $schicht_start = new DateTime($schicht->starts_at, new DateTimeZone('UTC'));
                $schicht_start->setTimezone(new DateTimeZone($timeZone));
                if ($schicht_start <= $now) {
                    unset($schichten_am_Tag[$key]);
                }
            }
        }

        // Tag entfernen, wenn alle Schichten entfernt wurden
        if (empty($schichten_am_Tag)) {
            unset($sortierteSchichten[$datum]);
        }
    }

    return $sortierteSchichten;
}

function getInitialisierteAsseigmentsMitBelegterZeit($contentManager, $date) {
    $asseigments = $contentManager->getAsseigmentByDate($date);

    foreach ($asseigments as $entry) {
        $entry->belegte_zeit = "00:00"; // Initialwert setzen  HH:MM
    }

    return asseigments_optimieren($asseigments);
}


function timeBlock_von_DB($contentManager, $verwaltung, $apikeyPapershift, $location_id, $PUBLIC_KEY, $sortierteSchichten, $date, $timeZone, &$assignmentsByDate_DB) {

    echo '<pre>';
    echo '$assignmentsByDate_DB';
    echo '<pre>';
    var_dump($assignmentsByDate_DB);
    echo '</pre>';

    $debug = false;
    $timeBlocks = $contentManager->getTime_block_with_date($date);
    echo '<pre>';
    echo '$timeBlocks';
    echo '<pre>';
    var_dump($timeBlocks);
    echo '</pre>';
    $getAsseigment_DB = $contentManager->getAsseigmentByDate($date);
    echo '<pre>';
    echo '$getAsseigment_DB';
    echo '<pre>';
    var_dump($getAsseigment_DB);
    echo '</pre>';

    $user_switch = [];
    $user_pause_enfernen = [];

    if ($debug) echo "<hr><strong>Starte Prüfung der TimeBlocks für $date</strong><br>";

    if (empty($timeBlocks)) {
        echo "Keine TimeBlocks für $date gefunden.<br>";
        return;
    }

    $tz = new DateTimeZone($timeZone);

    foreach ($timeBlocks as $block) {

        if ($debug) {
            echo "<hr><strong>Neuer Block:</strong><br>";
            echo "<pre>"; print_r($block); echo "</pre>";
        }

        $user_id = $block->user_id;
        $shift_id_DB = $block->shift_id;
        $main_shift_id = $block->main_shift_id;
        $virtual_workingarea_id = $block->virtual_workingarea_id;
        $virtual_workingarea_name = $block->virtual_workingarea_name;
        $username = $block->username;
        $status = $block->status;
        $nachPause_id = $block->nachPause_id;
        $vorPause_id = $block->vorPause_id;

        $start = (new DateTime($block->start_at))->setTimezone($tz)->format('H:i');
        $start_dateTime = (new DateTime($block->start_at))->setTimezone($tz)->format('Y-m-d H:i');
        $end = (new DateTime($block->end_at))->setTimezone($tz)->format('H:i');
        $end_dateTime = (new DateTime($block->end_at))->setTimezone($tz)->format('Y-m-d H:i');
        $main_start = (new DateTime($block->main_shift_start_at))->setTimezone($tz)->format('H:i');
        $main_end = (new DateTime($block->main_shift_end_at))->setTimezone($tz)->format('H:i');

        $found = false;
        $assignments = [];

        foreach ($sortierteSchichten as $datum => $shifts) {
            foreach ($shifts as $shift) {
                if ($shift->id == $shift_id_DB) {
                    $assignments = $shift->assigned;
                    $found = true;
                    break 2;
                }
            }
        }

        if (!$found) {
            if ($debug) echo "Kein Shift mit ID = $shift_id_DB in sortierten Schichten gefunden.<br>";
            continue;
        }

        if ($status === "gap") {
            if ($debug) echo "Prüfe GAP für Benutzer $user_id<br>";
            $found_gap = checkUserInAssignments($assignments, $user_id, $username);
            if (!$found_gap) {
                $msg = "Main Shift $main_shift_id hat keinen Benutzer $user_id. Lösche TimeBlock_gap.";
                echo "$msg<br>";
                logAndDeleteTimeBlock($contentManager, $PUBLIC_KEY, $location_id, $apikeyPapershift, $date, $shift_id_DB, $user_id, $vorPause_id, $nachPause_id, $msg);
                continue;
            }
        } elseif ($status === "vorpause" || $status === "nachpause") {
            if ($debug) echo "Prüfe PAUSE ($status) für Benutzer $user_id<br>";
            $found_pause = checkUserInAssignments($assignments, $user_id, $username);
            if (!$found_pause) {
                $msg = "Main Shift $main_shift_id hat keinen Benutzer $user_id. Lösche TimeBlock_Pause ($status).";
                echo "$msg<br>";
                logAndDeleteTimeBlock($contentManager, $PUBLIC_KEY, $location_id, $apikeyPapershift, $date, $shift_id_DB, $user_id, $vorPause_id, $nachPause_id, $msg);
                continue;
            }
        } else {
            if ($debug) echo "Prüfe normalen Shift für Benutzer $user_id<br>";
            $found_user = checkUserInAssignments($assignments, $user_id, $username);
            $match_found = null;
            if (!$found_user && !empty($assignments)) {
                $match_found = false;
                foreach ($assignments as $user) {
                    foreach ($getAsseigment_DB as $asseigment_db) {
                        if ($asseigment_db->user_id == $user->id) {
                            $main_shift_name = $asseigment_db->main_shift_name;
                            $main_shift_start_at = $asseigment_db->main_shift_start_at;
                            $main_shift_end_at = $asseigment_db->main_shift_end_at;
                        
                            if ($debug) {
                                echo "<strong>Gefundener Benutzer:</strong> {$user->username} (ID {$user->id})<br>";
                                echo "Vergleiche Block-Zeit [$start_dateTime bis $end_dateTime] mit Main-Shift [$main_shift_start_at bis $main_shift_end_at]<br>";
                            }
                        
                            $block_start_dt = new DateTime($start_dateTime);
                            $block_end_dt = new DateTime($end_dateTime);
                            $main_start_dt = new DateTime($main_shift_start_at);
                            $main_end_dt = new DateTime($main_shift_end_at);
                        
                            if ($block_start_dt < $main_start_dt && $block_end_dt > $main_end_dt) {
                                if ($debug) {
                                    echo "TimeBlock liegt **außerhalb** des Main-Shifts!<br>";
                                    echo "Startvergleich: {$block_start_dt->format('H:i')} < {$main_start_dt->format('H:i')}<br>";
                                    echo "Endvergleich: {$block_end_dt->format('H:i')} > {$main_end_dt->format('H:i')}<br>";
                                }
                                continue;
                            } else {
                                if ($debug) {
                                    echo "TimeBlock liegt vollständig **innerhalb** des Main-Shifts.<br>";
                                }
                            }
                        
                            $match_found = true;
                            $message = "User mit ID = {$user->id} ist innerhalb Datenbank. (Switch)";
                            echo "$message<br>";
                            $contentManager->createLog($contentManager, $PUBLIC_KEY, $location_id, "TimeBlock", "SWITCH", $message);
                        
                            $user_switch[] = [
                                "shift_id" => $shift_id_DB,
                                "date" => $date,
                                "start" => $start,
                                "end" => $end,
                                "user_id" => $asseigment_db->user_id,
                                "username" => $user->username,
                                "main_shift_id" => $asseigment_db->main_shift_id,
                                "main_shift_name" => $main_shift_name,
                                "main_shift_start_at" => $main_shift_start_at,
                                "main_shift_end_at" => $main_shift_end_at,
                                "gap_workingarea_id" => $asseigment_db->gap_workingarea_id,
                                "gap_workingarea_name" => $asseigment_db->gap_workingarea_name
                            ];
                            break 2;
                        }
                        
                    }
                }
                if(!isset($match_found)) {
                    $message = "User mit ID = {$user->id} ist außerhalb Datenbank. (Switch)";
                    echo "$message<br>";
                    $contentManager->createLog($contentManager, $PUBLIC_KEY, $location_id, "TimeBlock", "SWITCH", $message);
                }
            }
            if (!$found_user) {
                $message = "User mit ID = $user_id wurde nicht gefunden. Lösche TimeBlock.";
                echo "$message<br>";
                $contentManager->createLog($contentManager, $PUBLIC_KEY, $location_id, "TimeBlock", "DELETE", $message);
                $user_pause_enfernen [] = ["shift_id" => $shift_id_DB, "user_id" => $user_id, "main_shift_id" => $main_shift_id, "vorPause_id" => $vorPause_id, "nachPause_id" => $nachPause_id];
                logAndDeleteTimeBlock($contentManager, $PUBLIC_KEY, $location_id, $apikeyPapershift, $date, $shift_id_DB, $user_id, $vorPause_id ?? null, $nachPause_id ?? null, $message);
                continue;
            }
        }
        // Verarbeitung nach Status
        if ($status === "gap") {
            $gap_result = $verwaltung->fuegeGapTerminHinzu(
                $user_id, $username, $date, $start, $end,
                $main_start, $main_end, $main_shift_id,
                $virtual_workingarea_id, $virtual_workingarea_name,
                $shift_id_DB, $contentManager
            );
            echo ($gap_result['success'] ? "Erfolg: " : "Fehler: ") . $gap_result['message'] . "<br>";
            if ($debug) { echo "<pre>"; var_dump($gap_result); echo "</pre>"; }
        } elseif ($status === "vorpause" || $status === "nachpause") {
            $result_pause = $verwaltung->fuegePauseAusDatenbankHinzu(
                $user_id, $username, $date, $start, $end,
                $main_start, $main_end, $main_shift_id,
                $virtual_workingarea_id, $virtual_workingarea_name,
                $shift_id_DB, $contentManager
            );
            echo ($result_pause['success'] ? "Erfolg: " : "Fehler: ") . $result_pause['message'] . "<br>";
            if ($debug) { echo "<pre>"; var_dump($result_pause); echo "</pre>"; }
        } else {
            $result = $verwaltung->fuegeTerminHinzu(
                $user_id, $username, $date, $start, $end,
                $shift_id_DB, $main_start, $main_end, $main_shift_id,
                $virtual_workingarea_id, $virtual_workingarea_name,
                $apikeyPapershift, $location_id, $contentManager, null
            );
            echo ($result['success'] ? "Erfolg: " : "Fehler: ") . $result['message'] . "<br>";
            if ($debug) { echo "<pre>"; var_dump($result); echo "</pre>"; }

            if ($result['success']) {
                aendereBelegteZeit($assignmentsByDate_DB, $user_id, $main_shift_id, $date, "+" . $result['belegte_zeit']);
            }
        }
    }

    foreach ($user_pause_enfernen as $user_entfernen) {
        $user_id = $user_entfernen["user_id"];
        $main_shift_id = $user_entfernen["main_shift_id"];
        $vorPause_id = $user_entfernen["vorPause_id"];
        $nachPause_id = $user_entfernen["nachPause_id"];

        if (isset($vorPause_id)) {
            $loeschePause = $verwaltung->loeschePauseMitID($user_id, $date, $main_shift_id, $vorPause_id);
        }
        if (isset($nachPause_id)) {
            $loeschePause = $verwaltung->loeschePauseMitID($user_id, $date, $main_shift_id, $nachPause_id);
        }
    }
}

function checkUserInAssignments($assignments, $user_id, &$username) {
    if (!isset($assignments)) {
        return false;
    }

    foreach ($assignments as $assignment) {
        if ($assignment->id == $user_id) {
            $username = $assignment->username;
            return true;
        }
    }
    return false;
}

function logAndDeleteTimeBlock($contentManager, $PUBLIC_KEY, $location_id, $apikeyPapershift, $date, $shift_id, $user_id, $vorPause_id, $nachPause_id, $msg) {
    // Haupt-Block löschen

    $contentManager->createLog($contentManager, $PUBLIC_KEY, $location_id, "Time_block", "DELETE", $msg);
    $contentManager->deleteTimeBlock($date, $shift_id, $user_id);

    // Pausenblöcke prüfen
    if (isset($vorPause_id)) {
        $contentManager->deleteTimeBlock($date, $vorPause_id, $user_id);
        $contentManager->createLog($contentManager, $PUBLIC_KEY, $location_id, "Time_block", "DELETE_vorPause_id", $msg);
        $data = [
            "api_token" => $apikeyPapershift,
            "shift" => [
                "id" => "$vorPause_id"
            ]
        ];
        $deleteResponse = deleteShiftPapershift($data);
        if ($deleteResponse['http_code'] === 200) {
            echo "<pre>schicht_Pause {$vorPause_id} erfolgreich gelöscht.</pre>";
            $contentManager->deleteEvent($vorPause_id);
        } else {
            echo "<pre>Fehler beim Löschen der Schicht {$vorPause_id}</pre>";
        }
    }

    if (isset($nachPause_id)) {
        $contentManager->deleteTimeBlock($date, $nachPause_id, $user_id);
        $contentManager->createLog($contentManager, $PUBLIC_KEY, $location_id, "Time_block", "DELETE_nachPause_id", $msg);
        $data = [
            "api_token" => $apikeyPapershift,
            "shift" => [
                "id" => "$nachPause_id"
            ]
        ];
        $deleteResponse = deleteShiftPapershift($data);
        if ($deleteResponse['http_code'] === 200) {
            echo "<pre>schicht_Pause {$nachPause_id} erfolgreich gelöscht.</pre>";
            $contentManager->deleteEvent($nachPause_id);
        } else {
            echo "<pre>Fehler beim Löschen der Schicht {$nachPause_id}</pre>";
        }
    }
}

function logAndDeleteTimeBlockAndShift_Pause($contentManager, $apikeyPapershift, $date, $shift_id, $user_id) {
    // Haupt-Block löschen
    $contentManager->deleteTimeBlock($date, $shift_id, $user_id);
    $data = [
        "api_token" => $apikeyPapershift,
        "shift" => [
            "id" => "$shift_id"
        ]
    ];
    $deleteResponse = deleteShiftPapershift($data);
    if ($deleteResponse['http_code'] === 200) {
        echo "<pre>schicht_Pause {$shift_id} erfolgreich gelöscht.</pre>";
    } else {
        echo "<pre>Fehler beim Löschen der Schicht {$shift_id}</pre>";
    }
}

function hasEmptyShiftTag($tags) {
    foreach ($tags as $tag) {
        if ($tag->external_id === "empty_shift") {
            return true;
        }
    }
    return false;
}

function availabilities_regiondo($details_efficiently, $rangeStart, $rangeEnd, $now, $listOfBookingsRegiondo = null) {
    $result = [];
    foreach ($details_efficiently as $arbeits_bereich => $details) {
        foreach ($details as $detail) {
            $produkt_id = $detail["product_id"];
            $produkt_name = $detail["name"];
            $duration_type = $detail["duration_type"];
            $duration_values = $detail["duration_values"];
            if (empty($detail["variations"]))continue;
            $variations = $detail["variations"];
            foreach ($variations as $variation) {
                $variation_id = $variation["variation_id"];
                $variation_name = $variation["name"] ?? null;
                $timeslotsRegiondo = availabilities_update($variation_id, $rangeStart, $rangeEnd, $duration_type , $duration_values);
                $result[$produkt_id][$variation_id] = $timeslotsRegiondo;
            }
        }
    }

    if (!empty($listOfBookingsRegiondo)) {
        foreach ($listOfBookingsRegiondo as $date => $listOfBookings) {
            foreach ($listOfBookings as $produkt_id => $bookings) {
                foreach ($bookings as $variation_id => $list_booking) {
                    foreach ($list_booking as $booking) {
                        $event_date_time = $booking->event_date_time;
                        $duration_type = $booking->duration_type;
                        $duration_value = $booking->duration_value;
                        $dt = new DateTime($event_date_time);

                        // Skip, wenn Startzeit in der Vergangenheit oder jetzt ist
                        if ($dt <= $now) continue;

                        $start_time = $dt->format('H:i:s');
    
                        $note = extractNotes($list_booking, $event_date_time, $variation_id);
                        $note_result["note_string"] = !empty($note) ? toString($note) : "";
       
                        if (!empty($note_result["note_string"]) && isset($note_result["note_string"])) {
                            preg_match('/###(.*?)###/s', $note_result["note_string"], $matchesBlock);
                            $blockContent = isset($matchesBlock[1]) ? trim($matchesBlock[1]) : null;
                            $note_hash_regiondo = hash('sha256', json_encode($blockContent));
                        } else {
                            $note_hash_regiondo = "";
                        }

                        $note_result["note_hash"] = $note_hash_regiondo;
    
                        $slots = &$result[$produkt_id][$variation_id][$date]; 
                        if (!isset($slots)) {
                            $slots = [];
                        }
    
                        $found = false;
    
                        foreach ($slots as &$slot) {
                            if ($slot["starts_at"] === $start_time) {
                                $slot["note"] = $note_result; // nur Note aktualisieren
                                $found = true;
                                break;
                            }
                        }
    
                        if (!$found) {
                            $duration_value = (float) str_replace(',', '.', $duration_value);
                        
                            $start = new DateTime($start_time);
                            $end = clone $start;

                            if ($duration_value == 0) { // Falls duration_value gleich 0 ist
                                $duration_type = "minute";
                                $duration_value = 1;
                            }
                        
                            if ($duration_type === 'minute') {
                                $end->modify("+{$duration_value} minutes");
                            } elseif ($duration_type === 'hour') {
                                $end->modify("+{$duration_value} hours");
                            }
                        
                            $newSlot = [
                                'starts_at' => $start->format('H:i:s'),
                                'ends_at'   => $end->format('H:i:s'),
                                'status'    => "inaktive",
                                'note'      => $note_result
                            ];
                            $slots[] = $newSlot;
                        
                            usort($slots, function($a, $b) {
                                return strcmp($a['starts_at'], $b['starts_at']);
                            });
                        }                        
                    }
                }
            }
        }
    }
    return $result;
}

function uebeuprufen_shifts_and_datenbank($contentManager, $PUBLIC_KEY, $apikeyPapershift, $location_id, &$sortierteSchichten, $rangeStartMitZeit, $rangeEndMitZeit, $now) {
    $eventsByTime_DB = $contentManager->getEventsByTime($contentManager, $PUBLIC_KEY, $location_id, $rangeStartMitZeit, $rangeEndMitZeit, $now);

    $db_ids = [];
    if (!empty($eventsByTime_DB)) {
        foreach ($eventsByTime_DB as $event) {
            $db_ids[] = $event->shift_id_papershift;
        }
    }

    // Alle IDs aus sortierten Schichten einsammeln
    $papershift_ids = [];
    foreach ($sortierteSchichten as $datum => $schichten_am_tag) {
        foreach ($schichten_am_tag as $index => $schicht) {
            $papershift_ids[] = $schicht->id;
        }
    }

    // Schritt 1: Löschen aus DB und $sortierteSchichten, wenn Schicht nicht mehr existiert
    if (!empty($db_ids)) {
        foreach ($db_ids as $id_in_db) {
            if (!in_array($id_in_db, $papershift_ids)) {
                $deleteEvent = $contentManager->deleteEvent($id_in_db);
                if ($deleteEvent) {
                    echo "Lösche Schicht aus der Datenbank: $id_in_db<br>";

                    // Auch aus sortierteSchichten entfernen
                    foreach ($sortierteSchichten as $datum => &$schichten_am_tag) {
                        foreach ($schichten_am_tag as $index => $schicht) {
                            if ($schicht->id == $id_in_db) {
                                unset($schichten_am_tag[$index]);
                                // Index neu ordnen
                                $schichten_am_tag = array_values($schichten_am_tag);
                                break 2;
                            }
                        }
                    }

                } else {
                    echo "Fehler beim Löschen der Schicht aus der Datenbank: $id_in_db<br>";
                }
            }
        }
    }

    // Schritt 2: Neue Schichten löschen, die in Papershift sind aber nicht in der DB
    foreach ($sortierteSchichten as $datum => &$schichten_am_tag) {
        foreach ($schichten_am_tag as $index => $schicht) {
            if (!in_array($schicht->id, $db_ids)) {
                $id_paper = $schicht->id;

                $data = [
                    "api_token" => $apikeyPapershift,
                    "shift" => [
                        "id" => "$id_paper"
                    ]
                ];
                $deleteResponse = deleteShiftPapershift($data);

                if ($deleteResponse['http_code'] === 200) {
                    echo "<pre>Schicht1 {$id_paper} erfolgreich gelöscht.</pre>";
                    $contentManager->deleteEvent($id_paper);
                    unset($schichten_am_tag[$index]);
                    // Index neu ordnen
                    $schichten_am_tag = array_values($schichten_am_tag);
                } else {
                    echo "<pre>Fehler beim Löschen der Schicht {$id_paper}</pre>";
                }
            }
        }
    }
}
function deleteUnwichtigeShifte($contentManager, $apikeyPapershift, $eventsByTime_DB, $list_availabilities, &$sortierteSchichten) {
    $regiondo_shifts_ids = [];

    // Alle gültigen Regiondo-Schicht-IDs einsammeln
    foreach($list_availabilities as $product_id => $availabilities) {
        foreach($availabilities as $variation_id => $availabilitie) {
            foreach($availabilitie as $date => $time_slots) {
                foreach($time_slots as $time_slot) {
                    $starts_at = $time_slot["starts_at"];
                    $shift_id_regiondo = "{$product_id}_{$variation_id}_{$date}_{$starts_at}";
                    $regiondo_shifts_ids[] = $shift_id_regiondo;
                }
            }
        }
    }

    // Unwichtige Schichten löschen (nicht mehr in den gültigen IDs enthalten)
    foreach($eventsByTime_DB as $event) {
        $shift_id_regiondo_DB = $event->shift_id_regiondo;
        $shift_id_papershift = $event->shift_id_papershift;

        if (!in_array($shift_id_regiondo_DB, $regiondo_shifts_ids)) {
            $data = [
                "api_token" => $apikeyPapershift,
                "shift" => [
                    "id" => "$shift_id_papershift"
                ]
            ];
            $deleteResponse = deleteShiftPapershift($data);

            if ($deleteResponse['http_code'] === 200) {
                echo "<pre>Schicht2 {$shift_id_papershift} erfolgreich gelöscht.</pre>";
                $deleteEvent = $contentManager->deleteEvent($shift_id_papershift);

                if ($deleteEvent) {
                    echo "Lösche Schicht aus der Datenbank: $shift_id_papershift<br>";

                    // Auch aus sortierteSchichten entfernen
                    foreach ($sortierteSchichten as $datum => &$schichten_am_tag) {
                        foreach ($schichten_am_tag as $index => $schicht) {
                            if ($schicht->id == $shift_id_papershift) {
                                unset($schichten_am_tag[$index]);
                                // Index neu ordnen
                                $schichten_am_tag = array_values($schichten_am_tag);
                                break 2;
                            }
                        }
                    }

                } else {
                    echo "Fehler beim Löschen der Schicht aus der Datenbank: $shift_id_papershift<br>";
                }

                echo '<pre>Gelöschte Schicht: ';
                var_dump($deleteResponse['response']);
                echo '</pre>';
            }
        }
    }
}

function update_shifts($contentManager, $PUBLIC_KEY, $apikeyPapershift, $location_id, $array_hash, $eventsByTime_DB, $sortierteSchichten, $timeZone) {
    $shift_id_regiondo = $array_hash["shift_id_regiondo"];

    // Regiondo-Zeiten in richtige Zeitzone umwandeln
    $starts_at = new DateTime($array_hash["starts_at"]);
    $starts_at->setTimezone(new DateTimeZone($timeZone));
    $datum = $starts_at->format("Y-m-d");

    $ends_at = new DateTime($array_hash["ends_at"]);
    $ends_at->setTimezone(new DateTimeZone($timeZone));

    $time_slot = $array_hash["time_slot"];
    $note_string = $array_hash["note_string"];
    $note_hash = $array_hash["note_hash"];

    foreach ($eventsByTime_DB as $event) {
        $shift_id_regiondo_DB = $event->shift_id_regiondo;
        $shift_id_papershift_DB = $event->shift_id_papershift;

        if ($shift_id_regiondo == $shift_id_regiondo_DB) {
            if (isset($sortierteSchichten[$datum])) {
                $schichten_am_tag = $sortierteSchichten[$datum];

                foreach ($schichten_am_tag as $shift) {
                    $shift_id_papershift = $shift->id;
                    $shift_note_papershift = $shift->note;

                    
                    // Extrahiere alles zwischen ### und ###
                    preg_match('/###(.*?)###/s', $shift_note_papershift, $matchesBlock);
                    $blockContent = isset($matchesBlock[1]) ? trim($matchesBlock[1]) : null;

                    // Extrahiere alles nach # Note :
                    preg_match('/#\s*Note\s*:\s*(.*)/', $shift_note_papershift, $speicher_note);
                    $noteContent = isset($speicher_note[1]) ? trim($speicher_note[1]) : null;


                    if ($noteContent === null) {
                        $noteContent = ''; // leer lassen, nur der Prefix wird erscheinen
                    }
                    if (!empty($note_string)) {
                        $final_Note = $note_string . PHP_EOL . '# Note : ' . $noteContent;
                    } else {    
                        $final_Note = '# Note : ' . $noteContent;
                    }


                    // Nur wenn die Shift-ID übereinstimmt
                    if ($shift_id_papershift != $shift_id_papershift_DB) continue;

                    $workingarea_id_papershift = $shift->working_area_id;

                    $starts_at_papershift = new DateTime($shift->starts_at);
                    $starts_at_papershift->setTimezone(new DateTimeZone($timeZone));

                    $ends_at_papershift = new DateTime($shift->ends_at);
                    $ends_at_papershift->setTimezone(new DateTimeZone($timeZone));

                    // $note_papershift = $shift->note ?? "";
                    $note_papershift = $blockContent ?? "";
                    $note_hash_papershift = !empty($note_papershift) ? hash('sha256', json_encode($note_papershift)) : "";

                    // Vergleich
                    $same_note = $note_hash_papershift == $note_hash;
                    $same_start = $starts_at->getTimestamp() == $starts_at_papershift->getTimestamp();
                    $same_end = $ends_at->getTimestamp() == $ends_at_papershift->getTimestamp();

                    if ($same_note && $same_start && $same_end) {
                        return true; // Keine Änderung notwendig
                    }

                    // Änderung notwendig → Shift aktualisieren
                    $data = [
                        "api_token" => $apikeyPapershift,
                        "shift" => [
                            "id" => $shift_id_papershift,
                            "location_id" => $location_id,
                            "working_area_id" => $workingarea_id_papershift,
                            "starts_at" => $starts_at->format(DATE_ATOM),
                            "ends_at" => $ends_at->format(DATE_ATOM),
                            "number_of_employees" => 1,
                            "note" => $final_Note
                        ]
                    ];

                    $aktualisieren = updateShiftPapershift($data);
                    $decodedResponse = json_decode($aktualisieren, true);

                    echo '<pre>Aktualisierte Schicht: ';
                    var_dump($aktualisieren);
                    echo '</pre>';

                    // Events-Tabelle aktualisieren
                    $contentManager->updateEvent(
                        $contentManager,
                        $shift_id_papershift,
                        $note_hash,
                        $shift_id_regiondo,
                        $starts_at->format("Y-m-d H:i:s"),
                        $ends_at->format("Y-m-d H:i:s"),
                        $PUBLIC_KEY,
                        $location_id
                    );

                    $message = "ShiftPapershift mit ID $shift_id_papershift wurde in der Events-Tabelle aktualisiert.";
                    echo "$message<br>";
                    $contentManager->createLog($contentManager, $PUBLIC_KEY, $location_id, "Events", "UPDATE", $message);

                    return true;
                }
            }
        }
    }

    return false;
}

function workingsAreaersteller($apikeyPapershift, $location_id) {
    $workplace = [];
    $workingAreasObj = getWorkingAreasPapershift(api_token: $apikeyPapershift, location_id: $location_id);

    if (!isset($workingAreasObj->working_areas) || !is_array($workingAreasObj->working_areas)) {
        exit('Keine gültige Liste von Arbeitsbereichen gefunden.');
    }

    $workingAreas = $workingAreasObj->working_areas;

    $items = [
        "pause",
        "etage1_gap",
        "etage2_gap",
        "etage3_gap",
        "werk_gap"
    ];

    foreach ($items as $item) {
        $exists = false;

        foreach ($workingAreas as $wk) {
            if (!isset($wk->external_id)) {
                exit('external_id ist null.');
            }

            if ($wk->external_id === $item) {
                $workplace[$item] = $wk->id;
                $exists = true;
                break;
            }
        }

        if (!$exists) {
            $data = [
                "api_token" => $apikeyPapershift,
                "location_id" => $location_id,
                "name" => $item,
                "external_id" => $item
            ];

            $result = createNewWorkingAreaPapershift($data);
            echo '<pre>Erstellt: ';
            var_dump($result);
            echo '</pre>';
            $decodedResponse = json_decode($result, true);
            if (isset($decodedResponse) && isset($decodedResponse["id"])) {
                $working_area_id = $decodedResponse["id"];
                $workplace[$item] = $working_area_id;
            }
        }
    }

    foreach ($items as $item) {
        if (!isset($workplace[$item]) || $workplace[$item] === null) {
            exit("Arbeitsbereich $item hat keine gültige ID.");
        }
    }

    return $workplace;
}
function workingsAreaesMainshifts($apikeyPapershift, $location_id) {
    $workplace = [];

    $workingAreasObj = getWorkingAreasPapershift(api_token: $apikeyPapershift, location_id: $location_id);

    if (!isset($workingAreasObj->working_areas) || !is_array($workingAreasObj->working_areas)) {
        exit('Keine gültige Liste von Arbeitsbereichen gefunden.<br>');
    }

    $workingAreas = $workingAreasObj->working_areas;

    // Mapping von Anzeigename => technical_key
    $items = [
        "etage 1" => "etage_1_mainshift",
        "etage 2" => "etage_2_mainshift",
        "etage 3" => "etage_3_mainshift",
        "werktag" => "werktag_mainshift"
    ];

    foreach ($items as $anzeigeName => $technicalKey) {
        $found = false;
        foreach ($workingAreas as $wk) {
            if (isset($wk->external_id) && strtolower(trim($wk->external_id)) === strtolower(trim($technicalKey))) {
                $workplace[$anzeigeName] = $wk->id;
                $found = true;
                break;
            }
        }
        if (!$found) {
            exit("Arbeitsbereich $anzeigeName (Key: $technicalKey) hat keine gültige ID.<br>");
        }
    }

    return $workplace;
}


function virtual_workingarea($contentManager, $PUBLIC_KEY, $location_id, $funktion, $main_shift_name, $workingsAreas_virtuell) {
    $mapping = [
        "etage_1" => "etage 1",
        "etage_2" => "etage 2",
        "etage_3" => "etage 3",
        "werktag" => "werktag"
    ];

    // Virtuellen Namen bestimmen
    $main_shift_key = strtolower(trim($main_shift_name));
    if (!isset($mapping[$main_shift_key])) {
        $message = "Unbekannter Hauptschichtname: $main_shift_name";
        echo "$message<br>";
        $contentManager->createLog($contentManager, $PUBLIC_KEY, $location_id, "Schnittstelle", "FEHLER", $message);
        exit;
    }

    $workArea_name = $mapping[$main_shift_key];
    $workArea_virtuell_id = null;

    // ID zur virtuellen Arbeitsfläche finden
    foreach ($workingsAreas_virtuell as $name => $id) {
        if (strtolower(trim($name)) === strtolower(trim($workArea_name))) {
            $workArea_virtuell_id = $id;
            break;
        }
    }

    // Fehlermeldung, falls ID nicht gefunden
    if ($workArea_virtuell_id == null) {
        $message = "In der Funktion virtual_workingarea gibt es ein Problem – möglicherweise ist workingsAreas_virtuell leer oder enthält den erwarteten Namen nicht. Gesucht: $workArea_name";
        echo "$message<br>";
        $contentManager->createLog($contentManager, $PUBLIC_KEY, $location_id, "Schnittstelle", "FEHLER", $message);
        exit;
    }

    // Rückgabe je nach Funktion
    return ($funktion == "id") ? $workArea_virtuell_id : $workArea_name;
}

function convert_to_gap_Assignments($assignmentsByDate_DB, $contentManager, $verwaltung, $apikeyPapershift, $location_id, $gap_shift_tag_id, $date) {
    echo "hierrrr<br>";
    echo '<pre>';
    echo '$assignmentsByDate_DB';
    echo '<pre>';
    var_dump($assignmentsByDate_DB);
    echo '</pre>';
    foreach ($assignmentsByDate_DB as $location => $assignments) {
        foreach ($assignments as $assignment) {
            $user_id = $assignment->user_id ?? null;
            $main_shift_id = $assignment->main_shift_id ?? null;
            $belegte_zeit = $assignment->belegte_zeit ?? null;
            // if ($belegte_zeit !== "00:00") { 
                $time_blocks = $contentManager->getTime_block_with_date_with_assignment_mainShift($date, $user_id, $main_shift_id);
                echo '<pre>';
                echo '$date';
                echo '<pre>';
                var_dump($date);
                echo '</pre>';
                echo '<pre>';
                echo '$user_id';
                echo '<pre>';
                var_dump($user_id);
                echo '</pre>';
                echo '<pre>';
                echo '$main_shift_id';
                echo '<pre>';
                var_dump($main_shift_id);
                echo '</pre>';
                echo '<pre>';
                echo '$time_blocks';
                echo '<pre>';
                var_dump($time_blocks);
                echo '</pre>';
                if (!empty($time_blocks[0])) {
                $time_block = $time_blocks[0];
                $virtual_workingarea_id = $time_block->virtual_workingarea_id;
                $main_shift_start_at = $time_block->main_shift_start_at;
                $main_shift_end_at = $time_block->main_shift_end_at;
                $convert_result = $verwaltung->convertFreeToGap($user_id, $date, $apikeyPapershift, $location_id, $virtual_workingarea_id, $main_shift_start_at, $main_shift_end_at, $gap_shift_tag_id, $contentManager);
                echo '<pre>'; 
                echo '$convert_result';
                echo '<pre>';
                var_dump($convert_result);
                echo '</pre>';
                echo "hierrrr<br>";
                // }
            }
        }
    }

}

function assignAndDeleteAssignments($assignmentsByDate_DB, $contentManager, $apikeyPapershift, $PUBLIC_KEY, $location_id, $date) {

    foreach ($assignmentsByDate_DB as $location => $assignments) {
        foreach ($assignments as $assignment) {
            echo '<pre>';
            echo '$assignment in assignAndDeleteAssignments';
            echo '<pre>';
            var_dump($assignment);
            echo '</pre>';
            $user_id = $assignment->user_id ?? null;
            $main_shift_id = $assignment->main_shift_id ?? null;
            $belegte_zeit = $assignment->belegte_zeit ?? null;

            // Validierung der notwendigen Daten
            if ($user_id === null || $main_shift_id === null || $belegte_zeit !== "00:00") {
                $message = "Ungültige Daten für Zuweisung to MainShift: user_id={$user_id}, main_shift_id={$main_shift_id}, belegte_zeit={$belegte_zeit}";
                echo "$message<br>";
                error_log($message);
                $contentManager->createLog($contentManager, $PUBLIC_KEY, $location_id, "Events", "Fehlerhafte Zuweisung", $message);
                continue;
            }

            $requestData = [
                "api_token" => $apikeyPapershift,
                "assignment" => [
                    "shift_id" => $main_shift_id,
                    "user_id" => $user_id
                ]
            ];

            try {
                $response = assignUserToShiftPapershift($requestData);
                $decodedResponse = json_decode($response, true);

                if (json_last_error() !== JSON_ERROR_NONE) {
                    throw new Exception("JSON-Dekodierung fehlgeschlagen: " . json_last_error_msg());
                }

                $assignmentSuccessful = !empty($decodedResponse["users"]["assigned"] ?? []);
                if (!$assignmentSuccessful) {
                    $message = "Zuweisung fehlgeschlagen zu Main_shift für User-ID {$user_id}. Antwort: " . ($response ?? 'keine Antwort');
                    echo "$message<br>";
                    error_log($message);
                    $contentManager->createLog($contentManager, $PUBLIC_KEY, $location_id, "Events", "Zuweisung für MainShift", $message);
                    continue;
                }

                // Löschen der Zuweisung nach erfolgreicher API-Operation
                $deleteSuccess = $contentManager->deleteAssignment($user_id, $main_shift_id, $date);

                if (!$deleteSuccess) {
                    $message = "Zuweisung zu Main_shift und Löschung aus der Datenbank fehlgeschlagen für User-ID {$user_id}, Shift-ID {$main_shift_id}";
                    echo "$message<br>";
                    error_log($message);
                    $contentManager->createLog($contentManager, $PUBLIC_KEY, $location_id, "Events", "Löschfehler MainShift", $message);
                } else {
                    $message = "Zuweisung zu Main_shift und Löschung aus der Datenbank erfolgreich für User-ID {$user_id}, Shift-ID {$main_shift_id}";
                    echo "$message<br>";
                    $contentManager->createLog($contentManager, $PUBLIC_KEY, $location_id, "Events", "Erfolg MainShift", $message);
                }

            } catch (Exception $e) {
                $error_message = "Fehler bei der Zuweisung für User-ID {$user_id}: " . $e->getMessage();
                echo "$error_message<br>";
                error_log($error_message);
                $contentManager->createLog($contentManager, $PUBLIC_KEY, $location_id, "Events", "Exception MainShift", $error_message);
            }
        }
    }
}

function calculatePauseTimes($position, $date, $referenceTime, $mainTime, $pauseInMinutes, $debug = false) {
    try {
        $debugInfo = [];

        $referenceDateTime = new DateTime("$date $referenceTime");
        $mainDateTime = new DateTime("$date $mainTime");

        $debugInfo['input'] = [
            'position' => $position,
            'date' => $date,
            'referenceTime' => $referenceTime,
            'mainTime' => $mainTime,
            'pauseInMinutes' => $pauseInMinutes
        ];
        $debugInfo['referenceDateTime'] = $referenceDateTime->format('Y-m-d H:i');
        $debugInfo['mainDateTime'] = $mainDateTime->format('Y-m-d H:i');

        // gleiche Zeit = keine Pause
        if ($referenceDateTime->format('Y-m-d H:i') === $mainDateTime->format('Y-m-d H:i')) {
            return [
                'success' => true,
                'message' => "Keine Pause hinzugefügt, da Vergleichszeit ($referenceTime) gleich Hauptzeit ($mainTime) ist.",
                'pauseStartTime' => null,
                'pauseEndTime' => null,
                'debug' => $debug ? $debugInfo : null
            ];
        }

        if ($position === 'nachpause') {
            // Sicherheit: mainTime muss NACH referenceTime liegen
            if ($mainDateTime <= $referenceDateTime) {
                $debugInfo['error'] = 'Hauptzeit liegt vor oder gleich Vergleichszeit bei nachpause.';
                return [
                    'success' => false,
                    'message' => "Fehler: Hauptzeit ($mainTime) liegt vor oder gleich Vergleichszeit ($referenceTime) bei nachpause.",
                    'pauseStartTime' => null,
                    'pauseEndTime' => null,
                    'debug' => $debug ? $debugInfo : null
                ];
            }

            $pauseStartTime = clone $referenceDateTime;
            $pauseStartTime->modify("+1 minute");
            $pauseEndTime = clone $pauseStartTime;
            $pauseEndTime->modify("+{$pauseInMinutes} minutes");

            $debugInfo['pauseStartTime_before_cut'] = $pauseStartTime->format('H:i');
            $debugInfo['pauseEndTime_before_cut'] = $pauseEndTime->format('H:i');

            // ggf. kürzen
            if ($pauseEndTime > $mainDateTime) {
                $pauseEndTime = clone $mainDateTime;
                $debugInfo['pauseEndTime_cut_to_main'] = $pauseEndTime->format('H:i');
            }

        } elseif ($position === 'vorpause') {
            // Sicherheit: mainTime muss VOR referenceTime liegen
            if ($mainDateTime >= $referenceDateTime) {
                $debugInfo['error'] = 'Hauptzeit liegt nach oder gleich Vergleichszeit bei vorpause.';
                return [
                    'success' => false,
                    'message' => "Fehler: Hauptzeit ($mainTime) liegt nach oder gleich Vergleichszeit ($referenceTime) bei vorpause.",
                    'pauseStartTime' => null,
                    'pauseEndTime' => null,
                    'debug' => $debug ? $debugInfo : null
                ];
            }

            $pauseEndTime = clone $referenceDateTime;
            $pauseEndTime->modify("-1 minute");
            $pauseStartTime = clone $pauseEndTime;
            $pauseStartTime->modify("-{$pauseInMinutes} minutes");

            $debugInfo['pauseEndTime_before_adjust'] = $pauseEndTime->format('H:i');
            $debugInfo['pauseStartTime_before_adjust'] = $pauseStartTime->format('H:i');

            if ($pauseStartTime < new DateTime("$date 00:00")) {
                $pauseStartTime = new DateTime("$date 00:00");
                $debugInfo['pauseStartTime_adjusted_to_midnight'] = $pauseStartTime->format('H:i');
            }
        } else {
            return [
                'success' => false,
                'message' => "Ungültiger Pausentyp '$position'. Muss 'vorpause' oder 'nachpause' sein.",
                'pauseStartTime' => null,
                'pauseEndTime' => null,
                'debug' => $debug ? $debugInfo : null
            ];
        }

        return [
            'success' => true,
            'message' => "Pausenzeiten berechnet: {$pauseStartTime->format('H:i')} bis {$pauseEndTime->format('H:i')}.",
            'pauseStartTime' => $pauseStartTime->format('H:i'),
            'pauseEndTime' => $pauseEndTime->format('H:i'),
            'debug' => $debug ? $debugInfo : null
        ];

    } catch (Exception $e) {
        return [
            'success' => false,
            'message' => "Fehler bei der Berechnung der Pausenzeiten: " . $e->getMessage(),
            'pauseStartTime' => null,
            'pauseEndTime' => null,
            'debug' => $debug ? ['exception' => $e->getMessage()] : null
        ];
    }
}




function assignUserToShift($api_key, $shift_id, $user_id, $contentManager, $PUBLIC_KEY, $location_id) {
    $requestData = [
        "api_token" => $api_key,
        "assignment" => [
            "shift_id" => $shift_id,
            "user_id" => $user_id
        ]
    ];

    $zuweisen = assignUserToShiftPapershift($requestData);
    $decodedResponse = json_decode($zuweisen, true);

    // Debugging
    echo '<pre>';
    echo '$decodedResponse';
    echo '<pre>';
    var_dump($decodedResponse);
    echo '</pre>';

    // Check if assignment was successful
    $assignmentErfolgreich = isset($decodedResponse["users"]["assigned"]) && !empty($decodedResponse["users"]["assigned"]);
    if (!$assignmentErfolgreich) {
        $message = "Zuweisung fehlgeschlagen für User-ID {$user_id}. Antwort:<br>";
        echo "$message<br>";
        echo '<pre>';
        var_dump($zuweisen);
        echo '</pre>';
        $contentManager->createLog($contentManager, $PUBLIC_KEY, $location_id, "Assignment", "User_zuweisen", $message);
        return false;
    }

    $message = "Zuweisung erfolgreich für User-ID {$user_id}. Antwort:<br>";
    echo "$message<br>";
    $contentManager->createLog($contentManager, $PUBLIC_KEY, $location_id, "Assignment", "User_zuweisen", $message);
    return true;
}

function pruefePauseMoeglichkeit(
    $pauseType, $verwaltung, $user_id, $username, $date, $referenceTime, $mainTime,
    $main_shift_start_at, $main_shift_end_at, $main_shift_id, $virtual_workingarea_id,
    $virtual_workingarea_name, $pause
) {

    $pauseTime = calculatePauseTimes($pauseType, $date, $referenceTime, $mainTime, $pause);

    if ($pauseTime["success"]) {
        $ref = new DateTime("$date $referenceTime");
        $main = new DateTime("$date $mainTime");

        if ($ref->format('Y-m-d H:i') === $main->format('Y-m-d H:i')) {
            return true;
        } elseif (isset($pauseTime["pauseStartTime"], $pauseTime["pauseEndTime"])) {
            $result_test = $verwaltung->kannPauseEingefuegtWerden(
                $user_id,
                $username,
                $date,
                $pauseTime["pauseStartTime"],
                $pauseTime["pauseEndTime"],
                $main_shift_start_at,
                $main_shift_end_at,
                $main_shift_id,
                $virtual_workingarea_id,
                $virtual_workingarea_name,
                $pause
            );
          
            if ($result_test['success']) {
                return true;
            }
        }
    }
    return false;
}

function bearbeitePauseTypen($pause, $date, $start_time, $end_time, $main_shift_start_at, $main_shift_end_at, $main_shift_id, $main_shift_name,
 $shift_id, $user_id, $username, $virtual_workingarea_id, $virtual_workingarea_name, $apikeyPapershift, $location_id, $pause_tag_id,
  $contentManager, $verwaltung, $PUBLIC_KEY, &$result, $debug = false) {

    if ($debug) {
        echo "<hr><strong>Debug-Start von bearbeitePauseTypen:</strong><br>";
        echo "pause: "; var_dump($pause);
        echo "date: $date<br>";
        echo "start_time: $start_time<br>";
        echo "end_time: $end_time<br>";
        echo "main_shift_start_at: $main_shift_start_at<br>";
        echo "main_shift_end_at: $main_shift_end_at<br>";
        echo "main_shift_id: $main_shift_id<br>";
        echo "main_shift_name: $main_shift_name<br>";
        echo "shift_id: $shift_id<br>";
        echo "user_id: $user_id<br>";
        echo "username: $username<br>";
        echo "virtual_workingarea_id: $virtual_workingarea_id<br>";
        echo "virtual_workingarea_name: $virtual_workingarea_name<br>";
        echo "apikeyPapershift: $apikeyPapershift<br>";
        echo "location_id: $location_id<br>";
        echo "pause_tag_id: $pause_tag_id<br>";
        echo "PUBLIC_KEY: $PUBLIC_KEY<br>";
        echo '<pre>';
        echo "result: ";
        echo '<pre>';
        var_dump($result);
        echo '</pre>';
        echo "<hr>";
    }

    foreach (["vorpause", "nachpause"] as $pauseType) {
        if ($debug) echo "<hr><strong>Bearbeite: $pauseType</strong><br>";

        $referenceTime = $pauseType === "vorpause" ? $start_time : $end_time;
        $mainTime = $pauseType === "vorpause" ? $main_shift_start_at : $main_shift_end_at;

        if ($debug) {
            echo "referenceTime: $referenceTime<br>";
            echo "mainTime: $mainTime<br>";
        }

        $pauseTime = calculatePauseTimes($pauseType, $date, $referenceTime, $mainTime, $pause);
        if ($debug) {
            echo "<pre>pauseTime:\n";
            var_dump($pauseTime);
            echo "</pre>";
        }

        if ($pauseTime["success"]) {
            if (isset($pauseTime["pauseStartTime"], $pauseTime["pauseEndTime"])) {
                $pause_result = $verwaltung->fuegePauseHinzu(
                    $user_id,
                    $username,
                    $date,
                    $pauseTime["pauseStartTime"],
                    $pauseTime["pauseEndTime"],
                    $main_shift_start_at,
                    $main_shift_end_at,
                    $main_shift_id,
                    $virtual_workingarea_id,
                    $virtual_workingarea_name,
                    $pause_time['id'] ?? null,
                    $apikeyPapershift,
                    $location_id,
                    $pause_tag_id,
                    $pause,
                    $contentManager
                );

                if ($debug) {
                    echo "<pre>pause_result:\n";
                    var_dump($pause_result);
                    echo "</pre>";
                }

                if (($pause_result['success']) && isset($pause_result["id"])) {
                    $message = $pause_result["message"];
                    echo "$message<br>";
                    $contentManager->createLog($contentManager, $PUBLIC_KEY, $location_id, "TimeBlock", ucfirst($pauseType), $message);

                    $shift_pause_id = $pause_result["id"];

                    if (!assignUserToShift($apikeyPapershift, $shift_pause_id, $user_id, $contentManager, $PUBLIC_KEY, $location_id)) {
                        $result['success'] = false;
                        $message = "user mit $user_id nicht in shift(für Pause) mit id = $shift_pause_id hinzugefügt. Shift wurde von Papershift und Datenbank gelöscht.";
                        echo "$message<br>";
                        logAndDeleteTimeBlockAndShift_Pause($contentManager, $apikeyPapershift, $date, $shift_pause_id, $user_id);
                        $verwaltung->loeschePauseMitID($user_id, $date, $main_shift_id, $shift_pause_id);
                        $contentManager->createLog($contentManager, $PUBLIC_KEY, $location_id, "TimeBlock", ucfirst($pauseType)."Delete", $message);
                        continue;
                    }
      
                    $contentManager->createTimeBlock(
                        $user_id,
                        $username,
                        $date,
                        $pauseTime["pauseStartTime"],
                        $pauseTime["pauseEndTime"],
                        $shift_pause_id,
                        $main_shift_id,
                        $main_shift_name,
                        $main_shift_start_at,
                        $main_shift_end_at,
                        $virtual_workingarea_id,
                        $virtual_workingarea_name,
                        $pause,
                        $pauseType
                    );

                    if ($pauseType === "nachpause") {
                        $contentManager->fuegeNachPause_idInTimeBlock($shift_id, $shift_pause_id);
                    } else {
                        $contentManager->fuegeVorPause_idInTimeBlock($shift_id, $shift_pause_id);
                    }
                } else {
                    $message = "Fehler beim Hinzufügen der " . ucfirst($pauseType) . ": " . $pause_result["message"];
                    echo "$message<br>";
                    $contentManager->createLog($contentManager, $PUBLIC_KEY, $location_id, "TimeBlock", ucfirst($pauseType), $message);
                    $result['success'] = false;
                }
            }
        } else {
            $message = "Keine " . ucfirst($pauseType) . " verfügbar: " . ($pauseTime["message"] ?? 'unbekannt');
            echo "$message<br>";
            $contentManager->createLog($contentManager, $PUBLIC_KEY, $location_id, "TimeBlock", ucfirst($pauseType), $message);
            $result['success'] = false;
        }
    }
}


    
/* ----------------------------------------------------------------- */