<?php

include_once "time.php";
include_once "globals.php";

/* ----------------------------------------------------------------- */
/*                       Local helper functions                      */
function logGeneric($message) {
    global $systemTime;
    $stopTimerForLogs = stopTimerForLogs($systemTime);
    $hours = (int)($stopTimerForLogs / 3600);    // Stunden
    $minutes = (int)(($stopTimerForLogs % 3600) / 60); // Minuten
    $seconds = $stopTimerForLogs % 60;          // Sekunden
    echo sprintf("%02d:%02d:%02d : %s.<br>", $hours, $minutes, $seconds, $message );
}

function logFunctions($message, $functionName) {
    global $systemTime;
    $stopTimerForLogs = stopTimerForLogs($systemTime);
    $hours = (int)($stopTimerForLogs / 3600);    // Stunden
    $minutes = (int)(($stopTimerForLogs % 3600) / 60); // Minuten
    $seconds = $stopTimerForLogs % 60;          // Sekunden
    echo sprintf("%02d:%02d:%02d : Function %s : %s.<br>", $hours, $minutes, $seconds, $stopTimerForLogs, $functionName, $message);
}

function logShift($message, $shift_id) {
    global $systemTime;
    $stopTimerForLogs = stopTimerForLogs($systemTime);
    $hours = (int)($stopTimerForLogs / 3600);    // Stunden
    $minutes = (int)(($stopTimerForLogs % 3600) / 60); // Minuten
    $seconds = $stopTimerForLogs % 60;          // Sekunden
    echo sprintf("%02d:%02d:%02d : Shift id = %d : %s.<br>", $hours, $minutes, $seconds, $shift_id, $message);
}

/* ----------------------------------------------------------------- */
