<?php
include_once "globals.php";
// $headUrl = "https://sandbox-api.regiondo.com/v1/"; //demo
$headUrl = "https://api.regiondo.com/v1/"; //orginal

/* ----------------------------------------------------------------- */
/*                            GET Functions                          */

//200
function GETListoflocalesRegiondo($suppress_response_code = NULL, $debug = NULL, $sandboxauth = NULL) {
    GLOBAL $headUrl;
    // Basis-URL der API
    $baseUrl = $headUrl."account/locale";

    // Parameter in ein Array einfügen
    $params = [
        'suppress_response_code' => $suppress_response_code,
        'debug' => $debug,
        'sandboxauth' => $sandboxauth
    ];

    // Entferne NULL-Werte aus den Parametern
    $params = array_filter($params, function($value) {
        return !is_null($value);
    });

    // URL mit Parametern erweitern
    $url = $baseUrl . '?' . http_build_query($params);

    // API-Anfrage ausführen und das Ergebnis zurückgeben
    return executeCurlRequest($url);
}
//200
function GETListCategoriesRegiondo($suppress_response_code = 'false', $debug = 'false', $sandboxauth = 'true', $store_locale = NULL, $level = NULL, $parent_id = NULL, $limit = 10, $offset = NULL
) {

    GLOBAL $headUrl;
    // Basis-URL der API
    $baseUrl = $headUrl."categories";

    // Parameter in ein Array einfügen
    $params = [
        'suppress_response_code' => $suppress_response_code,
        'debug' => $debug,
        'sandboxauth' => $sandboxauth,
        'store_locale' => $store_locale,
        'level' => $level,
        'parent_id' => $parent_id,
        'limit' => $limit,
        'offset' => $offset
    ];

    // Entferne NULL-Werte aus den Parametern
    $params = array_filter($params, function($value) {
        return !is_null($value);
    });

    // URL mit Parametern erweitern
    $url = $baseUrl . '?' . http_build_query($params);

    // API-Anfrage ausführen und das Ergebnis zurückgeben
    return executeCurlRequest($url);
}
//200
function GETCategoryByIdRegiondo($categoryId, $suppress_response_code = 'false', $debug = 'false', $sandboxauth = 'true') {
    // Basis-URL für die API
    GLOBAL $headUrl;
    $baseUrl = $headUrl."categories/{$categoryId}";

    // Parameter in ein Array einfügen
    $params = [
        'suppress_response_code' => $suppress_response_code,
        'debug' => $debug,
        'sandboxauth' => $sandboxauth
    ];

    // Entferne NULL-Werte aus den Parametern
    $params = array_filter($params, function($value) {
        return !is_null($value);
    });

    // URL mit Parametern erweitern
    $url = $baseUrl . '?' . http_build_query($params);

    // API-Anfrage ausführen und das Ergebnis zurückgeben
    return executeCurlRequest($url);
}
//200
function GETHoldRequestsRegiondo($suppress_response_code = 'false', $debug = 'false', $sandboxauth = 'true') {
    // Basis-URL der API
    GLOBAL $headUrl;
    $baseUrl = $headUrl."checkout/hold";

    // Parameter in ein Array einfügen
    $params = [
        'suppress_response_code' => $suppress_response_code,
        'debug' => $debug,
        'sandboxauth' => $sandboxauth
    ];

    // Entferne NULL-Werte aus den Parametern
    $params = array_filter($params, function($value) {
        return !is_null($value);
    });

    // URL mit Parametern erweitern
    $url = $baseUrl . '?' . http_build_query($params);

    // API-Anfrage ausführen und das Ergebnis zurückgeben
    return executeCurlRequest($url);
}

function GETLocationsRegiondo(
    $suppress_response_code = 'false', 
    $debug = 'false', 
    $sandboxauth = 'true', 
    $store_locale = NULL, 
    $limit = 10, 
    $offset = NULL, $location_type = NULL, $is_general = NULL, $country_code = NULL
) {
    // Basis-URL der API
    GLOBAL $headUrl;
    $baseUrl = $headUrl."locations";

    // Parameter in ein Array einfügen
    $params = [
        'suppress_response_code' => $suppress_response_code,
        'debug' => $debug,
        'sandboxauth' => $sandboxauth,
        'store_locale' => $store_locale,
        'limit' => $limit,
        'offset' => $offset,
        'location_type' => $location_type,
        'is_general' => $is_general,
        'country_code' => $country_code
    ];

    // Entferne NULL-Werte aus den Parametern
    $params = array_filter($params, function($value) {
        return !is_null($value);
    });

    // URL mit Parametern erweitern
    $url = $baseUrl . '?' . http_build_query($params);

    // API-Anfrage ausführen und das Ergebnis zurückgeben
    return executeCurlRequest($url);
}

function GETProductByIdRegiondo(
    // Returns a single product
    $productId,
    $suppress_response_code = 'false',
    $debug = 'false',
    $sandboxauth = 'true',
    $store_locale = NULL,
    $currency = NULL
) {
    // Basis-URL der API
    GLOBAL $headUrl;
    $baseUrl = $headUrl."products/{$productId}";

    // Parameter in ein Array einfügen
    $params = [
        'suppress_response_code' => $suppress_response_code,
        'debug' => $debug,
        'sandboxauth' => $sandboxauth,
        'store_locale' => $store_locale,
        'currency' => $currency
    ];

    // Entferne NULL-Werte aus den Parametern
    $params = array_filter($params, function ($value) {
        return !is_null($value);
    });

    // URL mit Parametern erweitern
    $url = $baseUrl . '?' . http_build_query($params);

    // API-Anfrage ausführen und das Ergebnis zurückgeben
    return executeCurlRequest($url);
}

// https://api.regiondo.com/v1/products?suppress_response_code=false&debug=false&sandboxauth=true&store_locale=en-US&limit=100&offset=1&sort_by=default&active_only=false&include_value_vouchers=0&currency=default
 
// https://api.regiondo.com/v1/products?suppress_response_code=false&debug=false&sandboxauth=true&store_locale=de-DE&limit=100&offset=1&sort_by=default&active_only=false&include_value_vouchers=0&currency=default
 
function GETProductRegiondo(
    // List products
    $suppress_response_code = 'false',
    $debug = 'false',
    $sandboxauth = 'true',
    $store_locale = NULL,
    $currency = NULL
) {
    // Basis-URL der API
    GLOBAL $headUrl;
    $baseUrl = $headUrl."products";

    // Parameter in ein Array einfügen
    $params = [
        'suppress_response_code' => $suppress_response_code,
        'debug' => $debug,
        'sandboxauth' => $sandboxauth,
        'store_locale' => $store_locale,
        'currency' => $currency
    ];

    // Entferne NULL-Werte aus den Parametern
    $params = array_filter($params, function ($value) {
        return !is_null($value);
    });

    // URL mit Parametern erweitern
    $url = $baseUrl . '?' . http_build_query($params);

    // API-Anfrage ausführen und das Ergebnis zurückgeben
    return executeCurlRequest($url);
}
function GETVariationIdsRegiondo($sandboxauth = NULL, $product_ids = NULL, $category_ids = NULL, $guide_ids = NULL, $resource_ids = NULL) {
    // Basis-URL der API
    GLOBAL $headUrl;
    $baseUrl = $headUrl."products/variationids";

    // Parameter in ein Array einfügen
    $params = [
        'sandboxauth' => $sandboxauth,
        'product_ids' => $product_ids,
        'category_ids' => $category_ids,
        'guide_ids' => $guide_ids,
        'resource_ids' => $resource_ids
    ];

    // Entferne NULL-Werte aus den Parametern
    $params = array_filter($params, function($value) {
        return !is_null($value);
    });

    // URL mit Parametern erweitern
    $url = $baseUrl . '?' . http_build_query($params);

    // API-Anfrage ausführen und das Ergebnis zurückgeben
    return executeCurlRequest($url);
}

//kar nemikone invalid JSON response = []
function GETListOfBookings_partner_Regiondo(
    // List of bookings  => partner
    $suppress_response_code = 'false',
    $debug = 'false',
    $sandboxauth = 'true',
    $limit = 10,
    $offset = NULL,
    $date_range_by = NULL,
    $date_range = NULL,
    $product_ids = NULL,
    $order_ids = NULL,
    $booking_key = NULL,
    $resource_ids = NULL,
    $status = NULL,
    $type = NULL,
    $payment_method = "all",
    $channel = "all"
) {
    // Basis-URL der API
    GLOBAL $headUrl;
    $baseUrl = $headUrl."partner/bookings";
    echo '<pre>';
    echo '$baseUrl';
    echo '<pre>';
    var_dump($baseUrl);
    echo '</pre>';

    // Parameter in ein Array einfügen
    $params = [
        'suppress_response_code' => $suppress_response_code,
        'debug' => $debug,
        'sandboxauth' => $sandboxauth,
        'limit' => $limit,
        'offset' => $offset,
        'date_range_by' => $date_range_by,
        'date_range' => $date_range,
        'product_ids' => $product_ids,
        'order_ids' => $order_ids,
        'booking_key' => $booking_key,
        'resource_ids' => $resource_ids,
        'status' => $status,
        'type' => $type,
        'payment_method' => $payment_method,
        'channel' => $channel

    ];

    // Entferne NULL-Werte aus den Parametern
    $params = array_filter($params, function($value) {
        return !is_null($value);
    });

    // URL mit Parametern erweitern
    $url = $baseUrl . '?' . http_build_query($params);
    echo '<pre>';
    echo '$url';
    echo '<pre>';
    var_dump($url);
    echo '</pre>';

    // API-Anfrage ausführen und das Ergebnis zurückgeben
    return executeCurlRequest($url);
}
function GETListOfSoldItems_supplier_Regiondo(
    // List of sold items ( New ) supplier
    $suppress_response_code = 'false',
    $debug = 'false',
    $sandboxauth = 'true',
    $limit = 10,
    $offset = NULL,
    $date_range_by = NULL,
    $date_range = NULL,
    $product_ids = NULL,
    $order_ids = NULL,
    $booking_key = NULL,
    $resource_ids = NULL,
    $status = NULL,
    $type = NULL,
    $payment_method = "all",
    $channel = "all"
) {
    // Basis-URL der API
    GLOBAL $headUrl;
    $baseUrl = $headUrl."supplier/solditemslist";

    // Parameter in ein Array einfügen
    $params = [
        'suppress_response_code' => $suppress_response_code,
        'debug' => $debug,
        'sandboxauth' => $sandboxauth,
        'order_number' => $order_ids,
        'booking_key' => $booking_key,
        'resource_ids' => $resource_ids,
        'status' => $status,
        'type' => $type,
        'payment_method' => $payment_method,
        'channel' => $channel,
        'limit' => $limit,
        'offset' => $offset,
        'date_range_by' => $date_range_by,
        'date_range' => $date_range,
        'product_ids' => $product_ids
    ];

    // Entferne NULL-Werte aus den Parametern
    $params = array_filter($params, function($value) {
        return !is_null($value);
    });

    // URL mit Parametern erweitern
    $url = $baseUrl . '?' . http_build_query($params);

    // API-Anfrage ausführen und das Ergebnis zurückgeben
    return executeCurlRequest($url);
}
// function GETListOfSoldItemsRegiondo(
//     // List of sold items ( New )
//     $suppress_response_code = 'false',
//     $debug = 'false',
//     $sandboxauth = 'true',
//     $product_ids = NULL,
//     $type = NULL,
//     $payment_method = NULL,
//     $channel = NULL,
//     $limit = 10,
//     $offset = NULL,
//     $order_number = NULL,
//     $date_range = NULL,
//     $date_range_by = NULL
// ) {
//     // Basis-URL der API
//     $baseUrl = "https://sandbox-api.regiondo.com/v1/partner/solditemslist";

//     // Parameter in ein Array einfügen
//     $params = [
//         'suppress_response_code' => $suppress_response_code,
//         'debug' => $debug,
//         'sandboxauth' => $sandboxauth,
//         'product_ids' => $product_ids,
//         'type' => $type,
//         'payment_method' => $payment_method,
//         'channel' => $channel,
//         'limit' => $limit,
//         'offset' => $offset,
//         'order_number' => $order_number,
//         'date_range' => $date_range,
//         'date_range_by' => $date_range_by
//     ];

//     // Entferne NULL-Werte aus den Parametern
//     $params = array_filter($params, function ($value) {
//         return !is_null($value);
//     });

//     // URL mit Parametern erweitern
//     $url = $baseUrl . '?' . http_build_query($params);

//     // API-Anfrage ausführen und das Ergebnis zurückgeben
//     return executeCurlRequest($url);
// }

//wichtig1

function GETAvailabilitiesByVariationIdRegiondo(
    // Get a list of dates/times by variation ID
    $variationId,
    $dt_from,
    $dt_to,
    $suppress_response_code = 'false',
    $debug = 'false',
    $sandboxauth = 'true',
    $store_locale = NULL,
    $show_soldout = 'false'
) {
    // Basis-URL der API
    GLOBAL $headUrl;
    $baseUrl = $headUrl."products/availabilities/{$variationId}";

    // Parameter in ein Array einfügen
    $params = [
        'suppress_response_code' => $suppress_response_code,
        'debug' => $debug,
        'sandboxauth' => $sandboxauth,
        'store_locale' => $store_locale,
        'dt_from' => $dt_from,
        'dt_to' => $dt_to,
        'show_soldout' => $show_soldout
    ];

    // Entferne NULL-Werte aus den Parametern
    $params = array_filter($params, function ($value) {
        return !is_null($value);
    });

    // URL mit Parametern erweitern
    $url = $baseUrl . '?' . http_build_query($params);

    // API-Anfrage ausführen und das Ergebnis zurückgeben
    return executeCurlRequest($url);
}


//200
function GETAvailableOptionsByVariationIdRegiondo(
    $variationId,
    $suppress_response_code = 'false',
    $debug = 'false',
    $sandboxauth = 'true',
    $store_locale = NULL,
    $currency = NULL,
    $date = NULL,
    $time = NULL
) {
    // Basis-URL der API
    GLOBAL $headUrl;
    $baseUrl = $headUrl."products/availoptions/{$variationId}";

    // Parameter in ein Array einfügen
    $params = [
        'suppress_response_code' => $suppress_response_code,
        'debug' => $debug,
        'sandboxauth' => $sandboxauth,
        'store_locale' => $store_locale,
        'currency' => $currency,
        'date' => $date,
        'time' => $time
    ];

    // Entferne NULL-Werte aus den Parametern
    $params = array_filter($params, function ($value) {
        return !is_null($value);
    });

    // URL mit Parametern erweitern
    $url = $baseUrl . '?' . http_build_query($params);

    // API-Anfrage ausführen und das Ergebnis zurückgeben
    return executeCurlRequest($url);
}

function GETListOfBookingsRegiondo(
    $suppress_response_code = 'false',
    $debug = 'false',
    $sandboxauth = 'true',
    $limit = 10,
    $offset = NULL,
    $date_range_by = NULL,
    $date_range = NULL,
    $product_ids = NULL,
    $order_ids = NULL,
    $booking_key = NULL,
    $resource_ids = NULL,
    $status = NULL,
    $type = NULL,
    $payment_method = "all",
    $channel = "all"
) {
    // Basis-URL der API
    GLOBAL $headUrl;
    $baseUrl = $headUrl."supplier/bookings";

    // Parameter in ein Array einfügen
    $params = [
        'suppress_response_code' => $suppress_response_code,
        'debug' => $debug,
        'sandboxauth' => $sandboxauth,
        'order_ids' => $order_ids,
        'booking_key' => $booking_key,
        'resource_ids' => $resource_ids,
        'status' => $status,
        'type' => $type,
        'payment_method' => $payment_method,
        'channel' => $channel,
        'limit' => $limit,
        'offset' => $offset,
        'date_range_by' => $date_range_by,
        'date_range' => $date_range,
        'product_ids' => $product_ids
    ];

    // Entferne NULL-Werte aus den Parametern
    $params = array_filter($params, function($value) {
        return !is_null($value);
    });

    // URL mit Parametern erweitern
    $url = $baseUrl . '?' . http_build_query($params);

    // API-Anfrage ausführen und das Ergebnis zurückgeben
    return executeCurlRequest($url);
}


//200
function GETAttributesForNavigationRegiondo(
    $suppress_response_code = 'false',
    $debug = 'false',
    $sandboxauth = 'true',
    $store_locale = NULL,
    $currency = NULL,
    $active_only = 'false',
    $category_id = NULL
) {
    // Basis-URL der API
    GLOBAL $headUrl;
    $baseUrl = $headUrl."products/attributesfornavigation";

    // Parameter in ein Array einfügen
    $params = [
        'suppress_response_code' => $suppress_response_code,
        'debug' => $debug,
        'sandboxauth' => $sandboxauth,
        'store_locale' => $store_locale,
        'currency' => $currency,
        'active_only' => $active_only,
        'category_id' => $category_id
    ];

    // Entferne NULL-Werte aus den Parametern
    $params = array_filter($params, function ($value) {
        return !is_null($value);
    });

    // URL mit Parametern erweitern
    $url = $baseUrl . '?' . http_build_query($params);

    // API-Anfrage ausführen und das Ergebnis zurückgeben
    return executeCurlRequest($url);
}

function GETTimeslotsRegiondo(
    $from_datetime, // Erforderlicher Parameter
    $to_datetime,   // Erforderlicher Parameter
    $suppress_response_code = 'false',
    $sandboxauth = 'true',
    $regiondo_variation_id = NULL,
    $regiondo_option_id = NULL,
    $include_past = 'false'
) {
    // Basis-URL der API
    GLOBAL $headUrl;
    $baseUrl = $headUrl."products/timeslots";

    // Überprüfung, ob entweder variation_id oder option_id gesetzt ist
    if (is_null($regiondo_variation_id) && is_null($regiondo_option_id)) {
        throw new InvalidArgumentException("Entweder 'regiondo_variation_id' oder 'regiondo_option_id' muss angegeben werden.");
    }

    // Parameter in ein Array einfügen
    $params = [
        'suppress_response_code' => $suppress_response_code,
        'sandboxauth' => $sandboxauth,
        'regiondo_variation_id' => $regiondo_variation_id,
        'regiondo_option_id' => $regiondo_option_id,
        'from_datetime' => $from_datetime,
        'to_datetime' => $to_datetime,
        'include_past' => $include_past
    ];

    // Entferne NULL-Werte aus den Parametern
    $params = array_filter($params, function ($value) {
        return !is_null($value);
    });

    // URL mit Parametern erweitern
    $url = $baseUrl . '?' . http_build_query($params);

    // API-Anfrage ausführen und das Ergebnis zurückgeben
    return executeCurlRequest($url);
}

function GETTimeslotsDatesRegiondo(
    $variation_id,      // Erforderlich
    $from_date,         // Erforderlich (Format Y-m-d)
    $to_date,           // Erforderlich (Format Y-m-d)
    $suppress_response_code = 'false', // Optional
    $sandboxauth = 'true'              // Optional
) {
    // Basis-URL der API
    GLOBAL $headUrl;
    $baseUrl = $headUrl."products/timeslots/dates";

    // Parameter in ein Array einfügen
    $params = [
        'variation_id' => $variation_id,
        'from_date' => $from_date,
        'to_date' => $to_date,
        'suppress_response_code' => $suppress_response_code,
        'sandboxauth' => $sandboxauth
    ];

    // URL mit Parametern erweitern
    $url = $baseUrl . '?' . http_build_query($params);

    // API-Anfrage ausführen und das Ergebnis zurückgeben
    return executeCurlRequest($url);
}

function GETProductsByTimeslots($suppress_response_code = NULL, $debug = NULL, $sandboxauth = NULL, $store_locale = NULL, $limit = NULL, $offset = NULL, $category_id = NULL, $is_appointment_required = NULL, $location_id = NULL, $geo_coordinates = NULL, $radius = NULL, $product_supplier_ids = NULL, $attribute_included = NULL, $date_range = NULL, $currency = NULL) {
    // Basis-URL der API
    GLOBAL $headUrl;
    $baseUrl = $headUrl."products/bytimeslots";

    // Parameter in ein Array einfügen
    $params = [
        'suppress_response_code' => $suppress_response_code,
        'debug' => $debug,
        'sandboxauth' => $sandboxauth,
        'store_locale' => $store_locale,
        'limit' => $limit,
        'offset' => $offset,
        'category_id' => $category_id,
        'is_appointment_required' => $is_appointment_required,
        'location_id' => $location_id,
        'geo_coordinates' => $geo_coordinates,
        'radius' => $radius,
        'product_supplier_ids' => $product_supplier_ids,
        'attribute_included' => $attribute_included,
        'date_range' => $date_range,
        'currency' => $currency
    ];

    // Entferne NULL-Werte aus den Parametern
    $params = array_filter($params, function($value) {
        return !is_null($value);
    });

    // URL mit Parametern erweitern
    $url = $baseUrl . '?' . http_build_query($params);
    echo '<pre>';
    echo '$url';
    echo '<pre>';
    var_dump($url);
    echo '</pre>';

    // API-Anfrage ausführen und das Ergebnis zurückgeben
    return executeCurlRequest($url);
}


//????
function GETProductsByDateRange(
    $date_range, // Muss vor den optionalen Parametern stehen
    $suppress_response_code = 'false',
    $debug = 'false',
    $sandboxauth = 'true',
    $store_locale = NULL,
    $limit = 10,
    $offset = 0,
    $category_id = NULL,
    $is_appointment_required = NULL,
    $location_id = NULL,
    $geo_coordinates = NULL,
    $radius = NULL,
    $product_supplier_ids = NULL,
    $attribute_included = NULL
) {
    // Basis-URL der API
    GLOBAL $headUrl;
    $baseUrl = $headUrl."products/bydaterange";

    // Parameter in ein Array einfügen
    $params = [
        'suppress_response_code' => $suppress_response_code,
        'debug' => $debug,
        'sandboxauth' => $sandboxauth,
        'store_locale' => $store_locale,
        'limit' => $limit,
        'offset' => $offset,
        'category_id' => $category_id,
        'is_appointment_required' => $is_appointment_required,
        'location_id' => $location_id,
        'geo_coordinates' => $geo_coordinates,
        'radius' => $radius,
        'product_supplier_ids' => $product_supplier_ids,
        'attribute_included' => $attribute_included,
        'date_range' => $date_range // Pflichtparameter
    ];

    // Entferne NULL-Werte aus den Parametern
    $params = array_filter($params, function ($value) {
        return !is_null($value);
    });

    // URL mit Parametern erweitern
    $url = $baseUrl . '?' . http_build_query($params);

    // API-Anfrage ausführen
    $response = executeCurlRequest($url);

    // Antwort zurückgeben
    return $response;
}



/* ----------------------------------------------------------------- */
/* ----------------------------------------------------------------- */
/*                            POST Functions                         */
/* ----------------------------------------------------------------- */
/* ----------------------------------------------------------------- */
/*                           UPDATE Functions                        */
/* ----------------------------------------------------------------- */
/* ----------------------------------------------------------------- */
/*                            BASE Functions                         */
/* ----------------------------------------------------------------- */
// Funktion zum Extrahieren des Query-Strings aus einer URL
function getQueryString($url) {
    $query = parse_url($url, PHP_URL_QUERY);
    return $query ? $query : '';
}

// Funktion zur Erstellung von Auth-Headern
function getAuthHeader($url) {

    global $PUBLIC_KEY, $SECRET_KEY;
    $queryString = getQueryString($url);
    $timestamp = time() * 1000;
    $requestData = $timestamp . $PUBLIC_KEY . $queryString;
    $hmacDigest = hash_hmac('sha256', $requestData, $SECRET_KEY);
    return [
        'timestamp' => $timestamp,
        'hmac' => $hmacDigest
    ];
}

function executeCurlRequest($url) {
    global $PUBLIC_KEY;
    $resultData = [];
    $currUrl = $url;
    $offset = 0;
    while (true) {
        $authData = getAuthHeader($currUrl);
        // echo "URL: $currUrl\n"; // DEBUG 
        $headers = [
            'X-API-HASH: ' . $authData['hmac'],
            'X-API-TIME: ' . $authData['timestamp'],
            'X-API-ID: ' . $PUBLIC_KEY
        ];
        $ch = curl_init($currUrl);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        $response = curl_exec($ch);
        
        if ($response === false) {
            // cURL-Fehler
            return [
                'error' => 'cURL error: ' . curl_error($ch)
            ];
        }

        $result = json_decode($response);
        // echo '<pre>';
        // echo '$result';
        // echo '<pre>';
        // var_dump($result);
        // echo '</pre>';

        // Überprüfen, ob die Antwort ein gültiges Objekt ist
        if (!isset($result) || !is_object($result)) {
            return [
                'error' => 'Invalid JSON response',
                'response' => $response
            ];
        }

        // Überprüfen, ob 'data' existiert und entweder ein Array oder Objekt ist
        if (!isset($result->data) || (!is_array($result->data) && !is_object($result->data))) {
            return [
                'error' => 'Invalid response structure: Missing or invalid "data"',
                'response' => $response
            ];
        }

        // Konvertiere 'data' in ein Array, falls es ein Objekt ist
        $data = is_object($result->data) ? get_object_vars($result->data) : $result->data;

        // Daten zusammenfügen
        $resultData = array_merge($resultData, $data);

        // Pagination überprüfen (falls vorhanden)
        if (!isset($result->page) || !isset($result->page->current) || !isset($result->page->last)) {
            break;
        }

        if ($result->page->current >= $result->page->last) {
            break;
        }

        $offset += 10;
        $currUrl = "$url&offset=$offset";
    }

    return $resultData;
}



// gut aber problem mit GETListOfBookingsRegiondo
// function executeCurlRequest($url) {
//     global $PUBLIC_KEY;
//     $resultData = [];
//     $currUrl = $url;
//     $offset = 0;
//     while(true){
//         $authData = getAuthHeader($currUrl);
//         $headers = [
//             'X-API-HASH: ' . $authData['hmac'],
//             'X-API-TIME: ' . $authData['timestamp'],
//             'X-API-ID: ' . $PUBLIC_KEY
//         ];
//         $ch = curl_init($currUrl);
//         curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
//         curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
//         $response = curl_exec($ch);
//         $result = json_decode($response);

//         // Debugging
//         if (!isset($result->data) || !is_array($result->data)) {
//             return $result;
//         }
//         array_push($resultData, ...$result->data);

//         if (!isset($result->page) || $result->page->current >= $result->page->last) {
//             return $resultData;
//         }
        
//         $offset += 10;
//         $currUrl = "$url&offset=$offset";
//     }
// }

// Funktion zum Ausführen der CURL-Anfrage
// function executeCurlRequest($url, $key = NULL) {
//     list($timestamp, $hmac) = getAuthHeader($url);

//     $pageArr = [];

//     // CURL initialisieren
//     $ch = curl_init();

//     curl_setopt($ch, CURLOPT_URL, $url);
//     curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
//     curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
//     curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
//     curl_setopt($ch, CURLOPT_HTTPHEADER, [
//         "X-API-HASH: $hmac",
//         "X-API-TIME: $timestamp",
//         "X-API-ID: " . PUBLIC_KEY
//     ]);

//     // // CURL-Anfrage ausführen
//     // $response = curl_exec($ch);

//     $response = curl_exec($ch);
//     curl_close($ch);
//     $res = JSON_decode($response);

//     if(!isset($res->next_page) && empty($pageArr)) return isset($key) ? $res->$key : $res;
//     $pageArr = array_merge($pageArr, $res->$key);
//     $url = $res->next_page;

//     // CURL-Fehlerbehandlung
//     if (curl_errno($ch)) {
//         echo 'Curl error: ' . curl_error($ch);
//     }

//     curl_close($ch);

//     return $response;
// }
// function executeCurlRequest($url, $key = NULL) {
//     $url .= "&offset=10";
//     global $PUBLIC_KEY;
//     $pageArr = []; // Array zum Sammeln der Ergebnisse
//     $baseUrl = $url; // Speichert die ursprüngliche URL für Pagination

//     while ($url !== null) {
//         // Debug-Ausgabe der aktuellen URL
//         // echo "Requesting URL: $url\n";

//         // Authentifizierungs-Header erstellen
//         $authData = getAuthHeader($url);
//         $headers = [
//             'X-API-HASH: ' . $authData['hmac'],
//             'X-API-TIME: ' . $authData['timestamp'],
//             'X-API-ID: ' . $PUBLIC_KEY
//         ];

//         // CURL initialisieren
//         $ch = curl_init();
//         curl_setopt($ch, CURLOPT_URL, $url);
//         curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
//         curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

//         // CURL-Anfrage ausführen
//         $response = curl_exec($ch);

//         // CURL-Fehlerbehandlung
//         if ($response === false) {
//             throw new Exception('Curl Error: ' . curl_error($ch));
//         }
//         curl_close($ch);
//         $result = json_decode($response);

//         if (json_last_error() !== JSON_ERROR_NONE) {
//             throw new Exception('JSON Decode Error: ' . json_last_error_msg());
//         }

//         // Daten sammeln
//         if (isset($result->data)) {
//             $dataToAdd = isset($key) ? ($result->$key ?? []) : $result->data;
//             if (!is_array($dataToAdd)) {
//                 $dataToAdd = [$dataToAdd];
//             }
//             $pageArr = array_merge($pageArr, $dataToAdd);
//             // Überprüfen, ob weitere Seiten existieren

//         //     if (isset($result->page->next) && $result->page->next > $result->page->current) {
//         //         $params = [];
//         //         parse_str(parse_url($baseUrl, PHP_URL_QUERY), $params);
//         //         $params['page'] = $result->page->next; // Hier sicherstellen, dass `page` korrekt gesetzt ist
//         //         $url = strtok($baseUrl, '?') . '?' . http_build_query($params);
//         //     } else {
//         //         $url = null;
//         //     }
//         // } else {
//         //     // Rückgabe der vollständigen Antwort, falls keine Pagination vorhanden ist
//             return $result;
//         }
//     }

//     // Gesamte gesammelte Daten zurückgeben
//     return $pageArr;
// }

// function executeCurlRequest($url) {
//     global $PUBLIC_KEY;
//     $resultData = [];
//     $currUrl = $url;
//     $offset = 0;
//     while(true){
//         $authData = getAuthHeader($currUrl);
//         $headers = [
//             'X-API-HASH: ' . $authData['hmac'],
//             'X-API-TIME: ' . $authData['timestamp'],
//             'X-API-ID: ' . $PUBLIC_KEY
//         ];
//         $ch = curl_init($currUrl);
//         curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
//         curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
//         $response = curl_exec($ch);
//         $result = json_decode($response);
//         echo '<pre>';
//         echo '$result';
//         echo '<pre>';
//         var_dump($result);
//         echo '</pre>';
//         curl_close($ch);
//         if(!isset($result->data)) return $result;
//         array_push($resultData, ...$result->data);
//         if(!isset($result->page) || $result->page->current >= $result->page->last) return $resultData;
//         $offset+=10;
//         $currUrl = "$url&offset=$offset";
//     }
// }

