<?php

include_once __DIR__ . "/ContentManager.php"; // 04.06.2025  letze version in time_blockv4 gespeichert.

// Mock functions (unchanged)
// function mockCreateNewShiftPapershift($data) {
//     return [
//         "id" => "GAPSHIFT_" . uniqid()
//     ];
// }

function mockCreateNewShiftPapershift($data) {
    // Generate a random integer ID for testing
    return [
        "id" => rand(100000, 999999)  // Returns a 6-digit integer
    ];
}

function mockDeleteShiftPapershift($data) {
    return [
        'http_code' => 200
    ];
}

class zeit_block {
    // Unchanged, included for reference
    public $startZeit;
    public $endZeit;
    public $status;
    public $user_id;
    public $username;
    public $shift_id;
    public $main_shift_id;
    public $main_shift_virtuell_id;
    public $virtual_workingarea_id;
    public $virtual_workingarea_name;
    public $vorherigerBlock;
    public $naechsterBlock;

    public function __construct(
        $startZeit,
        $endZeit,
        $status = "frei",
        $user_id = null,
        $username = null,
        $shift_id = null,
        $main_shift_id = null,
        $main_shift_virtuell_id = null,
        $virtual_workingarea_id = null,
        $virtual_workingarea_name = null
    ) {
        $this->startZeit = $startZeit;
        $this->endZeit = $endZeit;
        $this->status = $status;
        $this->user_id = $user_id;
        $this->username = $username;
        $this->shift_id = $shift_id;
        $this->main_shift_id = $main_shift_id;
        $this->main_shift_virtuell_id = $main_shift_virtuell_id;
        $this->virtual_workingarea_id = $virtual_workingarea_id;
        $this->virtual_workingarea_name = $virtual_workingarea_name;
        $this->vorherigerBlock = null;
        $this->naechsterBlock = null;
    }

    public function getDauerInStunden() {
        return (strtotime($this->endZeit) - strtotime($this->startZeit)) / 3600;
    }

    public function toArray() {
        return [
            'startZeit' => $this->startZeit,
            'endZeit' => $this->endZeit,
            'status' => $this->status,
            'user_id' => $this->user_id,
            'username' => $this->username,
            'shift_id' => $this->shift_id,
            'main_shift_id' => $this->main_shift_id,
            'main_shift_virtuell_id' => $this->main_shift_virtuell_id,
            'virtual_workingarea_id' => $this->virtual_workingarea_id,
            'virtual_workingarea_name' => $this->virtual_workingarea_name,
            'dauer_in_stunden' => $this->getDauerInStunden()
        ];
    }
}

class verkettete_Liste {
    private $kopf;

    public function __construct(
        $startZeit,
        $endZeit,
        $user_id,
        $username,
        $main_shift_id,
        $virtual_workingarea_id,
        $virtual_workingarea_name
    ) {
        $this->kopf = new zeit_block(
            $startZeit,
            $endZeit,
            "frei",
            $user_id,
            $username,
            null,
            $main_shift_id,
            null,
            $virtual_workingarea_id,
            $virtual_workingarea_name
        );
    }

    public function fuegeBlockHinzu(
        $startZeit,
        $endZeit,
        $user_id,
        $username,
        $shift_id,
        $main_shift_id,
        $virtual_workingarea_id,
        $virtual_workingarea_name,
        $api_key,
        $location_id,
        $wk_id,
        ContentManager $contentManager
    ) {
        // Unchanged, included for completeness
        $aktuellerBlock = $this->kopf;
        $vorherigerBlock = null;

        while ($aktuellerBlock !== null) {
            if (
                $aktuellerBlock->status === "belegt" &&
                $aktuellerBlock->startZeit < $endZeit &&
                $aktuellerBlock->endZeit > $startZeit
            ) {
                return [
                    'success' => false,
                    'message' => "Fehler: Der Block von $startZeit bis $endZeit überschneidet sich mit einem bestehenden belegten Block für $username."
                ];
            }
            $vorherigerBlock = $aktuellerBlock;
            $aktuellerBlock = $aktuellerBlock->naechsterBlock;
        }
        // Schritt 2: Prüfen auf exakten Zeitpunkt für Zero-Duration Block
        $aktuellerBlock = $this->kopf;
        while ($aktuellerBlock !== null) {
            if (
                strtotime($startZeit) === strtotime($endZeit) &&
                $aktuellerBlock->startZeit === $startZeit &&
                $aktuellerBlock->endZeit === $endZeit
            ) {
                return [
                    'success' => false,
                    'message' => "Fehler: Ein Zero-Duration Block von $startZeit bis $endZeit existiert bereits für $username."
                ];
            }
            $aktuellerBlock = $aktuellerBlock->naechsterBlock;
        }

        // Schritt 3: Block einfügen oder freie/gap Blöcke anpassen
        $aktuellerBlock = $this->kopf;
        $vorherigerBlock = null;

        while ($aktuellerBlock !== null) {
            if (
                ($aktuellerBlock->status === "frei" || $aktuellerBlock->status === "gap") &&
                $aktuellerBlock->startZeit <= $startZeit &&
                $aktuellerBlock->endZeit >= $endZeit
            ) {
                // Lösche den gap Shift, wenn vorhanden
                if ($aktuellerBlock->status === "gap" && $aktuellerBlock->main_shift_virtuell_id) {
                    $data = [
                        "api_token" => $api_key,
                        "shift" => [
                            "id" => $aktuellerBlock->main_shift_virtuell_id
                        ]
                    ];
                    // $deleteResponse = mockDeleteShiftPapershift($data); // nur für test
                    $deleteResponse = deleteShiftPapershift($data);

                    if ($deleteResponse['http_code'] !== 200) {
                        return [
                            'success' => false,
                            'message' => "Fehler: Gap Shift {$aktuellerBlock->main_shift_virtuell_id} konnte nicht gelöscht werden."
                        ];
                    }
                    $contentManager->deleteTimeBlock($aktuellerBlock->startZeit, $aktuellerBlock->main_shift_virtuell_id, $user_id);
                    echo "<pre>Schicht {$aktuellerBlock->main_shift_virtuell_id} erfolgreich gelöscht.</pre>";
                }
                // Handle zero-duration block
                if (strtotime($startZeit) === strtotime($endZeit)) {
                    echo '<pre>';
                    echo '$startZeit';
                    echo '<pre>';
                    var_dump($startZeit);
                    echo '</pre>';
                    echo '<pre>';
                    echo '$endZeit';
                    echo '<pre>';
                    var_dump($endZeit);
                    echo '</pre>';
                    $aktuellerBlock->status = "frei";
                    $aktuellerBlock->user_id = $user_id;
                    $aktuellerBlock->username = $username;
                    $aktuellerBlock->shift_id = null;
                    $aktuellerBlock->main_shift_id = $main_shift_id;
                    $aktuellerBlock->main_shift_virtuell_id = null;
                    $aktuellerBlock->virtual_workingarea_id = $virtual_workingarea_id;
                    $aktuellerBlock->virtual_workingarea_name = $virtual_workingarea_name;
                    $aktuellerBlock->startZeit = $startZeit;
                    $aktuellerBlock->endZeit = $endZeit;

                    return [
                        'success' => true,
                        'message' => "Zero-duration Block von $startZeit bis $endZeit als frei hinzugefügt für $username."
                    ];
                }
                // Erstelle neue freie Blöcke vor und nach dem neuen Block
                if ($aktuellerBlock->startZeit < $startZeit) {
                    $neuerFreiBlock = new zeit_block(
                        $aktuellerBlock->startZeit,
                        date("Y-m-d H:i", strtotime($startZeit) - 60),
                        "frei",
                        $user_id,
                        $username,
                        null,
                        $main_shift_id,
                        null,
                        $virtual_workingarea_id,
                        $virtual_workingarea_name
                    );
                    $neuerFreiBlock->naechsterBlock = $aktuellerBlock;
                    if ($vorherigerBlock) {
                        $vorherigerBlock->naechsterBlock = $neuerFreiBlock;
                    } else {
                        $this->kopf = $neuerFreiBlock;
                    }
                    $aktuellerBlock->startZeit = $startZeit;
                }

                if ($aktuellerBlock->endZeit > $endZeit) {
                    $neuerFreiBlock = new zeit_block(
                        date("Y-m-d H:i", strtotime($endZeit) + 60),
                        $aktuellerBlock->endZeit,
                        "frei",
                        $user_id,
                        $username,
                        null,
                        $main_shift_id,
                        null,
                        $virtual_workingarea_id,
                        $virtual_workingarea_name
                    );
                    $neuerFreiBlock->naechsterBlock = $aktuellerBlock->naechsterBlock;
                    $aktuellerBlock->naechsterBlock = $neuerFreiBlock;
                    $aktuellerBlock->endZeit = $endZeit;
                }

                $aktuellerBlock->status = "belegt";
                $aktuellerBlock->user_id = $user_id;
                $aktuellerBlock->username = $username;
                $aktuellerBlock->shift_id = $shift_id;
                $aktuellerBlock->main_shift_id = $main_shift_id;
                $aktuellerBlock->main_shift_virtuell_id = null;
                $aktuellerBlock->virtual_workingarea_id = $virtual_workingarea_id;
                $aktuellerBlock->virtual_workingarea_name = $virtual_workingarea_name;

                return [
                    'success' => true,
                    'message' => "Block erfolgreich hinzugefügt von $startZeit bis $endZeit für $username."
                ];
            }
            $vorherigerBlock = $aktuellerBlock;
            $aktuellerBlock = $aktuellerBlock->naechsterBlock;
        }

        return [
            'success' => false,
            'message' => "Fehler: Der Block von $startZeit bis $endZeit kann nicht hinzugefügt werden für $username."
        ];
    }

    public function fuegeGapBlockHinzu(
        $startZeit,
        $endZeit,
        $user_id,
        $username,
        $main_shift_id,
        $virtual_workingarea_id,
        $virtual_workingarea_name,
        $shift_gap_id,  // <- Bestehende Shift-ID wird übergeben
        $haupt_start_user_time,
        $haupt_end_user_time,
        ContentManager $contentManager
    ) {
        // Schritt 1: Prüfen auf ungültige Zeiten
        if (strtotime($startZeit) >= strtotime($endZeit)) {
            return [
                'success' => false,
                'message' => "Fehler: Startzeit '$startZeit' darf nicht nach oder gleich Endzeit '$endZeit' sein für einen Gap-Block."
            ];
        }
    
        // Schritt 2: Prüfen auf Überschneidungen
        $aktuellerBlock = $this->kopf;
        while ($aktuellerBlock !== null) {
            if (
                $aktuellerBlock->status === "belegt" &&
                $aktuellerBlock->startZeit < $endZeit &&
                $aktuellerBlock->endZeit > $startZeit
            ) {
                return [
                    'success' => false,
                    'message' => "Fehler: Der Gap-Block von $startZeit bis $endZeit überschneidet sich mit einem bestehenden belegten Block für $username."
                ];
            }
            $aktuellerBlock = $aktuellerBlock->naechsterBlock;
        }
    
        // Schritt 3: Gap-Block einfügen
        $aktuellerBlock = $this->kopf;
        $vorherigerBlock = null;
    
        while ($aktuellerBlock !== null) {
            if (
                $aktuellerBlock->status === "frei" &&
                $aktuellerBlock->startZeit <= $startZeit &&
                $aktuellerBlock->endZeit >= $endZeit
            ) {
                // Erstelle neuen Gap-Block
                $neuerGapBlock = new zeit_block(
                    $startZeit,
                    $endZeit,
                    "gap",
                    $user_id,
                    $username,
                    null,               // Kein normales shift_id
                    $main_shift_id,
                    $shift_gap_id,           // Hier speichern wir die übergebene virtuelle Shift-ID (gap)
                    $virtual_workingarea_id,
                    $virtual_workingarea_name
                );
    
                // // ContentManager-Eintrag machen
                // $contentManager->createTimeBlock(
                //     $user_id,
                //     $username,
                //     date('Y-m-d', strtotime($startZeit)),
                //     $startZeit,
                //     $endZeit,
                //     $shift_gap_id,
                //     null,                  // Keine "shift_id" normale, sondern virtuell
                //     $main_shift_id,
                //     $haupt_start_user_time,
                //     $haupt_end_user_time,
                //     $virtual_workingarea_id,
                //     null,
                //     0,
                //     "gap"
                // );
    
                // Neue Verkettung
                if ($aktuellerBlock->startZeit < $startZeit) {
                    $neuerFreiBlock = new zeit_block(
                        $aktuellerBlock->startZeit,
                        date("Y-m-d H:i", strtotime($startZeit) - 60),
                        "frei",
                        $user_id,
                        $username,
                        null,
                        $main_shift_id,
                        null,
                        $virtual_workingarea_id,
                        $virtual_workingarea_name
                    );
                    $neuerFreiBlock->naechsterBlock = $neuerGapBlock;
                    if ($vorherigerBlock) {
                        $vorherigerBlock->naechsterBlock = $neuerFreiBlock;
                    } else {
                        $this->kopf = $neuerFreiBlock;
                    }
                } else {
                    if ($vorherigerBlock) {
                        $vorherigerBlock->naechsterBlock = $neuerGapBlock;
                    } else {
                        $this->kopf = $neuerGapBlock;
                    }
                }
    
                if ($aktuellerBlock->endZeit > $endZeit) {
                    $neuerFreiBlock = new zeit_block(
                        date("Y-m-d H:i", strtotime($endZeit) + 60),
                        $aktuellerBlock->endZeit,
                        "frei",
                        $user_id,
                        $username,
                        null,
                        $main_shift_id,
                        null,
                        $virtual_workingarea_id,
                        $virtual_workingarea_name
                    );
                    $neuerGapBlock->naechsterBlock = $neuerFreiBlock;
                    $neuerFreiBlock->naechsterBlock = $aktuellerBlock->naechsterBlock;
                } else {
                    $neuerGapBlock->naechsterBlock = $aktuellerBlock->naechsterBlock;
                }
    
                return [
                    'success' => true,
                    'message' => "Gap-Block erfolgreich hinzugefügt von $startZeit bis $endZeit für $username mit existierender Shift-ID $shift_gap_id."
                ];
            }
    
            $vorherigerBlock = $aktuellerBlock;
            $aktuellerBlock = $aktuellerBlock->naechsterBlock;
        }
    
        return [
            'success' => false,
            'message' => "Fehler: Der Gap-Block von $startZeit bis $endZeit kann nicht für $username eingefügt werden."
        ];
    }    


    public function existiertPauseInUmgebung($startZeit, $endZeit, $toleranzInMinuten) {
        $startTimestamp = strtotime($startZeit);
        $endTimestamp = strtotime($endZeit);
        $toleranzInSekunden = $toleranzInMinuten * 60;

        $aktuellerBlock = $this->kopf;

        while ($aktuellerBlock !== null) {
            if ($aktuellerBlock->status === "pause") {
                $pauseStart = strtotime($aktuellerBlock->startZeit);
                $pauseEnd = strtotime($aktuellerBlock->endZeit);

                $zuNaheVorher = abs($pauseEnd - $startTimestamp) <= $toleranzInSekunden && $pauseEnd <= $startTimestamp;
                $zuNaheNachher = abs($pauseStart - $endTimestamp) <= $toleranzInSekunden && $pauseStart >= $endTimestamp;

                if ($zuNaheVorher || $zuNaheNachher) {
                    return true;
                }
            }
            $aktuellerBlock = $aktuellerBlock->naechsterBlock;
        }

        return false;
    }

    public function fuegePauseBlockHinzu2(
        $startZeit,
        $endZeit,
        $user_id,
        $username,
        $main_shift_id,
        $virtual_workingarea_id,
        $virtual_workingarea_name,
        $shift_id,  // Bestehende Shift-ID wird übergeben
        $haupt_start_user_time,
        $haupt_end_user_time,
        $apikeyPapershift,
        $location_id,
        $tag_pause_id,
        $pause,
        ContentManager $contentManager
    ) {
        // Schritt 1: Konvertiere Start/Endzeit zu DateTime, falls sie Strings sind
        try {
            if (!($startZeit instanceof DateTime)) {
                $startZeit = new DateTime($startZeit);
            }
            if (!($endZeit instanceof DateTime)) {
                $endZeit = new DateTime($endZeit);
            }
        } catch (Exception $e) {
            return [
                'success' => false,
                'message' => "Fehler: Ungültiges Zeitformat für Startzeit oder Endzeit: " . $e->getMessage()
            ];
        }
        
        // Konvertiere DateTime-Objekte in Strings für zeit_block
        $startZeitString = $startZeit->format('Y-m-d H:i');
        $endZeitString = $endZeit->format('Y-m-d H:i');


        // if ($this->existiertPauseInUmgebung($startZeitString, $endZeitString, $pause)) {
        //     return [ 
        //         'success' => false,
        //         'message' => "Fehler: Es existiert bereits eine Pause innerhalb von 15 Minuten vor oder nach der geplanten Pausezeit."
        //     ];
        // }
    
        // Schritt 2: Prüfen auf ungültige Zeiten
        if (strtotime($startZeitString) >= strtotime($endZeitString)) {
            return [
                'success' => false,
                'message' => "Fehler: Startzeit '$startZeitString' darf nicht nach oder gleich Endzeit '$endZeitString' sein für einen Pause-Block."
            ];
        }
    
        // Schritt 3: Prüfen auf Überschneidungen
        $aktuellerBlock = $this->kopf;
        while ($aktuellerBlock !== null) {
            if (
                $aktuellerBlock->status === "belegt" &&
                $aktuellerBlock->startZeit < $endZeitString &&
                $aktuellerBlock->endZeit > $startZeitString
            ) {
                return [
                    'success' => false,
                    'message' => "Fehler: Der Pause-Block von $startZeitString bis $endZeitString überschneidet sich mit einem bestehenden belegten Block für $username."
                ];
            }
            $aktuellerBlock = $aktuellerBlock->naechsterBlock;
        }
    
        // Schritt 4: Shift-Daten für Papershift API
        $data = [
            "api_token" => $apikeyPapershift,
            "shift" => [
                "location_id" => $location_id,
                "working_area_id" => $virtual_workingarea_id,
                "starts_at" => $startZeit->format(DATE_ATOM),
                "ends_at" => $endZeit->format(DATE_ATOM),
                "number_of_employees" => 1,
                "note" => "Diese Schicht wurde automatisch als Pause erstellt. Bitte nicht löschen oder bearbeiten.",
                "tags" => $tag_pause_id
            ]
        ];
    
        // API-Aufruf
        $apiResult = createNewShiftPapershift($data);
        $decodedResponse = json_decode($apiResult, true);
        echo '<pre>';
        echo '$decodedResponse';
        echo '<pre>';
        var_dump($decodedResponse);
        echo '</pre>';
    
        // Fehlerbehandlung für API-Aufruf
        if ($apiResult === false || !is_array($decodedResponse) || !isset($decodedResponse['id'])) {
            return [
                'success' => false,
                'message' => "Fehler: Pause konnte nicht in Papershift erstellt werden. API-Antwort ungültig oder fehlende Shift-ID."
            ];
        }
    
        // Schritt 5: Pause-Block einfügen
        $aktuellerBlock = $this->kopf;
        $vorherigerBlock = null;
    
        while ($aktuellerBlock !== null) {
            if (
                // $aktuellerBlock->status === "frei" &&
                ($aktuellerBlock->status === "frei" || $aktuellerBlock->status === "gap") &&
                $aktuellerBlock->startZeit <= $startZeitString &&
                $aktuellerBlock->endZeit >= $endZeitString
            ) {
                //  Gap löschen
                if ($aktuellerBlock->status === "gap" && $aktuellerBlock->main_shift_virtuell_id) {
                    $data = [
                        "api_token" => $apikeyPapershift,
                        "shift" => [
                            "id" => $aktuellerBlock->main_shift_virtuell_id
                        ]
                    ];
                    $deleteResponse = deleteShiftPapershift($data);
                    if ($deleteResponse['http_code'] !== 200) {
                        return [
                            'success' => false,
                            'message' => "Fehler: Gap Shift {$aktuellerBlock->main_shift_virtuell_id} konnte nicht gelöscht werden."
                        ];
                    }

                    $contentManager->deleteTimeBlock($aktuellerBlock->startZeit, $aktuellerBlock->main_shift_virtuell_id, $user_id);
                    echo "<pre>Gap-Shift {$aktuellerBlock->main_shift_virtuell_id} erfolgreich gelöscht.</pre>";
                }
                // Erstelle neuen Pause-Block mit der Shift-ID aus der API
                $neuerPauseBlock = new zeit_block(
                    $startZeitString,
                    $endZeitString,
                    "pause",
                    $user_id,
                    $username,
                    null,  // Kein normales shift_id
                    $main_shift_id,
                    $decodedResponse['id'],  // Shift-ID der neu erstellten Pause
                    $virtual_workingarea_id,
                    $virtual_workingarea_name
                );
    
                // Neue Verkettung
                if ($aktuellerBlock->startZeit < $startZeitString) {
                    $neuerFreiBlock = new zeit_block(
                        $aktuellerBlock->startZeit,
                        date("Y-m-d H:i", strtotime($startZeitString) - 60),
                        "frei",
                        $user_id,
                        $username,
                        null,
                        $main_shift_id,
                        null,
                        $virtual_workingarea_id,
                        $virtual_workingarea_name
                    );
                    $neuerFreiBlock->naechsterBlock = $neuerPauseBlock;
                    if ($vorherigerBlock) {
                        $vorherigerBlock->naechsterBlock = $neuerFreiBlock;
                    } else {
                        $this->kopf = $neuerFreiBlock;
                    }
                } else {
                    if ($vorherigerBlock) {
                        $vorherigerBlock->naechsterBlock = $neuerPauseBlock;
                    } else {
                        $this->kopf = $neuerPauseBlock;
                    }
                }
    
                if ($aktuellerBlock->endZeit > $endZeitString) {
                    $neuerFreiBlock = new zeit_block(
                        date("Y-m-d H:i", strtotime($endZeitString) + 60),
                        $aktuellerBlock->endZeit,
                        "frei",
                        $user_id,
                        $username,
                        null,
                        $main_shift_id,
                        null,
                        $virtual_workingarea_id,
                        $virtual_workingarea_name
                    );
                    $neuerPauseBlock->naechsterBlock = $neuerFreiBlock;
                    $neuerFreiBlock->naechsterBlock = $aktuellerBlock->naechsterBlock;
                } else {
                    $neuerPauseBlock->naechsterBlock = $aktuellerBlock->naechsterBlock;
                }
    
                // // ContentManager-Eintrag für die Pause
                // $contentManager->createTimeBlock(
                //     $user_id,
                //     $username,
                //     date('Y-m-d', strtotime($startZeitString)),
                //     $startZeitString,
                //     $endZeitString,
                //     $decodedResponse['id'],  // Shift-ID der Pause
                //     null,
                //     $main_shift_id,
                //     $haupt_start_user_time,
                //     $haupt_end_user_time,
                //     $virtual_workingarea_id,
                //     null,
                //     0,
                //     "pause"
                // );
    
                return [
                    'success' => true,
                    'message' => "Pause-Block erfolgreich hinzugefügt von $startZeitString bis $endZeitString für $username mit Shift-ID " . $decodedResponse['id'] . ".",
                    'id' => $decodedResponse['id']
                ];
            }
    
            $vorherigerBlock = $aktuellerBlock;
            $aktuellerBlock = $aktuellerBlock->naechsterBlock;
        }
    
        return [
            'success' => false,
            'message' => "Fehler: Der Pause-Block von $startZeitString bis $endZeitString kann nicht für $username eingefügt werden."
        ];
    }

    public function fuegePauseBlockHinzu(
        $startZeit,
        $endZeit,
        $user_id,
        $username,
        $main_shift_id,
        $virtual_workingarea_id,
        $virtual_workingarea_name,
        $shift_id,
        $haupt_start_user_time,
        $haupt_end_user_time,
        $apikeyPapershift,
        $location_id,
        $tag_pause_id,
        $pause,
        ContentManager $contentManager,
        $debug = true
    ) {
        if ($debug) echo "[DEBUG] Funktion wurde aufgerufen\n";
    
        try {
            if (!($startZeit instanceof DateTime)) {
                if ($debug) echo "[DEBUG] Konvertiere Startzeit: $startZeit\n";
                $startZeit = new DateTime($startZeit);
            }
            if (!($endZeit instanceof DateTime)) {
                if ($debug) echo "[DEBUG] Konvertiere Endzeit: $endZeit\n";
                $endZeit = new DateTime($endZeit);
            }
        } catch (Exception $e) {
            if ($debug) echo "[DEBUG] Fehler bei DateTime-Konvertierung: " . $e->getMessage() . "\n";
            return [
                'success' => false,
                'message' => "Fehler: Ungültiges Zeitformat für Startzeit oder Endzeit: " . $e->getMessage()
            ];
        }
    
        $startZeitString = $startZeit->format('Y-m-d H:i');
        $endZeitString = $endZeit->format('Y-m-d H:i');

        // if ($this->existiertPauseInUmgebung($startZeitString, $endZeitString, $pause)) {
        //     return [ 
        //         'success' => false,
        //         'message' => "Fehler: Es existiert bereits eine Pause innerhalb von 15 Minuten vor oder nach der geplanten Pausezeit."
        //     ];
        // }
    
        if ($debug) echo "[DEBUG] Startzeit: $startZeitString, Endzeit: $endZeitString\n";
    
        if (strtotime($startZeitString) >= strtotime($endZeitString)) {
            if ($debug) echo "[DEBUG] Ungültige Zeitspanne: Start >= Ende\n";
            return [
                'success' => false,
                'message' => "Fehler: Startzeit '$startZeitString' darf nicht nach oder gleich Endzeit '$endZeitString' sein für einen Pause-Block."
            ];
        }
    
        $aktuellerBlock = $this->kopf;
        while ($aktuellerBlock !== null) {
            if ($debug) {
                echo "[DEBUG] Prüfe belegten Block: {$aktuellerBlock->startZeit} bis {$aktuellerBlock->endZeit}, Status: {$aktuellerBlock->status}\n";
            }
    
            if (
                $aktuellerBlock->status === "belegt" &&
                $aktuellerBlock->startZeit < $endZeitString &&
                $aktuellerBlock->endZeit > $startZeitString
            ) {
                if ($debug) echo "[DEBUG] Überschneidung mit belegtem Block erkannt\n";
                return [
                    'success' => false,
                    'message' => "Fehler: Der Pause-Block von $startZeitString bis $endZeitString überschneidet sich mit einem bestehenden belegten Block für $username."
                ];
            }
            $aktuellerBlock = $aktuellerBlock->naechsterBlock;
        }
    
        // Einfügen des Pause-Blocks
        $aktuellerBlock = $this->kopf;
        $vorherigerBlock = null;
    
        while ($aktuellerBlock !== null) {
            if ($debug) {
                echo "[DEBUG] Prüfe freien/gap Block: {$aktuellerBlock->startZeit} bis {$aktuellerBlock->endZeit}, Status: {$aktuellerBlock->status}\n";
            }
    
            if (
                ($aktuellerBlock->status === "frei" || $aktuellerBlock->status === "gap") &&
                $aktuellerBlock->startZeit <= $startZeitString &&
                $aktuellerBlock->endZeit >= $endZeitString
            ) {
                if ($debug) echo "[DEBUG] Geeigneter Slot gefunden\n";
    
                if ($aktuellerBlock->status === "gap" && $aktuellerBlock->main_shift_virtuell_id) {
                    if ($debug) echo "[DEBUG] Lösche GAP-Shift mit ID {$aktuellerBlock->main_shift_virtuell_id}\n";
                    $data = [
                        "api_token" => $apikeyPapershift,
                        "shift" => [
                            "id" => $aktuellerBlock->main_shift_virtuell_id
                        ]
                    ];
                    $deleteResponse = deleteShiftPapershift($data);
                    if ($deleteResponse['http_code'] !== 200) {
                        if ($debug) echo "[DEBUG] Fehler beim Löschen des GAP-Shifts\n";
                        return [
                            'success' => false,
                            'message' => "Fehler: Gap Shift {$aktuellerBlock->main_shift_virtuell_id} konnte nicht gelöscht werden."
                        ];
                    }
    
                    $contentManager->deleteTimeBlock($aktuellerBlock->startZeit, $aktuellerBlock->main_shift_virtuell_id, $user_id);
                    if ($debug) echo "[DEBUG] Gap-Shift erfolgreich gelöscht\n";
                }

                if ($debug) echo "[DEBUG] Sende Daten an API für neue Pause-Shift\n";
                $data = [
                    "api_token" => $apikeyPapershift,
                    "shift" => [
                        "location_id" => $location_id,
                        "working_area_id" => $virtual_workingarea_id,
                        "starts_at" => $startZeit->format(DATE_ATOM),
                        "ends_at" => $endZeit->format(DATE_ATOM),
                        "number_of_employees" => 1,
                        "note" => "Diese Schicht wurde automatisch als Pause erstellt. Bitte nicht löschen oder bearbeiten.",
                        "tags" => $tag_pause_id
                    ]
                ];
            
                $apiResult = createNewShiftPapershift($data);
                $decodedResponse = json_decode($apiResult, true);
            
                if ($debug) {
                    echo "[DEBUG] API Antwort:\n";
                    var_dump($apiResult);
                    echo "[DEBUG] Dekodierte Antwort:\n";
                    var_dump($decodedResponse);
                }
            
                if ($apiResult === false || !is_array($decodedResponse) || !isset($decodedResponse['id'])) {
                    if ($debug) echo "[DEBUG] Fehlerhafte oder leere Antwort von API\n";
                    return [
                        'success' => false,
                        'message' => "Fehler: Pause konnte nicht in Papershift erstellt werden. API-Antwort ungültig oder fehlende Shift-ID."
                    ];
                }
            
                if ($debug) echo "[DEBUG] Neue Pause-Shift-ID: " . $decodedResponse['id'] . "\n";
    
                if ($debug) echo "[DEBUG] Erstelle neuen Pause-Block\n";
                $neuerPauseBlock = new zeit_block(
                    $startZeitString,
                    $endZeitString,
                    "pause",
                    $user_id,
                    $username,
                    null,
                    $main_shift_id,
                    $decodedResponse['id'],
                    $virtual_workingarea_id,
                    $virtual_workingarea_name
                );
    
                if ($aktuellerBlock->startZeit < $startZeitString) {
                    if ($debug) echo "[DEBUG] Erzeuge vorherigen freien Block\n";
                    $neuerFreiBlock = new zeit_block(
                        $aktuellerBlock->startZeit,
                        date("Y-m-d H:i", strtotime($startZeitString) - 60),
                        "frei",
                        $user_id,
                        $username,
                        null,
                        $main_shift_id,
                        null,
                        $virtual_workingarea_id,
                        $virtual_workingarea_name
                    );
                    $neuerFreiBlock->naechsterBlock = $neuerPauseBlock;
                    if ($vorherigerBlock) {
                        $vorherigerBlock->naechsterBlock = $neuerFreiBlock;
                    } else {
                        $this->kopf = $neuerFreiBlock;
                    }
                } else {
                    if ($vorherigerBlock) {
                        $vorherigerBlock->naechsterBlock = $neuerPauseBlock;
                    } else {
                        $this->kopf = $neuerPauseBlock;
                    }
                }
    
                if ($aktuellerBlock->endZeit > $endZeitString) {
                    if ($debug) echo "[DEBUG] Erzeuge nachfolgenden freien Block\n";
                    $neuerFreiBlock = new zeit_block(
                        date("Y-m-d H:i", strtotime($endZeitString) + 60),
                        $aktuellerBlock->endZeit,
                        "frei",
                        $user_id,
                        $username,
                        null,
                        $main_shift_id,
                        null,
                        $virtual_workingarea_id,
                        $virtual_workingarea_name
                    );
                    $neuerPauseBlock->naechsterBlock = $neuerFreiBlock;
                    $neuerFreiBlock->naechsterBlock = $aktuellerBlock->naechsterBlock;
                } else {
                    $neuerPauseBlock->naechsterBlock = $aktuellerBlock->naechsterBlock;
                }
    
                return [
                    'success' => true,
                    'message' => "Pause-Block erfolgreich hinzugefügt von $startZeitString bis $endZeitString für $username mit Shift-ID " . $decodedResponse['id'] . ".",
                    'id' => $decodedResponse['id']
                ];
            }
    
            $vorherigerBlock = $aktuellerBlock;
            $aktuellerBlock = $aktuellerBlock->naechsterBlock;
        }
    
        if ($debug) echo "[DEBUG] Kein passender Slot für Pause gefunden\n";
    
        return [
            'success' => false,
            'message' => "Fehler: Der Pause-Block von $startZeitString bis $endZeitString kann nicht für $username eingefügt werden."
        ];
    }
    

    public function fuegePauseBlockAusDatenbankHinzu(
        $startZeit,
        $endZeit,
        $user_id,
        $username,
        $main_shift_id,
        $virtual_workingarea_id,
        $virtual_workingarea_name,
        $shift_id, // Existing shift ID from the database
        $haupt_start_user_time,
        $haupt_end_user_time,
        ContentManager $contentManager
    ) {
        // Schritt 1: Konvertiere Start/Endzeit zu DateTime, falls sie Strings sind
        try {
            if (!($startZeit instanceof DateTime)) {
                $startZeit = new DateTime($startZeit);
            }
            if (!($endZeit instanceof DateTime)) {
                $endZeit = new DateTime($endZeit);
            }
        } catch (Exception $e) {
            return [
                'success' => false,
                'message' => "Fehler: Ungültiges Zeitformat für Startzeit oder Endzeit: " . $e->getMessage()
            ];
        }
    
        // Konvertiere DateTime-Objekte in Strings für zeit_block
        $startZeitString = $startZeit->format('Y-m-d H:i');
        $endZeitString = $endZeit->format('Y-m-d H:i');
    
        // Schritt 2: Prüfen auf ungültige Zeiten
        if (strtotime($startZeitString) >= strtotime($endZeitString)) {
            return [
                'success' => false,
                'message' => "Fehler: Startzeit '$startZeitString' darf nicht nach oder gleich Endzeit '$endZeitString' sein für einen Pause-Block."
            ];
        }
    
        // Schritt 3: Prüfen auf Überschneidungen
        $aktuellerBlock = $this->kopf;
        while ($aktuellerBlock !== null) {
            if (
                $aktuellerBlock->status === "belegt" &&
                $aktuellerBlock->startZeit < $endZeitString &&
                $aktuellerBlock->endZeit > $startZeitString
            ) {
                return [
                    'success' => false,
                    'message' => "Fehler: Der Pause-Block von $startZeitString bis $endZeitString überschneidet sich mit einem bestehenden belegten Block für $username."
                ];
            }
            $aktuellerBlock = $aktuellerBlock->naechsterBlock;
        }
    
        // Schritt 4: Pause-Block einfügen
        $aktuellerBlock = $this->kopf;
        $vorherigerBlock = null;
    
        while ($aktuellerBlock !== null) {
            if (
                // $aktuellerBlock->status === "frei" &&
                ($aktuellerBlock->status === "frei" || $aktuellerBlock->status === "gap") &&
                $aktuellerBlock->startZeit <= $startZeitString &&
                $aktuellerBlock->endZeit >= $endZeitString
            ) {
                // Erstelle neuen Pause-Block mit der Shift-ID aus der Datenbank
                $neuerPauseBlock = new zeit_block(
                    $startZeitString,
                    $endZeitString,
                    "pause",
                    $user_id,
                    $username,
                    null, // Kein normales shift_id
                    $main_shift_id,
                    $shift_id, // Shift-ID der Pause aus der Datenbank
                    $virtual_workingarea_id,
                    $virtual_workingarea_name
                );
    
                // Neue Verkettung
                if ($aktuellerBlock->startZeit < $startZeitString) {
                    $neuerFreiBlock = new zeit_block(
                        $aktuellerBlock->startZeit,
                        date("Y-m-d H:i", strtotime($startZeitString) - 60),
                        "frei",
                        $user_id,
                        $username,
                        null,
                        $main_shift_id,
                        null,
                        $virtual_workingarea_id,
                        $virtual_workingarea_name
                    );
                    $neuerFreiBlock->naechsterBlock = $neuerPauseBlock;
                    if ($vorherigerBlock) {
                        $vorherigerBlock->naechsterBlock = $neuerFreiBlock;
                    } else {
                        $this->kopf = $neuerFreiBlock;
                    }
                } else {
                    if ($vorherigerBlock) {
                        $vorherigerBlock->naechsterBlock = $neuerPauseBlock;
                    } else {
                        $this->kopf = $neuerPauseBlock;
                    }
                }
    
                if ($aktuellerBlock->endZeit > $endZeitString) {
                    $neuerFreiBlock = new zeit_block(
                        date("Y-m-d H:i", strtotime($endZeitString) + 60),
                        $aktuellerBlock->endZeit,
                        "frei",
                        $user_id,
                        $username,
                        null,
                        $main_shift_id,
                        null,
                        $virtual_workingarea_id,
                        $virtual_workingarea_name
                    );
                    $neuerPauseBlock->naechsterBlock = $neuerFreiBlock;
                    $neuerFreiBlock->naechsterBlock = $aktuellerBlock->naechsterBlock;
                } else {
                    $neuerPauseBlock->naechsterBlock = $aktuellerBlock->naechsterBlock;
                }
    
                // // ContentManager-Eintrag für die Pause
                // $contentManager->createTimeBlock(
                //     $user_id,
                //     $username,
                //     date('Y-m-d', strtotime($startZeitString)),
                //     $startZeitString,
                //     $endZeitString,
                //     $shift_id, // Shift-ID der Pause aus der Datenbank
                //     null,
                //     $main_shift_id,
                //     $haupt_start_user_time,
                //     $haupt_end_user_time,
                //     $virtual_workingarea_id,
                //     null,
                //     0,
                //     "pause"
                // );
    
                return [
                    'success' => true,
                    'message' => "Pause-Block aus Datenbank erfolgreich hinzugefügt von $startZeitString bis $endZeitString für $username mit Shift-ID $shift_id.",
                    'id' => $shift_id
                ];
            }
    
            $vorherigerBlock = $aktuellerBlock;
            $aktuellerBlock = $aktuellerBlock->naechsterBlock;
        }
    
        return [
            'success' => false,
            'message' => "Fehler: Der Pause-Block von $startZeitString bis $endZeitString kann nicht für $username eingefügt werden."
        ];
    }

    public function kannPauseBlockEingefuegtWerden($startZeit, $endZeit, $pause) {
        try {
            if (!($startZeit instanceof DateTime)) {
                $startZeit = new DateTime($startZeit);
            }
            if (!($endZeit instanceof DateTime)) {
                $endZeit = new DateTime($endZeit);
            }
        } catch (Exception $e) {
            return [
                'success' => false,
                'message' => "Ungültiges Zeitformat: " . $e->getMessage()
            ];
        }
    
        $startZeitString = $startZeit->format('Y-m-d H:i');
        echo '<pre>';
        echo '$startZeitString';
        echo '<pre>';
        var_dump($startZeitString);
        echo '</pre>';
        $endZeitString = $endZeit->format('Y-m-d H:i');
        echo '<pre>';
        echo '$endZeitString';
        echo '<pre>';
        var_dump($endZeitString);
        echo '</pre>';

        // if ($this->existiertPauseInUmgebung($startZeitString, $endZeitString, $pause)) {
        //     return [ 
        //         'success' => false,
        //         'message' => "Fehler: Es existiert bereits eine Pause innerhalb von 15 Minuten vor oder nach der geplanten Pausezeit."
        //     ];
        // }
    
        if (strtotime($startZeitString) >= strtotime($endZeitString)) {
            return [
                'success' => false,
                'message' => "Startzeit darf nicht nach oder gleich Endzeit sein."
            ];
        }
    
        $aktuellerBlock = $this->kopf;
    
        while ($aktuellerBlock !== null) {
            // Pause darf nur in "frei" oder "gap" eingefügt werden
            if (
                ($aktuellerBlock->status === "frei" || $aktuellerBlock->status === "gap") &&
                $aktuellerBlock->startZeit <= $startZeitString &&
                $aktuellerBlock->endZeit >= $endZeitString
            ) {
                return [
                    'success' => true,
                    'message' => "Pause kann eingefügt werden zwischen $startZeitString und $endZeitString."
                ];
            }
    
            // Wenn es eine Überschneidung mit einem belegten Block gibt, ist es verboten
            if (
                $aktuellerBlock->status === "belegt" &&
                $aktuellerBlock->startZeit < $endZeitString &&
                $aktuellerBlock->endZeit > $startZeitString
            ) {
                return [
                    'success' => false,
                    'message' => "Pause überschneidet sich mit einem belegten Block von {$aktuellerBlock->startZeit} bis {$aktuellerBlock->endZeit}."
                ];
            }
    
            $aktuellerBlock = $aktuellerBlock->naechsterBlock;
        }
    
        return [
            'success' => false,
            'message' => "Kein gültiger freier oder gap-Block gefunden für diesen Zeitraum."
        ];
    }

    // public function loeschePauseBlockMitID($shift_id, $user_id) {
    //     $aktuellerBlock = $this->kopf;
    //     $vorherigerBlock = null;
    
    //     while ($aktuellerBlock !== null) {
    //         if (
    //             $aktuellerBlock->status === "pause" &&
    //             $aktuellerBlock->main_shift_virtuell_id == $shift_id
    //         ) {
    //             // Setze Block auf 'frei'
    //             $aktuellerBlock->status = "frei";
    //             $aktuellerBlock->main_shift_virtuell_id = null;
    //             $aktuellerBlock->shift_id = null;
    
    //             // Führe mit vorherigem zusammen, falls auch frei
    //             if ($vorherigerBlock !== null && $vorherigerBlock->status === "frei") {
    //                 $vorherigerBlock->endZeit = $aktuellerBlock->endZeit;
    //                 $vorherigerBlock->naechsterBlock = $aktuellerBlock->naechsterBlock;
    //                 $aktuellerBlock = $vorherigerBlock;
    //             }
    
    //             // Führe mit nächstem zusammen, falls auch frei
    //             if ($aktuellerBlock->naechsterBlock !== null && $aktuellerBlock->naechsterBlock->status === "frei") {
    //                 $aktuellerBlock->endZeit = $aktuellerBlock->naechsterBlock->endZeit;
    //                 $aktuellerBlock->naechsterBlock = $aktuellerBlock->naechsterBlock->naechsterBlock;
    //             }
    
    //             return [
    //                 'success' => true,
    //                 'message' => "Pause-Block mit virtueller ID $shift_id wurde erfolgreich gelöscht."
    //             ];
    //         }
    
    //         $vorherigerBlock = $aktuellerBlock;
    //         $aktuellerBlock = $aktuellerBlock->naechsterBlock;
    //     }
    
    //     return [
    //         'success' => false,
    //         'message' => "Kein Pause-Block mit der virtuellen ID $shift_id gefunden."
    //     ];
    // }

    public function loeschePauseBlockMitID($virtuelle_id, $user_id, $debug = false) {
        if ($debug) {
            echo "🔍 Starte Löschvorgang für virtuelle Shift-ID $virtuelle_id...<br>";
        }
    
        $aktuellerBlock = $this->kopf;
        $vorherigerBlock = null;
        $blockNummer = 0;
    
        while ($aktuellerBlock !== null) {
            if ($debug) {
                echo "➤ Block $blockNummer:<br>";
                echo "- Status: {$aktuellerBlock->status}<br>";
                echo "- main_shift_virtuell_id: {$aktuellerBlock->main_shift_virtuell_id}<br>";
                echo "- shift_id: {$aktuellerBlock->shift_id}<br>";
                echo "- start: {$aktuellerBlock->startZeit} | ende: {$aktuellerBlock->endZeit}<br><br>";
            }
    
            if (
                $aktuellerBlock->status === "pause" &&
                (string)$aktuellerBlock->main_shift_virtuell_id === (string)$virtuelle_id
            ) {
                if ($debug) {
                    echo "✅ Passender Block gefunden. Lösche...<br>";
                }
    
                // Block auf 'frei' setzen
                $aktuellerBlock->status = "frei";
                $aktuellerBlock->main_shift_virtuell_id = null;
                $aktuellerBlock->shift_id = null;
    
                // Mit vorherigem Block zusammenführen, falls dieser auch 'frei' ist
                if ($vorherigerBlock !== null && $vorherigerBlock->status === "frei") {
                    $vorherigerBlock->endZeit = $aktuellerBlock->endZeit;
                    $vorherigerBlock->naechsterBlock = $aktuellerBlock->naechsterBlock;
                    $aktuellerBlock = $vorherigerBlock;
                }
    
                // Mit nachfolgendem Block zusammenführen, falls dieser auch 'frei' ist
                if ($aktuellerBlock->naechsterBlock !== null && $aktuellerBlock->naechsterBlock->status === "frei") {
                    $aktuellerBlock->endZeit = $aktuellerBlock->naechsterBlock->endZeit;
                    $aktuellerBlock->naechsterBlock = $aktuellerBlock->naechsterBlock->naechsterBlock;
                }
    
                return [
                    'success' => true,
                    'message' => "Pause-Block mit virtueller ID $virtuelle_id wurde erfolgreich gelöscht."
                ];
            }
    
            $vorherigerBlock = $aktuellerBlock;
            $aktuellerBlock = $aktuellerBlock->naechsterBlock;
            $blockNummer++;
        }
    
        if ($debug) {
            echo "❌ Kein passender Block mit virtueller ID $virtuelle_id gefunden<br>";
        }
    
        return [
            'success' => false,
            'message' => "Kein Pause-Block mit der virtuellen ID $virtuelle_id gefunden."
        ];
    }
    

    public function loescheBlock($shift_id) {
        $aktuellerBlock = $this->kopf;
        $vorherigerBlock = null;

        while ($aktuellerBlock !== null) {
            if ($aktuellerBlock->status === "belegt" && $aktuellerBlock->shift_id == $shift_id) {
                $aktuellerBlock->status = "frei";
                $aktuellerBlock->shift_id = null;
                $aktuellerBlock->main_shift_virtuell_id = null;

                if ($vorherigerBlock && $vorherigerBlock->status === "frei") {
                    $vorherigerBlock->endZeit = $aktuellerBlock->endZeit;
                    $vorherigerBlock->naechsterBlock = $aktuellerBlock->naechsterBlock;
                    $aktuellerBlock = $vorherigerBlock;
                }

                if ($aktuellerBlock->naechsterBlock && $aktuellerBlock->naechsterBlock->status === "frei") {
                    $aktuellerBlock->endZeit = $aktuellerBlock->naechsterBlock->endZeit;
                    $aktuellerBlock->naechsterBlock = $aktuellerBlock->naechsterBlock->naechsterBlock;
                }

                echo "Block mit Shift-ID $shift_id wurde erfolgreich gelöscht.<br>";
                return true;
            }
            $vorherigerBlock = $aktuellerBlock;
            $aktuellerBlock = $aktuellerBlock->naechsterBlock;
        }

        echo "Fehler: Kein Block mit Shift-ID $shift_id gefunden.<br>";
        return false;
    }

    public function zeigeListe() {
        $aktuellerBlock = $this->kopf;
        echo "<pre>";
        echo "----------------------------------------------------------------------------------------------------------------------------------------------------\n";
        echo "| Start              | Ende               | Status     | User ID | Username                       | Shift ID | Main Shift ID | Gap Shift ID     | Workarea ID |\n";
        echo "----------------------------------------------------------------------------------------------------------------------------------------------------\n";

        while ($aktuellerBlock !== null) {
            printf(
                "| %-18s | %-18s | %-10s | %-7s | %-30s | %-8s | %-13s | %-16s | %-11s |\n",
                $aktuellerBlock->startZeit,
                $aktuellerBlock->endZeit,
                $aktuellerBlock->status,
                $aktuellerBlock->user_id ?? "-",
                $aktuellerBlock->username ?? "-",
                $aktuellerBlock->shift_id ?? "-",
                $aktuellerBlock->main_shift_id ?? "-",
                $aktuellerBlock->main_shift_virtuell_id ?? "-",
                $aktuellerBlock->virtual_workingarea_id ?? "-"
            );
            $aktuellerBlock = $aktuellerBlock->naechsterBlock;
        }

        echo "----------------------------------------------------------------------------------------------------------------------------------------------------\n";
        echo "</pre>";
    }

    public function getKopf() {
        return $this->kopf;
    }

    public function setKopf($neuerKopf) {
        $this->kopf = $neuerKopf;
    }

    public function getAlleBloeckeAlsArray() {
        $bloecke = [];
        $aktuellerBlock = $this->kopf;

        while ($aktuellerBlock !== null) {
            $bloecke[] = $aktuellerBlock->toArray();
            $aktuellerBlock = $aktuellerBlock->naechsterBlock;
        }

        return $bloecke;
    }

    public function alsArray() {
        $array = [];
        $aktuellerBlock = $this->kopf;
    
        while ($aktuellerBlock !== null) {
            $array[] = [
                'startZeit' => $aktuellerBlock->startZeit,
                'endZeit' => $aktuellerBlock->endZeit,
                'status' => $aktuellerBlock->status,
                'user_id' => $aktuellerBlock->user_id,
                'username' => $aktuellerBlock->username,
                'shift_id' => $aktuellerBlock->shift_id,
                'main_shift_id' => $aktuellerBlock->main_shift_id,
                'main_shift_virtuell_id' => $aktuellerBlock->main_shift_virtuell_id,
                'virtual_workingarea_id' => $aktuellerBlock->virtual_workingarea_id,
                'virtual_workingarea_name' => $aktuellerBlock->virtual_workingarea_name
            ];
            $aktuellerBlock = $aktuellerBlock->naechsterBlock;
        }
    
        return $array;
    }    
}

class tages_Verwaltung {
    private $tage = [];

    public function fuegeTerminHinzu(
        $datum,
        $startZeit,
        $endZeit,
        $user_id,
        $username,
        $shift_id,
        $haupt_start_user_time,
        $haupt_end_user_time,
        $main_shift_id,
        $virtual_workingarea_id,
        $virtual_workingarea_name,
        $api_key,
        $location_id,
        $wk_id,
        ContentManager $contentManager
    ) {
        if (!preg_match('/^\d{4}-\d{2}-\d{2}$/', $datum) || !strtotime($datum)) {
            return [
                'success' => false,
                'message' => "Fehler: Ungültiges Datumsformat '$datum'. Verwenden Sie YYYY-MM-DD."
            ];
        }

        if (strtotime("$datum $startZeit") > strtotime("$datum $endZeit")) {
            return [
                'success' => false,
                'message' => "Fehler: Startzeit '$startZeit' darf nicht nach Endzeit '$endZeit' liegen."
            ];
        }

        if (!isset($this->tage[$datum])) {
            $this->tage[$datum] = [];
        }

        if (!isset($this->tage[$datum][$main_shift_id])) {
            $this->tage[$datum][$main_shift_id] = new verkettete_Liste(
                "$datum $haupt_start_user_time",
                "$datum $haupt_end_user_time",
                $user_id,
                $username,
                $main_shift_id,
                $virtual_workingarea_id,
                $virtual_workingarea_name
            );
        }

        // if (!isset($this->tage[$datum])) {
        //     $this->tage[$datum] = new verkettete_Liste(
        //         "$datum $haupt_start_user_time",
        //         "$datum $haupt_end_user_time",
        //         $user_id,
        //         $username,
        //         $main_shift_id,
        //         $virtual_workingarea_id,
        //         $virtual_workingarea_name
        //     );
        // }

    //     return $this->tage[$datum]->fuegeBlockHinzu(
    //         "$datum $startZeit",
    //         "$datum $endZeit",
    //         $user_id,
    //         $username,
    //         $shift_id,
    //         $main_shift_id,
    //         $virtual_workingarea_id,
    //         $virtual_workingarea_name,
    //         $api_key,
    //         $location_id,
    //         $wk_id,
    //         $contentManager
    //     );
    // }
    return $this->tage[$datum][$main_shift_id]->fuegeBlockHinzu(
        "$datum $startZeit",
        "$datum $endZeit",
        $user_id,
        $username,
        $shift_id,
        $main_shift_id,
        $virtual_workingarea_id,
        $virtual_workingarea_name,
        $api_key,
        $location_id,
        $wk_id,
        $contentManager
    );
}

    public function fuegeGapTerminHinzu(
        $datum,
        $startZeit,
        $endZeit,
        $user_id,
        $username,
        $haupt_start_user_time,
        $haupt_end_user_time,
        $main_shift_id,
        $virtual_workingarea_id,
        $virtual_workingarea_name,
        $shift_id,   
        ContentManager $contentManager
    ) {
        // Validate date format (YYYY-MM-DD)
        if (!preg_match('/^\d{4}-\d{2}-\d{2}$/', $datum) || !strtotime($datum)) {
            return [
                'success' => false,
                'message' => "Fehler: Ungültiges Datumsformat '$datum'. Verwenden Sie YYYY-MM-DD."
            ];
        }

        if (!isset($this->tage[$datum][$main_shift_id])) {
            $this->tage[$datum][$main_shift_id] = new verkettete_Liste(
                "$datum $haupt_start_user_time",
                "$datum $haupt_end_user_time",
                $user_id,
                $username,
                $main_shift_id,
                $virtual_workingarea_id,
                $virtual_workingarea_name
            );
        }

        return $this->tage[$datum][$main_shift_id]->fuegeGapBlockHinzu(
            "$datum $startZeit",
            "$datum $endZeit",
            $user_id,
            $username,
            $main_shift_id,
            $virtual_workingarea_id,
            $virtual_workingarea_name,
            $shift_id,
            "$datum $haupt_start_user_time",
            "$datum $haupt_end_user_time",
            $contentManager
        );
    }

    public function fuegePauseHinzu(
        $datum,
        $startZeit,
        $endZeit,
        $user_id,
        $username,
        $haupt_start_user_time,
        $haupt_end_user_time,
        $main_shift_id,
        $virtual_workingarea_id,
        $virtual_workingarea_name,
        $shift_id,   
        $apikeyPapershift,
        $location_id,
        $tag_pause_id,
        $pause,
        ContentManager $contentManager
    ) {
        // Validate date format (YYYY-MM-DD)
        if (!preg_match('/^\d{4}-\d{2}-\d{2}$/', $datum) || !strtotime($datum)) {
            return [
                'success' => false,
                'message' => "Fehler: Ungültiges Datumsformat '$datum'. Verwenden Sie YYYY-MM-DD."
            ];
        }

        if (!isset($this->tage[$datum])) {
            $this->tage[$datum] = [];
        }

        if (!isset($this->tage[$datum][$main_shift_id])) {
            $this->tage[$datum][$main_shift_id] = new verkettete_Liste(
                "$datum $haupt_start_user_time",
                "$datum $haupt_end_user_time",
                $user_id,
                $username,
                $main_shift_id,
                $virtual_workingarea_id,
                $virtual_workingarea_name
            );
        }

        return $this->tage[$datum][$main_shift_id]->fuegePauseBlockHinzu(
            "$datum $startZeit",
            "$datum $endZeit",
            $user_id,
            $username,
            $main_shift_id,
            $virtual_workingarea_id,
            $virtual_workingarea_name,
            $shift_id,
            "$datum $haupt_start_user_time",
            "$datum $haupt_end_user_time",
            $apikeyPapershift,
            $location_id,
            $tag_pause_id,
            $pause,
            $contentManager
        );
    }

    public function fuegePauseAusDatenbankHinzu(
        $datum,
        $startZeit,
        $endZeit,
        $user_id,
        $username,
        $haupt_start_user_time,
        $haupt_end_user_time,
        $main_shift_id,
        $virtual_workingarea_id,
        $virtual_workingarea_name,
        $shift_id, // Existing shift ID from the database
        ContentManager $contentManager
    ) {
        // Validate date format (YYYY-MM-DD)
        if (!preg_match('/^\d{4}-\d{2}-\d{2}$/', $datum) || !strtotime($datum)) {
            return [
                'success' => false,
                'message' => "Fehler: Ungültiges Datumsformat '$datum'. Verwenden Sie YYYY-MM-DD."
            ];
        }
    
        if (!isset($this->tage[$datum])) {
            $this->tage[$datum] = [];
        }

        if (!isset($this->tage[$datum][$main_shift_id])) {
            $this->tage[$datum][$main_shift_id] = new verkettete_Liste(
                "$datum $haupt_start_user_time",
                "$datum $haupt_end_user_time",
                $user_id,
                $username,
                $main_shift_id,
                $virtual_workingarea_id,
                $virtual_workingarea_name
            );
        }

        return $this->tage[$datum][$main_shift_id]->fuegePauseBlockAusDatenbankHinzu(
            "$datum $startZeit",
            "$datum $endZeit",
            $user_id,
            $username,
            $main_shift_id,
            $virtual_workingarea_id,
            $virtual_workingarea_name,
            $shift_id,
            "$datum $haupt_start_user_time",
            "$datum $haupt_end_user_time",
            $contentManager
        );
    }

    public function kannPauseEingefuegtWerden(
        $datum,
        $startZeit,
        $endZeit,
        $user_id,
        $username,
        $haupt_start_user_time,
        $haupt_end_user_time,
        $main_shift_id,
        $virtual_workingarea_id,
        $virtual_workingarea_name,
        $pause
    ) {
        // Validate date format (YYYY-MM-DD)
        if (!preg_match('/^\d{4}-\d{2}-\d{2}$/', $datum) || !strtotime($datum)) {
            return [
                'success' => false,
                'message' => "Fehler: Ungültiges Datumsformat '$datum'. Verwenden Sie YYYY-MM-DD."
            ];
        }
    
        if (!isset($this->tage[$datum])) {
            $this->tage[$datum] = [];
        }

        if (!isset($this->tage[$datum][$main_shift_id])) {
            $this->tage[$datum][$main_shift_id] = new verkettete_Liste(
                "$datum $haupt_start_user_time",
                "$datum $haupt_end_user_time",
                $user_id,
                $username,
                $main_shift_id,
                $virtual_workingarea_id,
                $virtual_workingarea_name
            );
        }

        return $this->tage[$datum][$main_shift_id]->kannPauseBlockEingefuegtWerden(
            "$datum $startZeit",
            "$datum $endZeit",
            $pause
        );
    }

    // public function loeschePauseMitID($datum, $main_shift_id, $shift_id, $user_id) {
    //     if (!isset($this->tage[$datum][$main_shift_id])) {
    //         return [
    //             'success' => false,
    //             'message' => "Kein Eintrag für $datum und Main-Shift-ID $main_shift_id vorhanden."
    //         ];
    //     }
    
    //     return $this->tage[$datum][$main_shift_id]->loeschePauseBlockMitID($shift_id, $user_id);
    // }
    public function loeschePauseMitID($datum, $main_shift_id, $shift_id, $user_id, $debug = true) {
        if (!isset($this->tage[$datum])) {
            if ($debug) {
                echo "❌ Kein Eintrag für das Datum $datum vorhanden.\n";
            }
            return [
                'success' => false,
                'message' => "Kein Eintrag für $datum vorhanden."
            ];
        }
    
        if (!isset($this->tage[$datum][$main_shift_id])) {
            if ($debug) {
                echo "❌ Kein Eintrag für $datum und Main-Shift-ID $main_shift_id vorhanden.\n";
            }
            return [
                'success' => false,
                'message' => "Kein Eintrag für $datum und Main-Shift-ID $main_shift_id vorhanden."
            ];
        }
    
        if ($debug) {
            echo "🔍 Versuche Löschung von Pause-Block mit virtueller ID $shift_id für Benutzer $user_id...\n";
        }
    
        return $this->tage[$datum][$main_shift_id]->loeschePauseBlockMitID(
            $shift_id,
            $user_id,
            $debug // Debug-Flag wird weitergereicht
        );
    }
    

    public function convertFreeToGap(
        $datum,
        $api_key,
        $location_id,
        $virtual_workingarea_id,
        $haupt_start_user_time,
        $haupt_end_user_time,
        $tag_gap_id,
        ContentManager $contentManager
    ) {
        if (!isset($this->tage[$datum])) {
            return [
                'success' => false,
                'message' => "Fehler: Keine Termine für Datum $datum vorhanden."
            ];
        }
    
        $results = [];
    
        foreach ($this->tage[$datum] as $main_shift_id => $liste) {
            $result = $this->convertFreeToGapIntern(
                $liste,
                $datum,
                $main_shift_id,
                $api_key,
                $location_id,
                $virtual_workingarea_id,
                $haupt_start_user_time,
                $haupt_end_user_time,
                $tag_gap_id,
                $contentManager
            );
            $results[$main_shift_id] = $result;
        }
    
        return [
            'success' => !empty($results),
            'results' => $results
        ];
    }

    public function convertFreeToGapIntern(
        $liste,
        $datum,
        $main_shift_id,
        $api_key,
        $location_id,
        $virtual_workingarea_id,
        $haupt_start_user_time,
        $haupt_end_user_time,
        $tag_gap_id,
        ContentManager $contentManager,
        $debug = false
    ) {
        $kopf = $liste->getKopf();
        $results = [];
    
        $hatBelegteBloecke = false;
        $check = $kopf;
        while ($check !== null) {
            if ($debug) echo "[DEBUG] Checking block status for belegung/pruefung: {$check->status}\n";
            if (in_array($check->status, ["belegt", "pause"])) {
                $hatBelegteBloecke = true;
                break;
            }
            $check = $check->naechsterBlock;
        }
    
        $aktueller = $kopf;
        $startMerge = null;
        $endMerge = null;
        $foundSequence = false;
    
        while ($aktueller !== null) {
            $next = $aktueller->naechsterBlock;
            if ($debug) echo "[DEBUG] Aktueller Block: {$aktueller->startZeit} - {$aktueller->endZeit}, Status: {$aktueller->status}\n";
    
            if (in_array($aktueller->status, ["gap", "frei"])) {
                if ($startMerge === null) {
                    $startMerge = $aktueller;
                    if ($debug) echo "[DEBUG] Merge-Start gefunden: {$startMerge->startZeit}\n";
                }
                $endMerge = $aktueller;
                $foundSequence = true;
            }
    
            if ($aktueller->status === "pause") {
                if ($foundSequence && $startMerge !== null && $endMerge !== null) {
                    if ($debug) echo "[DEBUG] Sequence vor 'pause' wird zusammengeführt: {$startMerge->startZeit} - {$endMerge->endZeit}\n";
                    $results[] = $this->mergeGapSequence(
                        $liste,
                        $startMerge,
                        $endMerge,
                        $api_key,
                        $location_id,
                        $virtual_workingarea_id,
                        $haupt_start_user_time,
                        $haupt_end_user_time,
                        $tag_gap_id,
                        $contentManager
                    );
                    
                }
                $startMerge = null;
                $endMerge = null;
                $foundSequence = false;
                $aktueller = $aktueller->naechsterBlock;
                continue;
            }
    
            if ($aktueller->status !== "gap" && $aktueller->status !== "frei" || $next === null) {
                if ($foundSequence && $startMerge !== null && $endMerge !== null) {
                    if (
                        $startMerge === $endMerge &&
                        $startMerge->status === "gap" &&
                        (
                            $startMerge->vorherigerBlock === null || $startMerge->vorherigerBlock->status === "frei"
                        ) &&
                        (
                            $startMerge->naechsterBlock === null || $startMerge->naechsterBlock->status === "frei"
                        ) &&
                        !$hatBelegteBloecke
                    ) {
                        if ($startMerge->main_shift_virtuell_id) {
                            if ($debug) echo "[DEBUG] Lösche einzel-Gap-Block: {$startMerge->main_shift_virtuell_id}\n";
                            $delete = deleteShiftPapershift([
                                "api_token" => $api_key,
                                "shift" => ["id" => $startMerge->main_shift_virtuell_id]
                            ]);
                            if ($delete['http_code'] === 200) {
                                $contentManager->deleteTimeBlock(
                                    $startMerge->startZeit,
                                    $startMerge->main_shift_virtuell_id,
                                    $startMerge->user_id
                                );
                                $startMerge->status = "frei";
                                $startMerge->main_shift_virtuell_id = null;
                                $results[] = [
                                    'success' => true,
                                    'message' => "Einzelner Gap-Block von {$startMerge->startZeit} bis {$startMerge->endZeit} gelöscht und als frei markiert."
                                ];
                            } else {
                                $results[] = [
                                    'success' => false,
                                    'message' => "Fehler: Gap Shift {$startMerge->main_shift_virtuell_id} konnte nicht gelöscht werden."
                                ];
                            }
                        }
                    } elseif ($startMerge !== $endMerge || ($startMerge === $endMerge && $startMerge->status === "frei" && $hatBelegteBloecke)) {
                        if ($debug) echo "[DEBUG] Merge-Liste zwischen {$startMerge->startZeit} und {$endMerge->endZeit} wird bearbeitet.\n";
                        $results[] = $this->mergeGapSequence(
                            $liste,
                            $startMerge,
                            $endMerge,
                            $api_key,
                            $location_id,
                            $virtual_workingarea_id,
                            $haupt_start_user_time,
                            $haupt_end_user_time,
                            $tag_gap_id,
                            $contentManager
                        );
                    }
                }
    
                $startMerge = null;
                $endMerge = null;
                $foundSequence = false;
            }
    
            $aktueller = $next;
        }
    
        $nurGapBlock = $liste->getKopf();
        if (
            $nurGapBlock !== null &&
            $nurGapBlock->status === "gap" &&
            $nurGapBlock->vorherigerBlock === null &&
            $nurGapBlock->naechsterBlock === null &&
            !$hatBelegteBloecke
        ) {
            if ($debug) echo "[DEBUG] Spezialfall: Nur ein einzelner Block über gesamten Zeitraum.\n";
            $shiftId = $nurGapBlock->main_shift_virtuell_id;
            if ($shiftId) {
                $delete = deleteShiftPapershift([
                    "api_token" => $api_key,
                    "shift" => ["id" => $shiftId]
                ]);
                if ($delete['http_code'] === 200) {
                    $contentManager->deleteTimeBlock(
                        $nurGapBlock->startZeit,
                        $nurGapBlock->main_shift_virtuell_id,
                        $nurGapBlock->user_id
                    );
                    $nurGapBlock->status = "frei";
                    $nurGapBlock->main_shift_virtuell_id = null;
                    $results[] = [
                        'success' => true,
                        'message' => "Einzelner Gap-Block über gesamten Zeitraum wurde gelöscht und als frei markiert."
                    ];
                } else {
                    $results[] = [
                        'success' => false,
                        'message' => "Fehler: Einzelner Gap konnte nicht gelöscht werden."
                    ];
                }
            }
        }
    
        return [
            'success' => !empty($results),
            'results' => $results
        ];
    }
    

    public function mergeGapSequence(
        $liste,
        $startBlock,
        $endBlock,
        $api_key,
        $location_id,
        $virtual_workingarea_id,
        $haupt_start_user_time,
        $haupt_end_user_time,
        $tag_gap_id,
        ContentManager $contentManager
    ) {
        $current = $startBlock;
        while ($current !== null && $current !== $endBlock->naechsterBlock) {
            if ($current->status === "gap" && $current->main_shift_virtuell_id) {
                // $delete = mockDeleteShiftPapershift([ //nur für test
                //     "api_token" => $api_key,
                //     "shift" => ["id" => $current->main_shift_virtuell_id]
                // ]);
                $delete = deleteShiftPapershift([
                    "api_token" => $api_key,
                    "shift" => ["id" => $current->main_shift_virtuell_id]
                ]);
                if ($delete['http_code'] !== 200) {
                    return [
                        'success' => false,
                        'message' => "Fehler: Gap Shift {$current->main_shift_virtuell_id} konnte nicht gelöscht werden."
                    ];
                }
                $contentManager->deleteTimeBlock(
                    $current->startZeit,
                    $current->main_shift_virtuell_id,
                    $current->user_id
                );
            }
            $current = $current->naechsterBlock;
        }

        $startZeit = $startBlock->startZeit;
        $endZeit = $endBlock->endZeit;

        $create = createNewShiftPapershift([
            "api_token" => $api_key,
            "shift" => [
                "location_id" => $location_id,
                "working_area_id" => $virtual_workingarea_id,
                "starts_at" => (new DateTime($startZeit))->format(DATE_ATOM),
                "ends_at" => (new DateTime($endZeit))->format(DATE_ATOM),
                "number_of_employees" => 1,
                "note" => "Diese Schicht wurde nur für Zeiterfassung erstellt und bitte nicht löschen oder etwas ändern.",
                "tags" => $tag_gap_id
            ]
        ]);
        $decodedResponse_create = json_decode($create, true);
        // $create = mockCreateNewShiftPapershift([ nur für test
        //     "api_token" => $api_key,
        //     "shift" => [
        //         "location_id" => $location_id,
        //         "working_area_id" => $wk_id,
        //         "starts_at" => (new DateTime($startZeit))->format(DATE_ATOM),
        //         "ends_at" => (new DateTime($endZeit))->format(DATE_ATOM),
        //         "number_of_employees" => 1,
        //         "note" => "Diese Schicht wurde nur für Zeiterfassung erstellt und bitte nicht löschen oder etwas ändern."
        //     ]
        // ]);

        if (!isset($decodedResponse_create["id"])) {
            return [
                'success' => false,
                'message' => "Fehler beim Erstellen des kombinierten Gap-Shifts von $startZeit bis $endZeit."
            ];
        }

        $requestData = [
            "api_token" => $api_key,
            "assignment" => [
                "shift_id" => $decodedResponse_create["id"],
                "user_id" => $startBlock->user_id
            ]
        ];

        $zuweisen = assignUserToShiftPapershift($requestData);
        $decodedResponse = json_decode($zuweisen, true);
        // Überprüfen, ob API-Zuweisung erfolgreich war
        $assignmentErfolgreich = isset($decodedResponse["users"]["assigned"]) && !empty($decodedResponse["users"]["assigned"]);
        if (!$assignmentErfolgreich) {
            echo "Zuweisung fehlgeschlagen(Time_block) für User-ID {$startBlock->user_id}. Antwort: " . $zuweisen . "<br>";
        } else {

            echo '<pre>';
            echo 'date(Y-m-d, strtotime($startZeit))';
            echo '<pre>';
            var_dump(date('Y-m-d', strtotime($startZeit)));
            echo '</pre>';
            echo '<pre>';
            echo '$startZeit';
            echo '<pre>';
            var_dump($startZeit);
            echo '</pre>';
            echo '<pre>';
            echo '$endZeit';
            echo '<pre>';
            var_dump($endZeit);
            echo '</pre>';
            $contentManager->createTimeBlock(
                $startBlock->user_id,
                $startBlock->username,
                date('Y-m-d', strtotime($startZeit)),
                $startZeit,
                $endZeit,
                $decodedResponse_create["id"],
                $startBlock->main_shift_id,
                null,
                $haupt_start_user_time,
                $haupt_end_user_time,
                $virtual_workingarea_id,
                null,
                0,
                "gap"
            );
        }

        $vorStart = $liste->getKopf();
        $prev = null;
        while ($vorStart !== $startBlock && $vorStart !== null) {
            $prev = $vorStart;
            $vorStart = $vorStart->naechsterBlock;
        }

        $mergedGapBlock = new zeit_block(
            $startZeit,
            $endZeit,
            "gap",
            $startBlock->user_id,
            $startBlock->username,
            null,
            $startBlock->main_shift_id,
            $decodedResponse_create["id"],
            $startBlock->virtual_workingarea_id,
            $startBlock->virtual_workingarea_name
        );

        if ($prev) {
            $prev->naechsterBlock = $mergedGapBlock;
        } else {
            $liste->setKopf($mergedGapBlock);
        }

        $mergedGapBlock->naechsterBlock = $endBlock->naechsterBlock;

        return [
            'success' => true,
            'message' => "Gap-Block zusammengeführt von $startZeit bis $endZeit mit ID {$decodedResponse_create["id"]}."
        ];
    }

    public function loescheTermin($datum, $main_shift_id, $shift_id) {
        if (!isset($this->tage[$datum][$main_shift_id])) {
            return [
                'success' => false,
                'message' => "Kein Eintrag für $datum und main_shift_id $main_shift_id vorhanden."
            ];
        }

        return $this->tage[$datum][$main_shift_id]->loescheBlock($shift_id);
    }

public function berechneBelegteZeitProTag($datum, $main_shift_id) {
    if (!isset($this->tage[$datum][$main_shift_id])) {
        return "00:00";
    }

    $gesamtMinuten = 0;
    $aktuellerBlock = $this->tage[$datum][$main_shift_id]->getKopf();

    while ($aktuellerBlock !== null) {
        if ($aktuellerBlock->status === "belegt") {
            $start = strtotime($aktuellerBlock->startZeit);
            $end = strtotime($aktuellerBlock->endZeit);
            $gesamtMinuten += ($end - $start) / 60;
        }
        $aktuellerBlock = $aktuellerBlock->naechsterBlock;
    }

    $stunden = floor($gesamtMinuten / 60);
    $minuten = $gesamtMinuten % 60;
    return sprintf("%02d:%02d", $stunden, $minuten);
}

    public function zeigeAlleTage() {
        foreach ($this->tage as $datum => $listen) {
            echo "<h3>Datum: $datum</h3>";
            foreach ($listen as $main_shift_id => $liste) {
                echo "<h4>Main Shift ID: $main_shift_id</h4>";
                $liste->zeigeListe();
                echo "<b>Belegte Zeit für $datum / $main_shift_id:</b> " . $this->berechneBelegteZeitProTag($datum, $main_shift_id) . "<br><br>";
            }
        }
    }

    public function getKopf($datum) {
        return $this->tage[$datum] ?? null;
    }

    public function getTagAlsArray($datum) {
        if (!isset($this->tage[$datum])) {
            return [];
        }
    
        $result = [];
        foreach ($this->tage[$datum] as $main_shift_id => $liste) {
            $result[$main_shift_id] = $liste->alsArray();
        }
    
        return $result;
    }

    public function getTage() {
        return $this->tage;
    }
}

class personen_verwaltung {
    private $personen = [];

    public function fuegeTerminHinzu(
        $user_id,
        $username,
        $datum,
        $startZeit,
        $endZeit,
        $shift_id,
        $haupt_start_user_time,
        $haupt_end_user_time,
        $main_shift_id,
        $virtual_workingarea_id,
        $virtual_workingarea_name,
        $api_key,
        $location_id,
        ContentManager $contentManager,
        $wk_id

    ) {
        if (!isset($this->personen[$user_id])) {
            $this->personen[$user_id] = new tages_Verwaltung();
        }

        $ergebnis = $this->personen[$user_id]->fuegeTerminHinzu(
            $datum,
            $startZeit,
            $endZeit,
            $user_id,
            $username,
            $shift_id,
            $haupt_start_user_time,
            $haupt_end_user_time,
            $main_shift_id,
            $virtual_workingarea_id,
            $virtual_workingarea_name,
            $api_key,
            $location_id,
            $wk_id,
            $contentManager
        );

        if ($ergebnis['success']) {
            $belegteZeit = $this->personen[$user_id]->berechneBelegteZeitProTag($datum, $main_shift_id);
            $ergebnis['belegte_zeit'] = $belegteZeit;
        }

        return $ergebnis;
    }

    public function fuegeGapTerminHinzu(
        $user_id,
        $username,
        $datum,
        $startZeit,
        $endZeit,
        $haupt_start_user_time,
        $haupt_end_user_time,
        $main_shift_id,
        $virtual_workingarea_id,
        $virtual_workingarea_name,
        $shift_id,           // <<< NEU: übergebene Shift-ID
        ContentManager $contentManager
    ) {
        if (!isset($this->personen[$user_id])) {
            $this->personen[$user_id] = new tages_Verwaltung();
        }
    
        return $this->personen[$user_id]->fuegeGapTerminHinzu(
            $datum,
            $startZeit,
            $endZeit,
            $user_id,
            $username,
            $haupt_start_user_time,
            $haupt_end_user_time,
            $main_shift_id,
            $virtual_workingarea_id,
            $virtual_workingarea_name,
            $shift_id,           // <<< weiterreichen
            $contentManager
        );
    }

    public function fuegePauseHinzu(
        $user_id,
        $username,
        $datum,
        $startZeit,
        $endZeit,
        $haupt_start_user_time,
        $haupt_end_user_time,
        $main_shift_id,
        $virtual_workingarea_id,
        $virtual_workingarea_name,
        $shift_id,           // übergebene Shift(pause)-ID
        $apikeyPapershift,
        $location_id,
        $tag_pause_id,
        $pause,
        ContentManager $contentManager
    ) {
        if (!isset($this->personen[$user_id])) {
            $this->personen[$user_id] = new tages_Verwaltung();
        }
    
        return $this->personen[$user_id]->fuegePauseHinzu(
            $datum,
            $startZeit,
            $endZeit,
            $user_id,
            $username,
            $haupt_start_user_time,
            $haupt_end_user_time,
            $main_shift_id,
            $virtual_workingarea_id,
            $virtual_workingarea_name,
            $shift_id,           // <<< weiterreichen
            $apikeyPapershift,
            $location_id,
            $tag_pause_id,
            $pause,
            $contentManager
        );
    }

    public function fuegePauseAusDatenbankHinzu(
        $user_id,
        $username,
        $datum,
        $startZeit,
        $endZeit,
        $haupt_start_user_time,
        $haupt_end_user_time,
        $main_shift_id,
        $virtual_workingarea_id,
        $virtual_workingarea_name,
        $shift_id, // Existing shift ID from the database
        ContentManager $contentManager
    ) {
        if (!isset($this->personen[$user_id])) {
            $this->personen[$user_id] = new tages_Verwaltung();
        }
    
        return $this->personen[$user_id]->fuegePauseAusDatenbankHinzu(
            $datum,
            $startZeit,
            $endZeit,
            $user_id,
            $username,
            $haupt_start_user_time,
            $haupt_end_user_time,
            $main_shift_id,
            $virtual_workingarea_id,
            $virtual_workingarea_name,
            $shift_id,
            $contentManager
        );
    }

    public function kannPauseEingefuegtWerden(
        $user_id,
        $username,
        $datum,
        $startZeit,
        $endZeit,
        $haupt_start_user_time,
        $haupt_end_user_time,
        $main_shift_id,
        $virtual_workingarea_id,
        $virtual_workingarea_name,
        $pause
    ) {
        if (!isset($this->personen[$user_id])) {
            $this->personen[$user_id] = new tages_Verwaltung();
        }
    
        return $this->personen[$user_id]->kannPauseEingefuegtWerden(
            $datum,
            $startZeit,
            $endZeit,
            $user_id,
            $username,
            $haupt_start_user_time,
            $haupt_end_user_time,
            $main_shift_id,
            $virtual_workingarea_id,
            $virtual_workingarea_name,
            $pause
        );
    }

    // public function loeschePauseMitID(
    //     $user_id,
    //     $datum,
    //     $main_shift_id,
    //     $shift_id
    // ) {
    //     if (!isset($this->personen[$user_id])) {
    //         return [
    //             'success' => false,
    //             'message' => "Keine Person mit Benutzer-ID $user_id vorhanden."
    //         ];
    //     }
    
    //     $tage = $this->personen[$user_id]->getTage();
    
    //     if (!isset($tage[$datum][$main_shift_id])) {
    //         return [
    //             'success' => false,
    //             'message' => "Kein Eintrag für Datum $datum und Main-Shift-ID $main_shift_id vorhanden."
    //         ];
    //     }
    
    //     return $tage[$datum][$main_shift_id]->loeschePauseBlockMitID(
    //         $shift_id,
    //         $user_id
    //     );
    // }

    public function loeschePauseMitID(
        $user_id,
        $datum,
        $main_shift_id,
        $shift_id,
        $debug = true
    ) {
        if (!isset($this->personen[$user_id])) {
            if ($debug) {
                echo "❌ Person mit user_id $user_id nicht gefunden.\n";
            }
            return [
                'success' => false,
                'message' => "Keine Person mit Benutzer-ID $user_id vorhanden."
            ];
        }
    
        $tage = $this->personen[$user_id]->getTage();
    
        if (!isset($tage[$datum])) {
            if ($debug) {
                echo "❌ Kein Eintrag für das Datum $datum vorhanden.\n";
            }
            return [
                'success' => false,
                'message' => "Kein Eintrag für Datum $datum vorhanden."
            ];
        }
    
        if (!isset($tage[$datum][$main_shift_id])) {
            if ($debug) {
                echo "❌ Kein Eintrag für Main-Shift-ID $main_shift_id am $datum vorhanden.\n";
            }
            return [
                'success' => false,
                'message' => "Kein Eintrag für Datum $datum und Main-Shift-ID $main_shift_id vorhanden."
            ];
        }
    
        if ($debug) {
            echo "🔍 Starte Löschvorgang für shift_id $shift_id...\n";
        }
    
        return $tage[$datum][$main_shift_id]->loeschePauseBlockMitID(
            $shift_id,
            $user_id,
            $debug // Wichtig: Debug-Flag weitergeben!
        );
    }
    
    

    public function convertFreeToGap(
        $user_id,
        $datum,
        $api_key,
        $location_id,
        $virtual_workingarea_id,
        $haupt_start_user_time,
        $haupt_end_user_time,
        $tag_gap_id,
        ContentManager $contentManager
    ) {
        if (!isset($this->personen[$user_id])) {
            return [
                'success' => false,
                'message' => "Fehler: Keine Termine für Benutzer-ID $user_id vorhanden."
            ];
        }

        return $this->personen[$user_id]->convertFreeToGap(
            $datum,
            $api_key,
            $location_id,
            $virtual_workingarea_id,
            "$haupt_start_user_time",
            "$haupt_end_user_time",
            $tag_gap_id,
            $contentManager
        );
    }

    public function loescheTermin($user_id, $datum, $main_shift_id, $shift_id) {
        if (!isset($this->personen[$user_id])) {
            echo "Fehler: Keine Termine für Benutzer-ID $user_id vorhanden.<br>";
            return false;
        }
        return $this->personen[$user_id]->loescheTermin($datum, $main_shift_id, $shift_id);
    }

    public function zeigeAlleTageProPerson() {
        foreach ($this->personen as $user_id => $verwaltung) {
            echo "<h2>Termine für Benutzer-ID: $user_id</h2>";
            $verwaltung->zeigeAlleTage();
            echo "<br>";
        }
    }

    public function getPersonAlsArray($user_id) {
        if (!isset($this->personen[$user_id])) {
            return [];
        }
        $result = [];
        $tagesVerwaltung = $this->personen[$user_id];
        foreach ($tagesVerwaltung->getTage() as $datum => $liste) {
            $result[$datum] = $tagesVerwaltung->getTagAlsArray($datum);
        }
        return $result;
    }
    

    public function getListeFuerTag($user_id, $datum) {
        if (!isset($this->personen[$user_id]) || !isset($this->personen[$user_id]->getTage()[$datum])) {
            return null;
        }
        return $this->personen[$user_id]->getTage()[$datum];
    }
}
