<?php

include_once "log.php";
include_once "globals.php";

set_time_limit(0);
date_default_timezone_set('Europe/Berlin');

/* ----------------------------------------------------------------- */
/*                       GET-Parameter verarbeiten                   */
$startOffset = isset($_GET['start']) ? (int)$_GET['start'] : 0;
$endOffset = isset($_GET['end']) ? (int)$_GET['end'] : 1;
/* ----------------------------------------------------------------- */


/* ----------------------------------------------------------------- */
/*                              RangeTime                            */

$timeZone = 'Europe/Berlin';
$date = new DateTime('today', new DateTimeZone($timeZone));
// $now = new DateTime(); // aktuelle Zeit
$now = new DateTime('now', new DateTimeZone('Europe/Berlin'));


//Datenbank Delete Time
$datenbank_vorgestern = clone $date;
$datenbank_vorgestern->sub(new DateInterval("P2D"))->setTime(0, 0, 0);
$datenbank_vorgestern = $datenbank_vorgestern->format('Y-m-d H:i:s');

// Datum berechnen
$dateRange = calculateDateRangeWithYesterday($date, $startOffset, $endOffset);

$rangeStartYesterday = $dateRange['yesterdayDate'];
$rangeStart = $dateRange['startDate'];
$rangeEnd = $dateRange['endDate'];

$rangeStartYesterdayMitZeit = $dateRange['yesterdayDateTime'];
$rangeStartMitZeit = $dateRange['startDateTime'];
$rangeEndMitZeit = $dateRange['endDateTime'];
register_shutdown_function(function () {
    $error = error_get_last();
    if ($error) {
        echo "<pre>";
        echo "Das Skript wurde unterbrochen. Letzter Fehler:\n";
        print_r($error);
        echo "</pre>";
    } else {
        echo "Das Skript wurde erfolgreich ausgeführt oder beendet.";
    }
    exit; 
});
/* ----------------------------------------------------------------- */
/* ----------------------------------------------------------------- */
/*                          Beispielverwendung                       */
echo"rangeStart\n";
echo "<br>";
echo $rangeStart;
echo "<br>";
echo"rangeEnd\n";
echo "<br>";
echo $rangeEnd;
echo "<br>";
echo"rangeStartMitZeit\n";
echo "<br>";
echo $rangeStartMitZeit;
echo "<br>";
echo"rangeEndMitZeit\n";
echo "<br>";
echo $rangeEndMitZeit;
echo "<br>";
echo"rangeStartYesterday\n";
echo "<br>";
echo $rangeStartYesterday;
echo "<br>";
echo"rangeStartYesterdayMitZeit\n";
echo "<br>";
echo $rangeStartYesterdayMitZeit;
echo "<br>";
// Aktuelle Zeitzone ausgeben
echo 'Globale Standardzeitzone: ' . date_default_timezone_get() . "<br>";
echo 'Einstellung in php.ini: ' . ini_get('date.timezone') . "<br>";


if (date_default_timezone_get()) {
    echo 'date_default_timezone_set: ' . date_default_timezone_get() . '<br />';
}

if (ini_get('date.timezone')) {
    echo 'date.timezone: ' . ini_get('date.timezone');
}
echo "<br>";
/* ----------------------------------------------------------------- */
/* ----------------------------------------------------------------- */
/*                       Local helper functions                      */
/**
* Berechnet das Startdatum, Enddatum und das Datum vom Tag zuvor (gestern).
*
* @param DateTime $date Das Basisdatum
* @param int $startOffset Anzahl der Tage ab heute für das Startdatum
* @param int $endOffset Anzahl der Tage ab Startdatum für das Enddatum
* @return array Ein Array mit 'yesterdayDate', 'startDate', 'endDate' und ihren Zeitformaten
*/
function calculateDateRangeWithYesterday(DateTime $date, int $startOffset = 0, int $endOffset = 99): array {
    // Gestern (ein Tag vor dem Startdatum)
    $yesterdayDate = clone $date;
    $startyesterday = $startOffset + 1;
    $yesterdayDate = $yesterdayDate->sub( new DateInterval ("P{$startyesterday}D"))->setTime(00, 00, 00);
    // $yesterdayDate = $yesterdayDate->modify(($startOffset - 1) . ' days')->setTime(00, 00, 00);
    $rangeStartYesterday = $yesterdayDate->format('Y-m-d');
    $rangeStartYesterdayMitZeit = $yesterdayDate->format('Y-m-d\TH:i:s');

    // Startdatum
    $startDate = clone $date;
    $startDate = $startDate->add( new DateInterval ("P{$startOffset}D"))->setTime(00, 00, 00);
    // $startDate = $startDate->modify("$startOffset days")->setTime(00, 00, 00);
    $rangeStart = $startDate->format('Y-m-d');
    $rangeStartMitZeit = $startDate->format('Y-m-d\TH:i:s');

    // Enddatum
    $endDate = clone $date;
    $endDate = $endDate->add( new DateInterval ("P{$endOffset}D"))->setTime(23, 59, 59);
    // $endDate = $endDate->modify("+$endOffset days")->setTime(23, 59, 59);
    $rangeEnd = $endDate->format('Y-m-d');
    $rangeEndMitZeit = $endDate->format('Y-m-d\TH:i:s');

    return [
        'yesterdayDate' => $rangeStartYesterday,
        'yesterdayDateTime' => $rangeStartYesterdayMitZeit,
        'startDate' => $rangeStart,
        'startDateTime' => $rangeStartMitZeit,
        'endDate' => $rangeEnd,
        'endDateTime' => $rangeEndMitZeit,
    ];
}

// Timer-Hilfsfunktion
function startTimer() {
    return microtime(true);
}

function stopTimerForFunctions($startTime, $taskName) {
    $duration = microtime(true) - $startTime;
    echo "<pre>$taskName dauerte: " . round($duration, 4) . " Sekunden</pre>";
}
function stopTimerForLogs($startTime) {
    $duration = microtime(true) - $startTime;
    $duration = (int) $duration ;
    return $duration;
}

/* ----------------------------------------------------------------- */